package com.ejianc.business.tender.cost.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 采购计划控制规则
 * 
 * @author generator
 * 
 */
 @TableName("ejc_plan_control_rule")
public class PlanControlRuleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="enabled")
    private Integer enabled; // 1:启用/0:停用
    @TableField(value="description")
    private String description; // 描述
    @TableField(value="control_type")
    private Integer controlType; // 1柔性2刚性
    @TableField(value="bill_type")
    private Integer billType; // 1集团2项目
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="planControlRuleDetailService",pidName = "pId")
    private List<PlanControlRuleDetailEntity> planControlRuleDetailList = new ArrayList<>(); // 采购计划控制规则登记
    @TableField(exist=false)
    @SubEntity(serviceName="planControlRuleDetailTypeService",pidName = "pId")
    private List<PlanControlRuleDetailTypeEntity> planControlRuleDetailTypeList = new ArrayList<>(); // 采购计划控制规则子表

    public List<PlanControlRuleDetailTypeEntity> getPlanControlRuleDetailTypeList() {
        return planControlRuleDetailTypeList;
    }

    public void setPlanControlRuleDetailTypeList(List<PlanControlRuleDetailTypeEntity> planControlRuleDetailTypeList) {
        this.planControlRuleDetailTypeList = planControlRuleDetailTypeList;
    }

    public Integer getEnabled() {
        return enabled;
    }

    public void setEnabled(Integer enabled) {
        this.enabled = enabled;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public Integer getControlType() {
        return controlType;
    }

    public void setControlType(Integer controlType) {
        this.controlType = controlType;
    }
    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    

    public List<PlanControlRuleDetailEntity> getPlanControlRuleDetailList() {
        return planControlRuleDetailList;
    }

    public void setPlanControlRuleDetailList(List<PlanControlRuleDetailEntity> planControlRuleDetailList) {
        this.planControlRuleDetailList = planControlRuleDetailList;
    }
}
