package com.ejianc.business.tender.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 变更状态
 */
public enum TenderSignStatusEnum {
    /**
     */
    未签订(0, "未签订"),

    /**
     */
    部分签订(1, "部分签订"),

    /**
     */
    全部已签(2, "全部已签"),

    /**
     */
    已关闭(3, "已关闭");

    private Integer code;
    private String description;
    private static Map<Integer, TenderSignStatusEnum> enumMap = new HashMap<>();

    TenderSignStatusEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(TenderSignStatusEnum.class).stream().collect(Collectors.toMap(TenderSignStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static TenderSignStatusEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
