package com.ejianc.business.tender.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentExpertEntity;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentExpertMapper;
import com.ejianc.business.tender.equipment.service.IEquipmentDocumentExpertService;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentExpertVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 招标文件专家表
 * 
 * @author generator
 * 
 */
@Service("equipmentDocumentExpertService")
public class EquipmentDocumentExpertServiceImpl extends BaseServiceImpl<EquipmentDocumentExpertMapper, EquipmentDocumentExpertEntity> implements IEquipmentDocumentExpertService {

    @Override
    public List<EquipmentDocumentExpertEntity> addBatch(EquipmentDocumentVO equipmentDocumentVO) {

        //先删后增
        LambdaQueryWrapper<EquipmentDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(EquipmentDocumentExpertEntity::getDocumentId,equipmentDocumentVO.getId());
        super.remove(expertWrapper);

        //新增
        List<EquipmentDocumentExpertVO> expertVOList = equipmentDocumentVO.getExpertVOList();
        if(CollectionUtils.isNotEmpty(expertVOList)){
            for (EquipmentDocumentExpertVO equipmentDocument: expertVOList){
                equipmentDocument.setDocumentId(equipmentDocumentVO.getId());
                equipmentDocument.setId(null);
            }
            List<EquipmentDocumentExpertEntity> equipmentDocumentExpertEntities = BeanMapper.mapList(expertVOList, EquipmentDocumentExpertEntity.class);
            super.saveBatch(equipmentDocumentExpertEntities);
            return equipmentDocumentExpertEntities;
        }

        return null;
    }

    @Override
    public List<EquipmentDocumentExpertEntity> deleteByIds(List<Long> vos) {
        Long pk = vos.stream().findFirst().get();
        EquipmentDocumentExpertEntity equipmentDocumentExpertEntity = super.selectById(pk);
        Long documentId = equipmentDocumentExpertEntity.getDocumentId();
        super.removeByIds(vos,true);
        LambdaQueryWrapper<EquipmentDocumentExpertEntity> expertWrapper = Wrappers.lambdaQuery();
        expertWrapper.eq(EquipmentDocumentExpertEntity::getDocumentId,documentId);
        List<EquipmentDocumentExpertEntity> list = super.list(expertWrapper);
        return list;
    }
}
