package com.ejianc.business.tender.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentDocumentSellMapper;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.other.bean.OtherInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailBidderEntity;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.equipment.vo.EquipmentDocumentSellVO;
import com.ejianc.business.tender.stuff.bean.StuffDocumentSellEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageRefsupplierEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 招标文件报价表
 * 
 * @author generator
 * 
 */
@Service("equipmentDocumentSellService")
public class EquipmentDocumentSellServiceImpl extends BaseServiceImpl<EquipmentDocumentSellMapper, EquipmentDocumentSellEntity> implements IEquipmentDocumentSellService {
    @Autowired
    private IEquipmentPicketageService equipmentPicketageService;
    @Autowired
    private IEquipmentInviteDetailBidderService bidderService;
    @Autowired
    private IEquipmentInviteDetailRecordService recordService;
    @Autowired
    private IEquipmentPicketageRefsupplierService equipmentPicketageRefsupplierService;



    @Override
    public List<EquipmentDocumentSellEntity> selectMaterialType(Long documentId) {
        return baseMapper.selectMaterialType(documentId);
    }

    @Override
    public List<EquipmentDocumentSellVO> queryListByIds(Long id) {
        EquipmentPicketageRefsupplierEntity equipmentPicketageRefsupplierEntity = equipmentPicketageRefsupplierService.selectById(id);
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOList = new ArrayList<>();
        List<EquipmentDocumentSellVO> equipmentDocumentSellVOS = new ArrayList<>();

        EquipmentPicketageEntity equipmentPicketageEntity = equipmentPicketageService.selectById(equipmentPicketageRefsupplierEntity.getPicketageId());
        //流程定标
        if (equipmentPicketageRefsupplierEntity.getPicketageFlag()==0){
            LambdaQueryWrapper<EquipmentDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
            listWrapper.eq(EquipmentDocumentSellEntity::getDocumentId,equipmentPicketageEntity.getDocumentId());
            listWrapper.eq(EquipmentDocumentSellEntity::getSupplierId,equipmentPicketageRefsupplierEntity.getSupplierId());
            if (equipmentPicketageRefsupplierEntity.getPurchaseType() == 0){
                listWrapper.eq(EquipmentDocumentSellEntity::getProjectId,equipmentPicketageRefsupplierEntity.getProjectId());
            }
            listWrapper.eq(EquipmentDocumentSellEntity::getTenderFlag,1);
            listWrapper.eq(EquipmentDocumentSellEntity::getPassFlag,1);
            List<EquipmentDocumentSellEntity> documentSellList = super.list(listWrapper);
            
            equipmentDocumentSellVOList = BeanMapper.mapList(documentSellList,EquipmentDocumentSellVO.class);
            for (EquipmentDocumentSellVO equipmentDocumentSellVO : equipmentDocumentSellVOList){
                BigDecimal tenderNum = equipmentDocumentSellVO.getTenderNum();
                BigDecimal signNum = equipmentDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : equipmentDocumentSellVO.getSignNum();
                equipmentDocumentSellVO.setSurplusNum(tenderNum.subtract(signNum));
            }
            equipmentDocumentSellVOS = equipmentDocumentSellVOList.stream().filter(s -> s.getSurplusNum().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());

        }
        //直接定标
        else if (equipmentPicketageRefsupplierEntity.getPicketageFlag()==1){
            List<EquipmentInviteDetailBidderEntity> bidderEntityList1 = bidderService.list(new QueryWrapper<EquipmentInviteDetailBidderEntity>().eq("invite_id", equipmentPicketageRefsupplierEntity.getPicketageId()).eq("supplier_id",equipmentPicketageRefsupplierEntity.getSupplierId()));
            List<EquipmentInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
            for (EquipmentInviteDetailBidderEntity bidderEntity : bidderEntityList) {
                EquipmentDocumentSellVO equipmentDocumentSellVO = new EquipmentDocumentSellVO();
                EquipmentInviteDetailRecordEntity recordEntity = recordService.selectById(bidderEntity.getInviteDetailId());
                equipmentDocumentSellVO.setId(bidderEntity.getId());
                equipmentDocumentSellVO.setProjectId(recordEntity.getDetailProjectId());
                equipmentDocumentSellVO.setProjectName(recordEntity.getDetailProjectName());
                equipmentDocumentSellVO.setMaterialId(recordEntity.getMaterialId());
                equipmentDocumentSellVO.setMaterialName(recordEntity.getMaterialName());
                equipmentDocumentSellVO.setMaterialCode(recordEntity.getMaterialCode());
                equipmentDocumentSellVO.setMaterialTypeId(recordEntity.getMaterialTypeId());
                equipmentDocumentSellVO.setMaterialTypeName(recordEntity.getMaterialTypeName());
                equipmentDocumentSellVO.setUnit(recordEntity.getUnit());
                equipmentDocumentSellVO.setSpec(recordEntity.getSpec());
                equipmentDocumentSellVO.setDetailId(bidderEntity.getId());
                equipmentDocumentSellVO.setSupplierId(bidderEntity.getSupplierId());
                equipmentDocumentSellVO.setSupplierName(bidderEntity.getSupplierName());
                equipmentDocumentSellVO.setBrand(bidderEntity.getBrand());
                equipmentDocumentSellVO.setPrice(bidderEntity.getPrice());
                equipmentDocumentSellVO.setPriceTax(bidderEntity.getTaxPrice());
                equipmentDocumentSellVO.setRate(bidderEntity.getTaxBidderRate());
                equipmentDocumentSellVO.setTenderNum(bidderEntity.getNum());
                equipmentDocumentSellVO.setTenderMoney(bidderEntity.getMoney());
                equipmentDocumentSellVO.setTenderMoneyTax(bidderEntity.getTaxMoney());
                equipmentDocumentSellVO.setSellTax(bidderEntity.getTaxBidder());
                equipmentDocumentSellVO.setSignNum(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum());
                equipmentDocumentSellVO.setSurplusNum(bidderEntity.getNum().subtract(bidderEntity.getSignNum() == null ? BigDecimal.ZERO : bidderEntity.getSignNum()));
                equipmentDocumentSellVOS.add(equipmentDocumentSellVO);
            }
        }
        return equipmentDocumentSellVOS;
    }
}
