package com.ejianc.business.tender.equipment.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.service.*;
import com.ejianc.business.tender.equipment.bean.*;
import com.ejianc.business.tender.equipment.mapper.EquipmentNoticeDetailMapper;
import com.ejianc.business.tender.equipment.mapper.EquipmentNoticeMapper;
import com.ejianc.business.tender.equipment.vo.*;
import com.ejianc.business.tender.equipment.vo.EquipmentNoticeSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffNoticeDetailVO;
import com.ejianc.business.tender.util.SMS;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.tools.ant.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
@Service("equipmentNoticeService")
public class EquipmentNoticeServiceImpl extends BaseServiceImpl<EquipmentNoticeMapper, EquipmentNoticeEntity> implements IEquipmentNoticeService {

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IEquipmentNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private EquipmentNoticeDetailMapper equipmentNoticeDetailMapper;

    @Autowired
    private IEquipmentNoticeSupplierService supplierService;

    @Autowired
    private IEquipmentInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IEquipmentInviteSupplierService inviteSupplierService;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        baseMapper.updateEndTime(noticeId,newTime);
    }

    @Transactional
    @Override
    public CommonResponse publish(EquipmentNoticeVO equipmentNoticeVO) throws InvocationTargetException, IllegalAccessException {
        //插入主表数据
        EquipmentNoticeEntity equipmentNoticeEntity = baseMapper.selectById(equipmentNoticeVO.getId());
        EquipmentInviteEntity inviteEntity = inviteService.selectById(equipmentNoticeEntity.getInviteId());
        equipmentNoticeEntity.setPublishFlag(0);
        baseMapper.updateById(equipmentNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        EquipmentNoticeSupplierTbVO equipmentNoticeSupplierTbVO = new EquipmentNoticeSupplierTbVO();
        BeanUtils.copyProperties(equipmentNoticeSupplierTbVO, equipmentNoticeEntity);
        equipmentNoticeSupplierTbVO.setNoticeStartTime(sdf.format(equipmentNoticeEntity.getNoticeStartTime()));
        equipmentNoticeSupplierTbVO.setNoticeEndTime(sdf.format(equipmentNoticeEntity.getNoticeEndTime()));
        equipmentNoticeSupplierTbVO.setNoticeType(0);
        if (equipmentNoticeEntity.getPurchaseType()==1){
            equipmentNoticeSupplierTbVO.setSourceProjectId(null);
        }else {
            equipmentNoticeSupplierTbVO.setSourceProjectId(equipmentNoticeEntity.getProjectId().toString());
        }
        equipmentNoticeSupplierTbVO.setSourceId(equipmentNoticeEntity.getInviteId().toString());
        equipmentNoticeSupplierTbVO.setSourceType("郑州一建招标公告");
        equipmentNoticeSupplierTbVO.setSourceOrgId(equipmentNoticeEntity.getOrgId().toString());
        equipmentNoticeSupplierTbVO.setSourceUnitId(equipmentNoticeEntity.getUnitId().toString());
        equipmentNoticeSupplierTbVO.setType("PURCHASE");
        equipmentNoticeSupplierTbVO.setTenderName(equipmentNoticeEntity.getNoticeName());
        equipmentNoticeSupplierTbVO.setSourceEmployeeId(equipmentNoticeEntity.getEmployeeId().toString());
        equipmentNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        equipmentNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        equipmentNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        equipmentNoticeSupplierTbVO.setId(null);
        equipmentNoticeSupplierTbVO.setCreateTime(null);
        equipmentNoticeSupplierTbVO.setUpdateTime(null);
        equipmentNoticeSupplierTbVO.setCreateUserCode(null);
        equipmentNoticeSupplierTbVO.setUpdateUserCode(null);
        equipmentNoticeSupplierTbVO.setSyncEsFlag(null);
        equipmentNoticeSupplierTbVO.setVersion(null);
        equipmentNoticeSupplierTbVO.setTenantId(null);
        equipmentNoticeSupplierTbVO.setDr(null);
        //插入物资
//        List<EquipmentNoticeDetailEntity> noticeDetailEntityList = equipmentNoticeDetailMapper.selectList(new LambdaQueryWrapper<EquipmentNoticeDetailEntity>().eq(EquipmentNoticeDetailEntity::getNoticeId, equipmentNoticeVO.getId()));
        List<EquipmentNoticeDetailVO> noticeDetailEntityList =  equipmentNoticeDetailMapper.selectSumDetail(equipmentNoticeVO.getId());
        List<EquipmentNoticeDetailTbVO> equipmentNoticeDetailVOS = new ArrayList<>();
        for (EquipmentNoticeDetailVO equipmentNoticeDetailEntity : noticeDetailEntityList) {
            EquipmentNoticeDetailTbVO equipmentNoticeDetailTbVO = new EquipmentNoticeDetailTbVO();
            BeanUtils.copyProperties(equipmentNoticeDetailTbVO, equipmentNoticeDetailEntity);
            equipmentNoticeDetailTbVO.setSourceId(equipmentNoticeEntity.getInviteId().toString());
            equipmentNoticeDetailTbVO.setSourceMaterialId(equipmentNoticeDetailEntity.getMaterialId()==null?null: equipmentNoticeDetailEntity.getMaterialId().toString());
            equipmentNoticeDetailTbVO.setSourceMaterialTypeId(equipmentNoticeDetailEntity.getMaterialTypeId()==null?null: equipmentNoticeDetailEntity.getMaterialTypeId().toString());
            equipmentNoticeDetailVOS.add(equipmentNoticeDetailTbVO);

        }
        equipmentNoticeSupplierTbVO.setPurchaseDetailList(equipmentNoticeDetailVOS);
        //是否是邀请招标
        if (equipmentNoticeVO.getTenderType()==1){
            List<EquipmentNoticeSupplierDetailEntity> detailEntityList = noticeSupplierDetailService.list(new LambdaQueryWrapper<EquipmentNoticeSupplierDetailEntity>().eq(EquipmentNoticeSupplierDetailEntity::getInviteId, equipmentNoticeEntity.getInviteId()).eq(EquipmentNoticeSupplierDetailEntity::getDr, 0));
            List<EquipmentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (EquipmentNoticeSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                EquipmentNoticeSupplierDetailTbVO equipmentNoticeSupplierDetailTbVO = new EquipmentNoticeSupplierDetailTbVO();
                equipmentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                equipmentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo 暂时写死
                equipmentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(equipmentNoticeSupplierDetailTbVO);
            }
            equipmentNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        //调用第三方接口
//        CommonResponse<JSONObject> response = null;
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, JSON.toJSONString(equipmentNoticeSupplierTbVO),cacheManager);
//            if(!response.isSuccess()) {
//                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            return CommonResponse.error("调用平台报名接口失败");
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(equipmentNoticeSupplierTbVO), appId,appSecret,appHost);
            //邀请招标推送成功后发送短信通知
            //1.判断是否为邀请招标
            if (equipmentNoticeEntity.getTenderType() == 1) {
                //2.获取手机号及其发送内容
                List<EquipmentInviteSupplierEntity> detailEntityList = inviteSupplierService.list(new LambdaQueryWrapper<EquipmentInviteSupplierEntity>().eq(EquipmentInviteSupplierEntity::getInviteId, equipmentNoticeEntity.getInviteId()).eq(EquipmentInviteSupplierEntity::getDr, 0));
                List<EquipmentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
                for (EquipmentInviteSupplierEntity supplierDetailEntity : detailEntityList) {
                    String mobile = supplierDetailEntity.getMobile();
                    //供方平台地址
                    String url = "https://test.17elian.com/sso/login?service=https%3A%2F%2Ftest.17elian.com%2Fportal%2Fsso%2Flogin";
                    String context = "邀请您参加[" + equipmentNoticeEntity.getProjectName() + "]举行的投标报名,";
                    context += "报名截止日期：" + DateUtils.format(equipmentNoticeEntity.getNoticeEndTime(),"yyyy-MM-dd hh:mm:ss") + ";";
                    context += "招标联系人：" + equipmentNoticeEntity.getEmployeeName() + ";";
                    context += "联系方式：" + equipmentNoticeEntity.getEmployeeMobile() + ";";
                    context += "详情请登录系统进行查看" + url;
                    String end = " 【郑州一建】";
                    context+=end;
                    if(mobile != null){
                        //3.发送消息
                        SMS.setSendSms(mobile, context);
                    }
                }

            }
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("公告信息推送成功");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<EquipmentNoticeEntity>().eq(EquipmentNoticeEntity::getInviteId,sourceId)).getId();
    }

    @Override
    public boolean selectFile(EquipmentNoticeVO vo) {
        List<EquipmentNoticeSupplierEntity> noticeSupplierEntityList = supplierService.list(new QueryWrapper<EquipmentNoticeSupplierEntity>().eq("notice_id", vo.getId()).eq("dr", 0));
        List<EquipmentNoticeSupplierVO> equipmentNoticeSupplierVOS = BeanMapper.mapList(noticeSupplierEntityList, EquipmentNoticeSupplierVO.class);
        //处理供应商附件信息
        if (CollectionUtils.isNotEmpty(equipmentNoticeSupplierVOS)){
            List<Long> attachIds = equipmentNoticeSupplierVOS.stream().map(EquipmentNoticeSupplierVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds",attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId),Function.identity());
                    Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                    for (EquipmentNoticeSupplierVO equipmentNoticeSupplierVO : equipmentNoticeSupplierVOS){
                        List<AttachmentVO> attachmentVOList = attacMap.get(equipmentNoticeSupplierVO.getId());
                        if (attachmentVOList!=null){
                            ArrayList<Map<String, Object>> list = new ArrayList<>();
                            for (AttachmentVO attachmentVO : attachmentVOList) {
                                HashMap<String, Object> hashMap = new HashMap<>();
                                hashMap.put("attachId",attachmentVO.getId());
                                hashMap.put("name",attachmentVO.getFileName());
                                list.add(hashMap);
                            }
                            equipmentNoticeSupplierVO.setFile(list);
                        }else {
                            equipmentNoticeSupplierVO.setAttachId(null);
                            equipmentNoticeSupplierVO.setFileName(null);
                        }
                    }
                }
            }
            vo.setNoticeSupplierDetail(equipmentNoticeSupplierVOS);
        }
        return true;
    }
}
