package com.ejianc.business.tender.expert.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.tender.expert.bean.ExperienceDetailEntity;
import com.ejianc.business.tender.expert.bean.EducationDetailEntity;
import com.ejianc.business.tender.expert.bean.EvaluationDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 专家库主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tender_expert")
public class ExpertEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态
    @TableField(value="state")
    private java.lang.Integer state; // 状态（0：启用，1：停用）
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编码
    @TableField(value="unit_id")
    private java.lang.Long unitId; // 单位id
    @TableField(value="unit_name")
    private java.lang.String unitName; // 单位名称
    @TableField(value="expert_id")
    private java.lang.Long expertId; // 专家id
    @TableField(value="expert_name")
    private java.lang.String expertName; // 专家名称
    @TableField(value="mobile")
    private java.lang.String mobile; // 手机号
    @TableField(value="email")
    private java.lang.String email; // 邮箱
    @TableField(value="year_limit")
    private java.math.BigDecimal yearLimit; // 从业年限
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 编制人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 编制人名称
    @TableField(value="employee_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date employeeTime; // 编制日期
    @TableField(value="sex")
    private java.lang.Integer sex;//性别（0-男，1-女）
    @TableField(value="grade_id")
    private java.lang.Long gradeId; // 级别id
    @TableField(value="grade_name")
    private java.lang.String gradeName; // 级别name
    @TableField(value="birthday")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date birthday; // 出生日期
    @TableField(value="type")
    private java.lang.Integer type; // 类型(0-商务，1-技术，2-商务技术)
    @TableField(value="type_name")
    private java.lang.String typeName; // 类型name
    @TableField(value="telephone")
    private java.lang.String telephone; // 固定电话
    @TableField(value="idcard")
    private java.lang.String idcard; // 身份证号码
    @TableField(value="post_id")
    private java.lang.Long postId; // 岗位id
    @TableField(value="post_name")
    private java.lang.String postName; // 岗位名称
    @TableField(value="empno")
    private java.lang.String empno; // 工号
    @TableField(value="interior_exterior")
    private java.lang.Integer interiorExterior; // 内外部(0-内部，1-外部)
    @TableField(value="field_id")
    private java.lang.String fieldId; // 专业领域id
    @TableField(value="field_name")
    private java.lang.String fieldName; // 专业领域name
    @TableField(value="old_expert_id")
    private java.lang.Long oldExpertId; // 老专家id
    @TableField(value="dept_id")
    private java.lang.Long deptId; // 部门id
    @TableField(value="dept_name")
    private java.lang.String deptName; // 部门名称
    @TableField(value="expert_from")
    private java.lang.Long expertFrom; // 专家来源(例如：集团、项目)
    @TableField(value="expert_from_name")
    private java.lang.String expertFromName; // 专家来源名称

    @TableField(exist=false)
    @SubEntity(serviceName="experienceDetailService",pidName = "expertId")
    private List<ExperienceDetailEntity> experienceDetailEntities = new ArrayList<>(); // 专家库工作履历表
    @TableField(exist=false)
    @SubEntity(serviceName="educationDetailService",pidName = "expertId")
    private List<EducationDetailEntity> educationDetailEntities = new ArrayList<>(); // 专家库教育经历表
    @TableField(exist=false)
    @SubEntity(serviceName="evaluationDetailService",pidName = "expertId")
    private List<EvaluationDetailEntity> evaluationDetailEntities = new ArrayList<>(); // 专家库评标记录表

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getOldExpertId() {
        return oldExpertId;
    }

    public void setOldExpertId(Long oldExpertId) {
        this.oldExpertId = oldExpertId;
    }

    // 级别id
    public Long getGradeId() {
        return gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }
    // 级别name
    public String getGradeName() {
        return gradeName;
    }

    public void setGradeName(String gradeName) {
        this.gradeName = gradeName;
    }
    // 类型
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    // 类型name
    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    // 专业领域id
    public String getFieldId() {
        return fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }
    // 专业领域name
    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    //性别（0-男，1-女）
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    // 出生日期
    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }
    // 固定电话
    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }
    // 身份证号码
    public String getIdcard() {
        return idcard;
    }

    public void setIdcard(String idcard) {
        this.idcard = idcard;
    }
    // 岗位id
    public Long getPostId() {
        return postId;
    }

    public void setPostId(Long postId) {
        this.postId = postId;
    }
    // 岗位名称
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    // 工号
    public String getEmpno() {
        return empno;
    }

    public void setEmpno(String empno) {
        this.empno = empno;
    }
    // 内外部(0-内部，1-外部)
    public Integer getInteriorExterior() {
        return interiorExterior;
    }

    public void setInteriorExterior(Integer interiorExterior) {
        this.interiorExterior = interiorExterior;
    }

    /**
     * 单据状态
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 状态（0：启用，1：停用）
     */
    public java.lang.Integer getState() {
        return state;
    }

    /**
     * 状态（0：启用，1：停用）
     */
    public void setState(java.lang.Integer state) {
        this.state = state;
    }
    /**
     * 单据编码
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单位id
     */
    public java.lang.Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(java.lang.Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 单位名称
     */
    public java.lang.String getUnitName() {
        return unitName;
    }

    /**
     * 单位名称
     */
    public void setUnitName(java.lang.String unitName) {
        this.unitName = unitName;
    }
    /**
     * 专家id
     */
    public java.lang.Long getExpertId() {
        return expertId;
    }

    /**
     * 专家id
     */
    public void setExpertId(java.lang.Long expertId) {
        this.expertId = expertId;
    }
    /**
     * 专家名称
     */
    public java.lang.String getExpertName() {
        return expertName;
    }

    /**
     * 专家名称
     */
    public void setExpertName(java.lang.String expertName) {
        this.expertName = expertName;
    }
    /**
     * 手机号
     */
    public java.lang.String getMobile() {
        return mobile;
    }

    /**
     * 手机号
     */
    public void setMobile(java.lang.String mobile) {
        this.mobile = mobile;
    }
    /**
     * 邮箱
     */
    public java.lang.String getEmail() {
        return email;
    }

    /**
     * 邮箱
     */
    public void setEmail(java.lang.String email) {
        this.email = email;
    }
    /**
     * 编制日期
     */
    public java.util.Date getEmployeeTime() {
        return employeeTime;
    }

    /**
     * 编制日期
     */
    public void setEmployeeTime(java.util.Date employeeTime) {
        this.employeeTime = employeeTime;
    }
    /**
     * 从业年限
     */
    public java.math.BigDecimal getYearLimit() {
        return yearLimit;
    }

    /**
     * 从业年限
     */
    public void setYearLimit(java.math.BigDecimal yearLimit) {
        this.yearLimit = yearLimit;
    }
    /**
     * 编制人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 编制人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 编制人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 编制人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    
    /**
     * 专家库工作履历表
     */
    public List<ExperienceDetailEntity> getExperienceDetailEntities() {
        return experienceDetailEntities;
    }

    /**
     * 专家库工作履历表
     */
    public void setExperienceDetailEntities(List<ExperienceDetailEntity> experienceDetailEntities) {
        this.experienceDetailEntities = experienceDetailEntities;
    }
    /**
     * 专家库教育经历表
     */
    public List<EducationDetailEntity> getEducationDetailEntities() {
        return educationDetailEntities;
    }

    /**
     * 专家库教育经历表
     */
    public void setEducationDetailEntities(List<EducationDetailEntity> educationDetailEntities) {
        this.educationDetailEntities = educationDetailEntities;
    }
    /**
     * 专家库评标记录表
     */
    public List<EvaluationDetailEntity> getEvaluationDetailEntities() {
        return evaluationDetailEntities;
    }

    /**
     * 专家库评标记录表
     */
    public void setEvaluationDetailEntities(List<EvaluationDetailEntity> evaluationDetailEntities) {
        this.evaluationDetailEntities = evaluationDetailEntities;
    }

    /**
     * 专家来源
     */
    public Long getExpertFrom() {
        return expertFrom;
    }

    public void setExpertFrom(Long expertFrom) {
        this.expertFrom = expertFrom;
    }
    /**
     * 专家来源名称
     */
    public String getExpertFromName() {
        return expertFromName;
    }

    public void setExpertFromName(String expertFromName) {
        this.expertFromName = expertFromName;
    }
}
