package com.ejianc.business.tender.expert.mapper;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.expert.vo.ExpertEvaluatingVO;
import com.ejianc.business.tender.expert.vo.ProgressSheetVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.tender.expert.bean.ExpertEvaluatingEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 材料专家评标主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ExpertEvaluatingMapper extends BaseCrudMapper<ExpertEvaluatingEntity> {

    List<ExpertEvaluatingVO> queryPendingList(@Param("page") Page<ExpertEvaluatingVO> page, @Param("searchText") String searchText, @Param("evaluationState") Integer evaluationState, @Param("evaluationState1") Integer evaluationState1, @Param("employeeId") String employeeId);
    @Update("UPDATE `ejc_tender_expert_evaluating_detail` SET evaluation_state = #{evaluationState},evaluation_time = #{evaluationTime}  WHERE evaluation_id = #{id} and expert_id=#{employeeId}")
    Boolean updateState(@Param("evaluationState") Integer evaluationState, @Param("id") Long id, @Param("employeeId") Long employeeId, DateTime evaluationTime);

    List<ExpertEvaluatingVO> queryGatherList(@Param("page") Page<ExpertEvaluatingVO> page, @Param("searchText") String searchText, @Param("gatherStatus") Integer gatherStatus, @Param("employeeId") Long employeeId);

    List<ProgressSheetVO> queryProgressSheet(@Param(Constants.WRAPPER) QueryWrapper queryWrapper,@Param("page") Page<ProgressSheetVO> page);
}
