package com.ejianc.business.tender.expert.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tender.expert.bean.ExpertRecordEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordScoreEntity;
import com.ejianc.business.tender.expert.bean.ExpertRecordScoreHistoryEntity;
import com.ejianc.business.tender.expert.mapper.ExpertRecordScoreHistoryMapper;
import com.ejianc.business.tender.expert.mapper.ExpertRecordScoreMapper;
import com.ejianc.business.tender.expert.service.IExpertRecordScoreHistoryService;
import com.ejianc.business.tender.expert.service.IExpertRecordService;
import com.ejianc.business.tender.expert.vo.*;
import com.ejianc.business.tender.expert.vo.ExpertRecordHistoryVO;
import com.ejianc.business.tender.expert.vo.ExpertRecordHistoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.tender.expert.mapper.ExpertRecordHistoryMapper;
import com.ejianc.business.tender.expert.bean.ExpertRecordHistoryEntity;
import com.ejianc.business.tender.expert.service.IExpertRecordHistoryService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 评标记录历史表
 *
 * @author generator
 *
 */
@Service("expertRecordHistoryService")
public class ExpertRecordHistoryServiceImpl extends BaseServiceImpl<ExpertRecordHistoryMapper, ExpertRecordHistoryEntity> implements IExpertRecordHistoryService{
    @Autowired
    private IExpertRecordHistoryService service;
    @Autowired
    private IExpertRecordScoreHistoryService recordScoreHistoryService;
    @Autowired
    ExpertRecordScoreHistoryMapper scoreHistoryMapper;

    @Override
    public List<List<ExpertRecordHistoryVO>> queryDetail(Long totalId, Long evaluationId, Long expertId) {
        List<List<ExpertRecordHistoryVO>> lists = new ArrayList<>();
        List<ExpertRecordHistoryEntity> recordEntityList = service.list(new QueryWrapper<ExpertRecordHistoryEntity>().eq("evaluation_id", evaluationId).eq("employee_id", expertId).eq("total_id",totalId));
        List<ExpertRecordHistoryVO> recordVOList = BeanMapper.mapList(recordEntityList, ExpertRecordHistoryVO.class);
        List<ExpertRecordHistoryVO> recordVOList1;
        Map<Long,List<ExpertRecordHistoryVO>> addMap = new HashMap<>();
        for (ExpertRecordHistoryVO recordVO : recordVOList) {
            // 是否已经添加，添加过的取原来的方案list，在后添加方案，否则就是新的list
            boolean addFlag = addMap.containsKey(recordVO.getSupplierId());
            if (addFlag){
                recordVOList1 = addMap.get(recordVO.getSupplierId());
            } else {
                recordVOList1 = new ArrayList<>();
            }
            //查出所有子表数据
            List<ExpertRecordScoreHistoryEntity> scoreVOList = service.selectScore(recordVO.getId());
            List<ExpertRecordScoreHistoryVO> scoreVOList2 = BeanMapper.mapList(scoreVOList, ExpertRecordScoreHistoryVO.class);
            for (ExpertRecordScoreHistoryVO expertRecordScoreVO : scoreVOList2) {
                List<ExpertRecordScoreHistoryVO>  scoreVOList3 = service.selectByParentId(expertRecordScoreVO.getScoringTemplateDetailParentId(),recordVO.getId());
                expertRecordScoreVO.setExpertRecordScoreVOList(scoreVOList3);
            }
            recordVO.setStuffRecordScoreVos(scoreVOList2);
            recordVOList1.add(recordVO);
            // 未添加到map，代表首次查询，添加到map中
            if (!addFlag) {
                addMap.put(recordVO.getSupplierId(),recordVOList1);
            }
//            lists.add(recordVOList1);
        }
        // 循环处理供应商及报价信息
        for (Map.Entry<Long,List<ExpertRecordHistoryVO>> entry: addMap.entrySet()) {
            lists.add(entry.getValue());
        }
        return lists;
    }

    @Override
    public List<ExpertRecordScoreHistoryEntity> selectScore(Long id) {
        return scoreHistoryMapper.selectList(new QueryWrapper<ExpertRecordScoreHistoryEntity>().eq("record_id", id).eq("dr", 0).isNotNull("scoring_template_detail_id"));
    }

    @Override
    public List<ExpertRecordScoreHistoryVO> selectByParentId(Long scoringTemplateDetailParentId, Long id) {
        return BeanMapper.mapList(recordScoreHistoryService.list(new QueryWrapper<ExpertRecordScoreHistoryEntity>().eq("scoring_template_detail_parent_id",scoringTemplateDetailParentId).eq("record_id",id).isNull("scoring_template_detail_id")),ExpertRecordScoreHistoryVO.class);
    }
}
