package com.ejianc.business.tender.other.controller;

import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.vo.OtherPicketageSupplierVO;
import com.ejianc.business.tender.other.vo.OtherPicketageVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 定标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("otherPicketage")
@Api(value = "定标主表", tags = {"定标主表"})
public class OtherPicketageController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-picketage-code";//此处需要根据实际修改

    @Autowired
    private IOtherPicketageService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherPicketageVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody OtherPicketageVO saveorUpdateVO) {
        OtherPicketageVO otherPicketageVO = service.saveOrUpdates(saveorUpdateVO);
    	return CommonResponse.success("初始化基础数据成功！",otherPicketageVO);
    }
    @ApiOperation("新增或者修改子表供应商")
    @RequestMapping(value = "/saveSupplierBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OtherPicketageVO> saveSupplierBatch(@RequestBody OtherPicketageVO saveorUpdateVO) {
        OtherPicketageVO otherPicketageVO = service.saveSupplierBatch(saveorUpdateVO);
        return CommonResponse.success("更新成功！",otherPicketageVO);
    }
    @ApiOperation("专家评标下一步接口")
    @RequestMapping(value = "/savePicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherPicketageVO> savePicketage(@RequestParam Long evaluationId) {
        OtherPicketageVO otherPicketageVO = service.savePicketage(evaluationId);
        return CommonResponse.success("初始化基础数据成功！",otherPicketageVO);
    }
    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherPicketageVO> queryDetail(@RequestParam Long id) {
        OtherPicketageVO otherPicketageVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",otherPicketageVO);
    }

    @ApiOperation("紧急招标询价等下一步接口")
    @RequestMapping(value = "/saveManyPicketage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OtherPicketageVO> saveManyPicketage(@RequestParam Long documentId) {
        OtherPicketageVO otherPicketageVO = service.saveManyPicketage(documentId);
        return CommonResponse.success("初始化基础数据成功！",otherPicketageVO);
    }

    @ApiOperation("查询供应商列表详情")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OtherPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
        List<OtherPicketageSupplierVO> list = service.querySupplierList(picketageId);
        return CommonResponse.success("查询详情数据成功！",list);
    }


}
