package com.ejianc.business.tender.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.other.bean.OtherPicketageRefsupplierEntity;
import com.ejianc.business.tender.other.mapper.OtherPicketageRefsupplierMapper;
import com.ejianc.business.tender.other.service.IOtherInviteService;
import com.ejianc.business.tender.other.service.IOtherPicketageRefsupplierService;
import com.ejianc.business.tender.other.service.IOtherPicketageService;
import com.ejianc.business.tender.other.bean.OtherInviteEntity;
import com.ejianc.business.tender.other.bean.OtherPicketageEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 * 
 * @author generator
 * 
 */
@Service("otherPicketageRefsupplierService")
public class OtherPicketageRefsupplierServiceImpl extends BaseServiceImpl<OtherPicketageRefsupplierMapper, OtherPicketageRefsupplierEntity> implements IOtherPicketageRefsupplierService {
    @Autowired
    private IOtherPicketageService otherPicketageService;
    @Autowired
    private IOtherInviteService otherInviteService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    @Override
    public String updateById(Long id,Integer occupyFlag) {
//        占用状态0-未占用,1-已占用,2-已完成
        OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = super.selectById(id);
        otherPicketageRefsupplierEntity.setOccupyFlag(occupyFlag);
        super.updateById(otherPicketageRefsupplierEntity);
        return "更新成功!";
    }
    @Override
    @Transactional
    public String updateStatus(TenderPicketageVO tenderPicketageVO, Integer type) {
        logger.info("修改类型"+type);
        String stringFb = JSONObject.toJSONString(tenderPicketageVO);
        logger.info("其他定标占用参数"+stringFb);
        OtherPicketageRefsupplierEntity otherPicketageRefsupplierEntity = super.selectById(tenderPicketageVO.getId());
        //picketageFlag 定标类型0-流程定标,1-直接定标

        Integer picketageFlag = otherPicketageRefsupplierEntity.getPicketageFlag();
        if (type == 1){
            tenderPicketageVO.setContractMoney(tenderPicketageVO.getContractMoney().negate());
            tenderPicketageVO.setContractMoneyTax(tenderPicketageVO.getContractMoneyTax().negate());
            List<TenderPicketageDetailVO> detailList = tenderPicketageVO.getTenderPicketageDetailList();
            for (TenderPicketageDetailVO tenderPicketageDetailVO : detailList){
                tenderPicketageDetailVO.setSignNum(tenderPicketageDetailVO.getSignNum().negate());
            }
        }
        OtherPicketageEntity otherPicketageEntity = otherPicketageService.selectById(otherPicketageRefsupplierEntity.getPicketageId());
        OtherInviteEntity otherInviteEntity = null;
        if(picketageFlag == 0){
            otherInviteEntity = otherInviteService.selectById(otherPicketageEntity.getInviteId());
        }
        if(picketageFlag == 1){
            otherInviteEntity = otherInviteService.selectById(otherPicketageRefsupplierEntity.getPicketageId());
        }

        //根据子表id更新签订数量
        List<TenderPicketageDetailVO> tenderPicketageDetailList = tenderPicketageVO.getTenderPicketageDetailList();
        List<Long> sellIds = tenderPicketageDetailList.stream().map(TenderPicketageDetailVO::getId).collect(Collectors.toList());
        Map<Long, TenderPicketageDetailVO> detailVOMap = tenderPicketageDetailList.stream().collect(Collectors.toMap(TenderPicketageDetailVO::getId, Function.identity()));
        Boolean allSign = null;
        Boolean anySign = null;


        //更新参照表状态
        BigDecimal contractMoney = otherPicketageRefsupplierEntity.getContractMoney() == null ? BigDecimal.ZERO : otherPicketageRefsupplierEntity.getContractMoney();
        BigDecimal contractMoneyTax = otherPicketageRefsupplierEntity.getContractMoneyTax() == null ? BigDecimal.ZERO : otherPicketageRefsupplierEntity.getContractMoneyTax();
        otherPicketageRefsupplierEntity.setContractMoney(contractMoney.add(tenderPicketageVO.getContractMoney()));
        otherPicketageRefsupplierEntity.setContractMoneyTax(contractMoneyTax.add(tenderPicketageVO.getContractMoneyTax()));
        if (otherPicketageRefsupplierEntity.getContractMoneyTax().compareTo(otherPicketageRefsupplierEntity.getMoneyTax())  > -1){
            otherPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.全部已签.getCode());
        }
        if (otherPicketageRefsupplierEntity.getContractMoneyTax().compareTo(otherPicketageRefsupplierEntity.getMoneyTax()) == -1){
            otherPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.部分签订.getCode());
        }
        if (otherPicketageRefsupplierEntity.getContractMoneyTax().compareTo(BigDecimal.ZERO) == 0){
            otherPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
        }
        super.updateById(otherPicketageRefsupplierEntity);

        //更新招标状态
        LambdaQueryWrapper<OtherPicketageRefsupplierEntity> lambdaRef = Wrappers.<OtherPicketageRefsupplierEntity>lambdaQuery();
        lambdaRef.eq(OtherPicketageRefsupplierEntity::getPicketageId, otherPicketageRefsupplierEntity.getPicketageId());
        List<OtherPicketageRefsupplierEntity> picketageRefsupplierList = super.list(lambdaRef);
        //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
        Boolean inviteWSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.未签订.getCode());
        Boolean inviteAllSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.全部已签.getCode());
        Boolean inviteAllCloseSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.已关闭.getCode());
        Integer signStatus = null;
        if (inviteWSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (inviteAllSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }
        if (!inviteWSign && !inviteAllSign && !inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }
        otherInviteEntity.setSignStatus(signStatus);
        //更新参照表状态
        otherInviteService.updateById(otherInviteEntity);

        return "更新成功";
    }
}
