package com.ejianc.business.tender.prosub.controller;

import com.ejianc.business.tender.prosub.bean.ProsubDocumentExpertEntity;
import com.ejianc.business.tender.prosub.service.IProsubDocumentExpertService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentExpertVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentVO;
import com.ejianc.business.tender.sub.bean.SubDocumentExpertEntity;
import com.ejianc.business.tender.sub.service.ISubDocumentExpertService;
import com.ejianc.business.tender.sub.vo.SubDocumentExpertVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * 招标文件专家表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("prosubDocumentExpert")
@Api(value = "招标文件专家表", tags = {"招标文件专家表"})
public class ProsubDocumentExpertController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IProsubDocumentExpertService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubDocumentExpertVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ProsubDocumentExpertVO saveOrUpdateVO) {
        ProsubDocumentExpertEntity entity = BeanMapper.map(saveOrUpdateVO, ProsubDocumentExpertEntity.class);
    	service.saveOrUpdate(entity, false);
        ProsubDocumentExpertVO vo = BeanMapper.map(entity, ProsubDocumentExpertVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubDocumentExpertVO> queryDetail(@RequestParam Long id) {
        ProsubDocumentExpertEntity entity = service.selectById(id);
        ProsubDocumentExpertVO vo = BeanMapper.map(entity, ProsubDocumentExpertVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量新增")
    @RequestMapping(value = "/addBatch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ProsubDocumentExpertEntity>> addBatch(@RequestBody ProsubDocumentVO subDocumentVO) {
        List<ProsubDocumentExpertEntity> list = service.addBatch(subDocumentVO);
        return CommonResponse.success("新增成功！",list);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deleteByIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ProsubDocumentExpertEntity>> deleteByIds(@RequestBody List<Long> vos) {
        List<ProsubDocumentExpertEntity> list = service.deleteByIds(vos);

        return CommonResponse.success("删除成功！",list);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




}
