package com.ejianc.business.tender.prosub.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.pricelib.vo.PriceContractCollectVO;
import com.ejianc.business.tender.prosub.bean.ProsubInviteDetailEntity;
import com.ejianc.business.tender.prosub.bean.ProsubInviteEntity;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailBidderVO;
import com.ejianc.business.tender.prosub.vo.ProsubInviteDetailVO;
import com.ejianc.business.tender.sub.bean.SubInviteDetailEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubInviteDetailVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * 材料立项主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface ProsubInviteMapper extends BaseCrudMapper<ProsubInviteEntity> {
    @Update("UPDATE ejc_tender_prosub_invite SET tender_stage = #{tenderStage} WHERE id = #{id} ")
    void updateTenderStage(String id, int tenderStage);
    @Update("UPDATE ejc_tender_prosub_invite SET abolish_type = #{abolishType} WHERE id = #{id} ")
    void updateAbolishType(String id, int abolishType);
    @Select("SELECT *,sum(num) sum_num,sum(tax_mny) sum_money_tax,sum(mny) sum_money,SUM(plan_num) sum_plan_num ,sum(tax) sum_tax,GROUP_CONCAT(memo) sum_memo " +
            "FROM `ejc_tender_prosub_invite_detail_record` where invite_id = #{inviteId} and dr = 0 and id not in " +
            "(SELECT parent_id FROM `ejc_tender_prosub_invite_detail_record`  where  invite_id = #{inviteId} and  parent_id is not null) " +
            "GROUP BY doc_category_id,doc_id,detail_project_id,tax_rate,rule,content")
    List<ProsubInviteDetailVO> selectSumDetail(Long inviteId);
    @Select("SELECT *,sum(num) sum_num,sum(tax_mny) sum_money_tax,sum(mny) sum_money,SUM(plan_num) sum_plan_num ,sum(tax) sum_tax,GROUP_CONCAT(memo) sum_memo    " +
            "FROM `ejc_tender_prosub_invite_detail_record` " +
            "where invite_id = #{inviteId} and dr =0 GROUP BY doc_category_id,doc_id,detail_org_id,tax_rate,rule,content")
    List<ProsubInviteDetailVO> selectOrgSumDetail(Long inviteId);
    @Select("SELECT sum(mny) sum_money ,sum(tax_mny) sum_tax_money ,sum(num) sum_num FROM `ejc_tender_prosub_invite_detail_bidder` where invite_id = #{inviteId} and dr = 0 and id not in " +
            "(SELECT parent_id FROM `ejc_tender_prosub_invite_detail_bidder`  where  invite_id = #{inviteId} and  parent_id is not null)")
    List<ProsubInviteDetailBidderVO> selectDetailBidder(Long inviteId);
    @Select("SELECT * FROM `ejc_tender_prosub_invite_detail_record` where invite_id = #{inviteId} and dr = 0 and id not in " +
            "(SELECT parent_id FROM `ejc_tender_prosub_invite_detail_record` where  invite_id = #{inviteId} and  parent_id is not null) ORDER BY tree_index ")
    List<ProsubInviteDetailBidderVO> querySonDetail(Long inviteId);


    /**
     * 根据档案id到劳务分包价格库查询历史价格
     * @param ids
     * @return
     */
    Page<PriceContractCollectVO> queryHistoryPrice(Page<PriceContractCollectVO> page, @Param("ids") List<Long> ids);

}
