package com.ejianc.business.tender.prosub.service;

import com.ejianc.business.tender.prosub.bean.ProsubDocumentEntity;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentRecordVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSupplierSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentVO;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.vo.SubDocumentRecordVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSupplierSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

/**
 * 招标文件主表
 * 
 * @author generator
 * 
 */
public interface IProsubDocumentService extends IBaseService<ProsubDocumentEntity> {

    ProsubDocumentVO publishDocument(Long id) throws Exception;

    ProsubDocumentVO bidDocument(Long id);

    ProsubDocumentVO queryDetail(Long id);

    ProsubDocumentVO queryDocDetail(Long id, Integer talkNum);
    ProsubDocumentVO queryDocDetailTalk(Long id,Integer talkNum);

    List<ProsubDocumentSellVO> getSchemeDetail(ProsubDocumentSellVO subDocumentSellVO);

    ProsubDocumentSupplierSellVO getSupplierSchemeDetail(Long supplierDetailId, Long documentId);

    ProsubDocumentVO extendDocument(ProsubDocumentRecordVO subDocumentRecordVO);

    ProsubDocumentSupplierSellVO getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId);

    ProsubDocumentVO publishManyDocument(Long id) throws InvocationTargetException, IllegalAccessException;

    CommonResponse delSupplier(Long id);

    ProsubDocumentVO saveManyDocument(Long id);

    ProsubDocumentSupplierSellVO getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId);

    ProsubDocumentVO saveDocument(Long noticeId);

    ProsubDocumentVO queryDetailNum(Long documentId);

    Boolean supplierPushSell(HttpServletRequest request, MultipartFile file);

    String uploadById(Long attachId, Long inviteId);

    String deleteFileById(Long sourceId, List<String> fileNames);

    ProsubDocumentSupplierSellVO getSupplierSchemeDetailDb(Long schemeId, Long documentId);

    ProsubDocumentVO saveOrUpdate(ProsubDocumentVO saveorUpdateVO);

    ProsubDocumentVO queryDetail1(Long documentId, Integer num);

    /**
     * 检查所选专家数量
     * 规则：
     *      1.集团专家、项目专家比例1:2，集团专家向上取整
     *      2.评标专家数必须为单数
     * @param documentId
     * @return
     */
    CommonResponse<Boolean> checkExpertNum(Long documentId);



    Boolean localPushSell(Map<String,Object> params, MultipartFile file);

    CommonResponse<Boolean> synSupplier(Long documentId);



    /**
     * 检验是否进行过报价
     * @param supplierId
     * @param documentId
     * @param phone
     * @return
     */
    Boolean checkDetail(Long supplierId, Long documentId,String phone);

}
