package com.ejianc.business.tender.prosub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.prosub.bean.*;
import com.ejianc.business.tender.prosub.mapper.ProsubInviteDetailMapper;
import com.ejianc.business.tender.prosub.mapper.ProsubNoticeMapper;
import com.ejianc.business.tender.prosub.service.*;
import com.ejianc.business.tender.prosub.vo.*;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.vo.SubNoticeDetailVO;
import com.ejianc.business.tender.util.SMS;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.tools.ant.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
@Service("prosubNoticeService")
public class ProsubNoticeServiceImpl extends BaseServiceImpl<ProsubNoticeMapper, ProsubNoticeEntity> implements IProsubNoticeService {

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IProsubNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private IProsubInviteSupplierService inviteSupplierService;

    @Autowired
    private ProsubInviteDetailMapper subInviteDetailMapper;

    @Autowired
    private IProsubNoticeSupplierService supplierService;

    @Autowired
    private IProsubInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        baseMapper.updateEndTime(noticeId,newTime);
    }

    @Transactional
    @Override
    public CommonResponse publish(ProsubNoticeVO subNoticeVO) throws InvocationTargetException, IllegalAccessException {
        //插入主表数据
        ProsubNoticeEntity subNoticeEntity = baseMapper.selectById(subNoticeVO.getId());
        ProsubInviteEntity inviteEntity = inviteService.selectById(subNoticeEntity.getInviteId());
        subNoticeEntity.setPublishFlag(0);
        baseMapper.updateById(subNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ProsubNoticeSupplierTbVO subNoticeSupplierTbVO = new ProsubNoticeSupplierTbVO();
        BeanUtils.copyProperties(subNoticeSupplierTbVO, subNoticeEntity);
        subNoticeSupplierTbVO.setNoticeStartTime(sdf.format(subNoticeEntity.getNoticeStartTime()));
        subNoticeSupplierTbVO.setNoticeEndTime(sdf.format(subNoticeEntity.getNoticeEndTime()));
        subNoticeSupplierTbVO.setNoticeType(0);
        if (subNoticeEntity.getPurchaseType()==1){
            subNoticeSupplierTbVO.setSourceProjectId(null);
        }else {
            subNoticeSupplierTbVO.setSourceProjectId(subNoticeEntity.getProjectId().toString());
        }
        subNoticeSupplierTbVO.setSourceId(subNoticeEntity.getInviteId().toString());
        subNoticeSupplierTbVO.setSourceType("郑州一建招标公告");
        subNoticeSupplierTbVO.setSourceOrgId(subNoticeEntity.getOrgId().toString());
        subNoticeSupplierTbVO.setSourceUnitId(subNoticeEntity.getUnitId().toString());
        subNoticeSupplierTbVO.setType("SUB");
        subNoticeSupplierTbVO.setTenderName(subNoticeEntity.getNoticeName());
        subNoticeSupplierTbVO.setSourceEmployeeId(subNoticeEntity.getEmployeeId().toString());
        subNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        subNoticeSupplierTbVO.setId(null);
        subNoticeSupplierTbVO.setCreateTime(null);
        subNoticeSupplierTbVO.setUpdateTime(null);
        subNoticeSupplierTbVO.setCreateUserCode(null);
        subNoticeSupplierTbVO.setUpdateUserCode(null);
        subNoticeSupplierTbVO.setSyncEsFlag(null);
        subNoticeSupplierTbVO.setVersion(null);
        subNoticeSupplierTbVO.setTenantId(null);
        subNoticeSupplierTbVO.setDr(null);
        subNoticeSupplierTbVO.setSubType(inviteEntity.getSubType());
        subNoticeSupplierTbVO.setProjectQualification(inviteEntity.getProjectQualification());
        subNoticeSupplierTbVO.setPaymentId(inviteEntity.getPaymentId());
        subNoticeSupplierTbVO.setPaymentName(inviteEntity.getPaymentName());
        subNoticeSupplierTbVO.setPayScale(inviteEntity.getPayScale());
        subNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        subNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        //插入物资
//        List<ProsubInviteDetailEntity> inviteDetailEntityList = subInviteDetailMapper.selectList(new LambdaQueryWrapper<ProsubInviteDetailEntity>().eq(ProsubInviteDetailEntity::getInviteId, inviteEntity.getId()));
//        List<ProsubNoticeDetailEntity> noticeDetailEntityList = BeanMapper.mapList(inviteDetailEntityList, ProsubNoticeDetailEntity.class);
//        List<ProsubNoticeDetailEntity> noticeDetailEntityList = subNoticeDetailMapper.selectList(new LambdaQueryWrapper<ProsubNoticeDetailEntity>().eq(ProsubNoticeDetailEntity::getNoticeId, subNoticeVO.getId()));
        List<ProsubNoticeDetailVO> noticeDetailEntityList = subInviteDetailMapper.selectSumDetail(subNoticeVO.getId());


        List<ProsubNoticeDetailTbVO> subNoticeDetailVOS = new ArrayList<>();
        for (ProsubNoticeDetailVO subNoticeDetailEntity : noticeDetailEntityList) {
            ProsubNoticeDetailTbVO subNoticeDetailTbVO = new ProsubNoticeDetailTbVO();
            BeanUtils.copyProperties(subNoticeDetailTbVO, subNoticeDetailEntity);
            subNoticeDetailTbVO.setSourceId(subNoticeEntity.getInviteId().toString());
            subNoticeDetailTbVO.setSourceDetailId(String.valueOf(subNoticeDetailEntity.getId()));
            subNoticeDetailTbVO.setRate(subNoticeDetailEntity.getTaxRate());


            subNoticeDetailTbVO.setMemo(subNoticeDetailEntity.getSumMemo());
            subNoticeDetailTbVO.setNum(subNoticeDetailEntity.getSumNum());
            subNoticeDetailTbVO.setMny(subNoticeDetailEntity.getSumMoney());
            subNoticeDetailTbVO.setTaxMny(subNoticeDetailEntity.getSumMoneyTax());
            subNoticeDetailTbVO.setInfoPrice(subNoticeDetailEntity.getInfoPrice());

            subNoticeDetailVOS.add(subNoticeDetailTbVO);

        }
        subNoticeSupplierTbVO.setSubDetailList(subNoticeDetailVOS);
        //是否是邀请招标
        if (subNoticeVO.getTenderType()==1){
            List<ProsubInviteSupplierEntity> detailEntityList = inviteSupplierService.list(new LambdaQueryWrapper<ProsubInviteSupplierEntity>().eq(ProsubInviteSupplierEntity::getInviteId, subNoticeEntity.getInviteId()).eq(ProsubInviteSupplierEntity::getDr, 0));
            List<ProsubNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (ProsubInviteSupplierEntity supplierDetailEntity : detailEntityList) {
                ProsubNoticeSupplierDetailTbVO subNoticeSupplierDetailTbVO = new ProsubNoticeSupplierDetailTbVO();
                subNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                subNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo 暂时写死
                subNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(subNoticeSupplierDetailTbVO);
            }
            subNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        //调用第三方接口
//        CommonResponse<JSONObject> response = null;
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, JSON.toJSONString(subNoticeSupplierTbVO),cacheManager);
//            if(!response.isSuccess()) {
//                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            return CommonResponse.error("调用平台报名接口失败");
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(subNoticeSupplierTbVO), appId,appSecret,appHost);
            //邀请招标推送成功后发送短信通知
            //1.判断是否为邀请招标
            if (subNoticeEntity.getTenderType() == 1) {
                //2.获取手机号及其发送内容
                List<ProsubInviteSupplierEntity> detailEntityList = inviteSupplierService.list(new LambdaQueryWrapper<ProsubInviteSupplierEntity>().eq(ProsubInviteSupplierEntity::getInviteId, subNoticeEntity.getInviteId()).eq(ProsubInviteSupplierEntity::getDr, 0));
                List<ProsubNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
                for (ProsubInviteSupplierEntity supplierDetailEntity : detailEntityList) {
                    String mobile = supplierDetailEntity.getMobile();
                    //供方平台地址
                    String url = "https://test.17elian.com/sso/login?service=https%3A%2F%2Ftest.17elian.com%2Fportal%2Fsso%2Flogin";
                    String context = "邀请您参加[" + subNoticeEntity.getProjectName() + "]举行的投标报名,";
                    context += "报名截止日期：" + DateUtils.format(subNoticeEntity.getNoticeEndTime(),"yyyy-MM-dd hh:mm:ss") + ";";
                    context += "招标联系人：" + subNoticeEntity.getEmployeeName() + ";";
                    context += "联系方式：" + subNoticeEntity.getEmployeeMobile() + ";";
                    context += "详情请登录系统进行查看" + url;
                    String end = " 【郑州一建】";
                    context+=end;
                    if(mobile != null){
                        //3.发送消息
                        SMS.setSendSms(mobile, context);
                    }
                }

            }
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("公告信息推送成功");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<ProsubNoticeEntity>().eq(ProsubNoticeEntity::getInviteId,sourceId)).getId();
    }

    @Override
    public boolean selectFile(ProsubNoticeVO vo) {
        List<ProsubNoticeSupplierEntity> noticeSupplierEntityList = supplierService.list(new QueryWrapper<ProsubNoticeSupplierEntity>().eq("notice_id", vo.getId()).eq("dr", 0));
        List<ProsubNoticeSupplierVO> subNoticeSupplierVOS = BeanMapper.mapList(noticeSupplierEntityList, ProsubNoticeSupplierVO.class);
        //处理供应商附件信息
        if (CollectionUtils.isNotEmpty(subNoticeSupplierVOS)){
            List<Long> attachIds = subNoticeSupplierVOS.stream().map(ProsubNoticeSupplierVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds",attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId),Function.identity());
                    Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                    for (ProsubNoticeSupplierVO subNoticeSupplierVO : subNoticeSupplierVOS){
                        List<AttachmentVO> attachmentVOList = attacMap.get(subNoticeSupplierVO.getId());
                        if (attachmentVOList!=null){
                            ArrayList<Map<String, Object>> list = new ArrayList<>();
                            for (AttachmentVO attachmentVO : attachmentVOList) {
                                HashMap<String, Object> hashMap = new HashMap<>();
                                hashMap.put("attachId",attachmentVO.getId());
                                hashMap.put("name",attachmentVO.getFileName());
                                list.add(hashMap);
                            }
                            subNoticeSupplierVO.setFile(list);
                        }else {
                            subNoticeSupplierVO.setAttachId(null);
                            subNoticeSupplierVO.setFileName(null);
                        }
                    }
                }
            }
            vo.setNoticeSupplierDetail(subNoticeSupplierVOS);
        }
        return true;
    }
}
