package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.tender.rent.service.*;
import com.ejianc.business.tender.rent.vo.RentNoticeSupplierVO;
import com.ejianc.business.tender.rent.vo.*;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.bean.*;
import com.ejianc.business.tender.rent.mapper.RentNoticeDetailMapper;
import com.ejianc.business.tender.rent.mapper.RentNoticeMapper;
import com.ejianc.business.tender.stuff.vo.StuffNoticeDetailVO;
import com.ejianc.business.tender.util.SMS;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.tools.ant.util.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 招标公告主表
 * 
 * @author generator
 * 
 */
@Service("rentNoticeService")
public class RentNoticeServiceImpl extends BaseServiceImpl<RentNoticeMapper, RentNoticeEntity> implements IRentNoticeService {

    @Value("${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value("${gysUrl.appId}")
    private String appId;
    @Value("${gysUrl.appSecret}")
    private String appSecret;
    @Value("${gysUrl.appHost}")
    private String appHost;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IRentNoticeSupplierDetailService noticeSupplierDetailService;

    @Autowired
    private RentNoticeDetailMapper rentNoticeDetailMapper;

    @Autowired
    private IRentNoticeSupplierService supplierService;

    @Autowired
    private IRentInviteService inviteService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IRentInviteSupplierService inviteSupplierService;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public void updateEndTime(Long noticeId, Date newTime) {
        baseMapper.updateEndTime(noticeId,newTime);
    }

    @Transactional
    @Override
    public CommonResponse publish(RentNoticeVO rentNoticeVO) throws InvocationTargetException, IllegalAccessException {
        //插入主表数据
        RentNoticeEntity rentNoticeEntity = baseMapper.selectById(rentNoticeVO.getId());
        RentInviteEntity inviteEntity = inviteService.selectById(rentNoticeEntity.getInviteId());
        rentNoticeEntity.setPublishFlag(0);
        baseMapper.updateById(rentNoticeEntity);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        RentNoticeSupplierTbVO rentNoticeSupplierTbVO = new RentNoticeSupplierTbVO();
        BeanUtils.copyProperties(rentNoticeSupplierTbVO, rentNoticeEntity);
        rentNoticeSupplierTbVO.setNoticeStartTime(sdf.format(rentNoticeEntity.getNoticeStartTime()));
        rentNoticeSupplierTbVO.setNoticeEndTime(sdf.format(rentNoticeEntity.getNoticeEndTime()));
        rentNoticeSupplierTbVO.setNoticeType(0);
        if (rentNoticeEntity.getPurchaseType()==1){
            rentNoticeSupplierTbVO.setSourceProjectId(null);
        }else {
            rentNoticeSupplierTbVO.setSourceProjectId(rentNoticeEntity.getProjectId().toString());
        }
        rentNoticeSupplierTbVO.setSourceId(rentNoticeEntity.getInviteId().toString());
        rentNoticeSupplierTbVO.setSourceType("郑州一建招标公告");
        rentNoticeSupplierTbVO.setSourceOrgId(rentNoticeEntity.getOrgId().toString());
        rentNoticeSupplierTbVO.setSourceUnitId(rentNoticeEntity.getUnitId().toString());
        rentNoticeSupplierTbVO.setType("RENT");
        rentNoticeSupplierTbVO.setTenderName(rentNoticeEntity.getNoticeName());
        rentNoticeSupplierTbVO.setSourceEmployeeId(rentNoticeEntity.getEmployeeId().toString());
        rentNoticeSupplierTbVO.setSystemId(proSupplierApi.getEjcCloudSystemCode().getData());
        rentNoticeSupplierTbVO.setMaterialContentId(inviteEntity.getPurchaseId());
        rentNoticeSupplierTbVO.setMaterialContent(inviteEntity.getPurchaseName());
        rentNoticeSupplierTbVO.setId(null);
        rentNoticeSupplierTbVO.setCreateTime(null);
        rentNoticeSupplierTbVO.setUpdateTime(null);
        rentNoticeSupplierTbVO.setCreateUserCode(null);
        rentNoticeSupplierTbVO.setUpdateUserCode(null);
        rentNoticeSupplierTbVO.setSyncEsFlag(null);
        rentNoticeSupplierTbVO.setVersion(null);
        rentNoticeSupplierTbVO.setTenantId(null);
        rentNoticeSupplierTbVO.setDr(null);
        //插入物资
//        List<RentNoticeDetailEntity> noticeDetailEntityList = rentNoticeDetailMapper.selectList(new LambdaQueryWrapper<RentNoticeDetailEntity>().eq(RentNoticeDetailEntity::getNoticeId, rentNoticeVO.getId()));
        List<RentNoticeDetailVO> noticeDetailEntityList =  rentNoticeDetailMapper.selectSumDetail(rentNoticeVO.getId());
        List<RentNoticeDetailTbVO> rentNoticeDetailVOS = new ArrayList<>();
        for (RentNoticeDetailVO rentNoticeDetailEntity : noticeDetailEntityList) {
            RentNoticeDetailTbVO rentNoticeDetailTbVO = new RentNoticeDetailTbVO();
            BeanUtils.copyProperties(rentNoticeDetailTbVO, rentNoticeDetailEntity);
            rentNoticeDetailTbVO.setNum(rentNoticeDetailEntity.getSumNum());
            rentNoticeDetailTbVO.setMoney(rentNoticeDetailEntity.getSumMoney());
            rentNoticeDetailTbVO.setMoneyTax(rentNoticeDetailEntity.getSumMoneyTax());
            rentNoticeDetailTbVO.setSourceId(rentNoticeEntity.getInviteId().toString());
            rentNoticeDetailTbVO.setSourceMaterialId(rentNoticeDetailEntity.getMaterialId()==null?null: rentNoticeDetailEntity.getMaterialId().toString());
            rentNoticeDetailTbVO.setSourceMaterialTypeId(rentNoticeDetailEntity.getMaterialTypeId()==null?null: rentNoticeDetailEntity.getMaterialTypeId().toString());
            rentNoticeDetailVOS.add(rentNoticeDetailTbVO);

        }
        rentNoticeSupplierTbVO.setRentDetailList(rentNoticeDetailVOS);
        //是否是邀请招标
        if (rentNoticeVO.getTenderType()==1){
            List<RentNoticeSupplierDetailEntity> detailEntityList = noticeSupplierDetailService.list(new LambdaQueryWrapper<RentNoticeSupplierDetailEntity>().eq(RentNoticeSupplierDetailEntity::getInviteId, rentNoticeEntity.getInviteId()).eq(RentNoticeSupplierDetailEntity::getDr, 0));
            List<RentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
            for (RentNoticeSupplierDetailEntity supplierDetailEntity : detailEntityList) {
                RentNoticeSupplierDetailTbVO rentNoticeSupplierDetailTbVO = new RentNoticeSupplierDetailTbVO();
                rentNoticeSupplierDetailTbVO.setSourceId(supplierDetailEntity.getInviteId().toString());
                rentNoticeSupplierDetailTbVO.setSourceSupplierId(supplierDetailEntity.getSupplierId().toString());
                //todo 暂时写死
                rentNoticeSupplierDetailTbVO.setTenantId(Long.valueOf(supplierDetailEntity.getSourceId()));
                supplierDetailTbVOList.add(rentNoticeSupplierDetailTbVO);
            }
            rentNoticeSupplierTbVO.setApplyList(supplierDetailTbVOList);
        }
        //调用第三方接口
//        CommonResponse<JSONObject> response = null;
//        try {
//            response = new ThirdSystemUtils().sendPostReq(tokenUrl,saveOrUpdateUrl, JSON.toJSONString(rentNoticeSupplierTbVO),cacheManager);
//            if(!response.isSuccess()) {
//                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//            return CommonResponse.error("调用平台报名接口失败");
//        }
        //调用第三方接口
        CommonResponse<String> response = null;
        try {
            response = systemDataPushService.exchangeDataWithUniversal(saveOrUpdateUrl, RequestMethod.POST, JSON.toJSONString(rentNoticeSupplierTbVO), appId,appSecret,appHost);
            //邀请招标推送成功后发送短信通知
            //1.判断是否为邀请招标
            if (rentNoticeEntity.getTenderType() == 1) {
                //2.获取手机号及其发送内容
                List<RentInviteSupplierEntity> detailEntityList = inviteSupplierService.list(new LambdaQueryWrapper<RentInviteSupplierEntity>().eq(RentInviteSupplierEntity::getInviteId, rentNoticeEntity.getInviteId()).eq(RentInviteSupplierEntity::getDr, 0));
                List<RentNoticeSupplierDetailTbVO> supplierDetailTbVOList = new ArrayList<>();
                for (RentInviteSupplierEntity supplierDetailEntity : detailEntityList) {
                    String mobile = supplierDetailEntity.getMobile();
                    //供方平台地址
                    String url = "https://test.17elian.com/sso/login?service=https%3A%2F%2Ftest.17elian.com%2Fportal%2Fsso%2Flogin";
                    String context = "邀请您参加[" + rentNoticeEntity.getProjectName() + "]举行的投标报名,";
                    context += "报名截止日期：" + DateUtils.format(rentNoticeEntity.getNoticeEndTime(),"yyyy-MM-dd hh:mm:ss") + ";";
                    context += "招标联系人：" + rentNoticeEntity.getEmployeeName() + ";";
                    context += "联系方式：" + rentNoticeEntity.getEmployeeMobile() + ";";
                    context += "详情请登录系统进行查看" + url;
                    String end = " 【郑州一建】";
                    context+=end;
                    if(mobile != null){
                        //3.发送消息
                        SMS.setSendSms(mobile, context);
                    }
                }

            }
            if (!response.isSuccess()){
                return CommonResponse.error("调用平台报名接口失败，" + response.getMsg());
            }
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.error("调用平台报名接口失败");
        }
        return CommonResponse.success("公告信息推送成功");
    }

    @Override
    public Long selectNotice(String sourceId) {
        return baseMapper.selectOne(new LambdaQueryWrapper<RentNoticeEntity>().eq(RentNoticeEntity::getInviteId,sourceId)).getId();
    }

    @Override
    public boolean selectFile(RentNoticeVO vo) {
        List<RentNoticeSupplierEntity> noticeSupplierEntityList = supplierService.list(new QueryWrapper<RentNoticeSupplierEntity>().eq("notice_id", vo.getId()).eq("dr", 0));
        List<RentNoticeSupplierVO> rentNoticeSupplierVOS = BeanMapper.mapList(noticeSupplierEntityList, RentNoticeSupplierVO.class);
        //处理供应商附件信息
        if (CollectionUtils.isNotEmpty(rentNoticeSupplierVOS)){
            List<Long> attachIds = rentNoticeSupplierVOS.stream().map(RentNoticeSupplierVO::getId).collect(Collectors.toList());
            Map<String, List<Long>> map = new HashMap<>();
            map.put("sourceIds",attachIds);
            JSONObject itemJSONObj = JSONObject.parseObject(JSON.toJSONString(map));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(itemJSONObj);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (CollectionUtils.isNotEmpty(data)){
//                    Map<Long, AttachmentVO> attacMap = data.stream().collect(Collectors.toMap(AttachmentVO::getSourceId),Function.identity());
                    Map<Long, List<AttachmentVO>> attacMap = data.stream().collect(Collectors.groupingBy(AttachmentVO::getSourceId));
                    for (RentNoticeSupplierVO rentNoticeSupplierVO : rentNoticeSupplierVOS){
                        List<AttachmentVO> attachmentVOList = attacMap.get(rentNoticeSupplierVO.getId());
                        if (attachmentVOList!=null){
                            ArrayList<Map<String, Object>> list = new ArrayList<>();
                            for (AttachmentVO attachmentVO : attachmentVOList) {
                                HashMap<String, Object> hashMap = new HashMap<>();
                                hashMap.put("attachId",attachmentVO.getId());
                                hashMap.put("name",attachmentVO.getFileName());
                                list.add(hashMap);
                            }
                            rentNoticeSupplierVO.setFile(list);
                        }else {
                            rentNoticeSupplierVO.setAttachId(null);
                            rentNoticeSupplierVO.setFileName(null);
                        }
                    }
                }
            }
            vo.setNoticeSupplierDetail(rentNoticeSupplierVOS);
        }
        return true;
    }
}
