package com.ejianc.business.tender.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.rmat.vo.RmatTalkDetailVO;
import com.ejianc.business.tender.rmat.vo.RmatTalkVO;
import com.ejianc.business.tender.rmat.bean.RmatTalkEntity;
import com.ejianc.business.tender.rmat.service.IRmatTalkService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 洽商谈判主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rmatTalk")
@Api(value = "洽商谈判主表", tags = {"洽商谈判主表"})
public class RmatTalkController implements Serializable {
	private static final long serialVersionUID = 1L;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-talk-code";//此处需要根据实际修改

    @Autowired
    private IRmatTalkService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatTalkVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody RmatTalkVO saveorUpdateVO) {
        RmatTalkVO rmatTalkVO = service.saveOrUpdates(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",rmatTalkVO);
    }

    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatTalkVO> publishTalk(@RequestParam Long id) {
        return CommonResponse.success("发布成功！",service.publishTalk(id));
    }
    @ApiOperation("延长截止时间接口")
    @RequestMapping(value = "/extendTalk", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RmatTalkVO> extendTalk(@RequestBody RmatTalkDetailVO rmatDocumentRecordVO) {
        return CommonResponse.success("延长截止时间成功！",service.extendTalk(rmatDocumentRecordVO));
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatTalkVO> queryDetail(@RequestParam Long id) {
        RmatTalkVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("其他单据点击下一步接口")
    @RequestMapping(value = "/saveTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatTalkVO> saveTalk(@RequestParam Long documentId) {
        return CommonResponse.success("保存成功！",service.saveTalk(documentId));
    }
    @ApiOperation("再次洽商")
    @RequestMapping(value = "/againSaveTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatTalkVO> againSaveTalk(@RequestParam Long id) {
        return CommonResponse.success("保存成功！",service.againSaveTalk(id));
    }
    @ApiOperation("下一步补充数据接口")
    @RequestMapping(value = "/replenishSell", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RmatTalkVO> replenishSell(@RequestParam Long id) {
        return CommonResponse.success("保存成功！",service.replenishSell(id));
    }
    @ApiOperation("获取供应商报价是否报全")
    @RequestMapping(value = "/getSellFull", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> getSellFull(@RequestParam Long id) {
        return CommonResponse.success("保存成功！",service.getSellFull(id));
    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RmatTalkVO> vos) {
        service.removeByIds(vos.stream().map(RmatTalkVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("多个供应商详情查询")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> querySupplierList(Long talkId) {
        return CommonResponse.success("查询成功！",service.querySupplierList(talkId));
    }
    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RmatTalkVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<RmatTalkEntity> page = service.queryPage(param,false);
        IPage<RmatTalkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RmatTalkVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RmatTalkEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("RmatTalk-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refRmatTalkData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RmatTalkVO>> refRmatTalkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RmatTalkEntity> page = service.queryPage(param,false);
        IPage<RmatTalkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RmatTalkVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
