package com.ejianc.business.tender.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageRefsupplierEntity;
import com.ejianc.business.tender.rmat.mapper.RmatPicketageRefsupplierMapper;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageRefsupplierService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 定标供应商参照表(下游单据使用)
 * 
 * @author generator
 * 
 */
@Service("rmatPicketageRefsupplierService")
public class RmatPicketageRefsupplierServiceImpl extends BaseServiceImpl<RmatPicketageRefsupplierMapper, RmatPicketageRefsupplierEntity> implements IRmatPicketageRefsupplierService {
    @Autowired
    private IRmatPicketageService rmatPicketageService;
    @Autowired
    private IRmatInviteService rmatInviteService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Transactional
    @Override
    public String updateById(Long id,Integer occupyFlag) {
//        占用状态0-未占用,1-已占用,2-已完成
        RmatPicketageRefsupplierEntity rmatPicketageRefsuppliermatity = super.selectById(id);
        rmatPicketageRefsuppliermatity.setOccupyFlag(occupyFlag);
        super.updateById(rmatPicketageRefsuppliermatity);
        return "更新成功!";
    }
    @Override
    @Transactional
    public String updateStatus(TenderPicketageVO tenderPicketageVO, Integer type) {
        logger.info("修改类型"+type);
        String stringFb = JSONObject.toJSONString(tenderPicketageVO);
        logger.info("周转材定标占用参数"+stringFb);
        RmatPicketageRefsupplierEntity rmatPicketageRefsupplierEntity = super.selectById(tenderPicketageVO.getId());
        //picketageFlag 定标类型0-流程定标,1-直接定标

        Integer picketageFlag = rmatPicketageRefsupplierEntity.getPicketageFlag();
        if (type == 1){
            tenderPicketageVO.setContractMoney(tenderPicketageVO.getContractMoney().negate());
            tenderPicketageVO.setContractMoneyTax(tenderPicketageVO.getContractMoneyTax().negate());
            List<TenderPicketageDetailVO> detailList = tenderPicketageVO.getTenderPicketageDetailList();
            for (TenderPicketageDetailVO tenderPicketageDetailVO : detailList){
                tenderPicketageDetailVO.setSignNum(tenderPicketageDetailVO.getSignNum().negate());
            }
        }
        RmatPicketageEntity rmatPicketageEntity = rmatPicketageService.selectById(rmatPicketageRefsupplierEntity.getPicketageId());
        RmatInviteEntity rmatInviteEntity = null;
        if(picketageFlag == 0){
            rmatInviteEntity = rmatInviteService.selectById(rmatPicketageEntity.getInviteId());
        }
        if(picketageFlag == 1){
            rmatInviteEntity = rmatInviteService.selectById(rmatPicketageRefsupplierEntity.getPicketageId());
        }

        //根据子表id更新签订数量
        List<TenderPicketageDetailVO> tenderPicketageDetailList = tenderPicketageVO.getTenderPicketageDetailList();
        List<Long> sellIds = tenderPicketageDetailList.stream().map(TenderPicketageDetailVO::getId).collect(Collectors.toList());
        Map<Long, TenderPicketageDetailVO> detailVOMap = tenderPicketageDetailList.stream().collect(Collectors.toMap(TenderPicketageDetailVO::getId, Function.identity()));

        //更新参照表状态
        BigDecimal contractMoney = rmatPicketageRefsupplierEntity.getContractMoney() == null ? BigDecimal.ZERO : rmatPicketageRefsupplierEntity.getContractMoney();
        BigDecimal contractMoneyTax = rmatPicketageRefsupplierEntity.getContractMoneyTax() == null ? BigDecimal.ZERO : rmatPicketageRefsupplierEntity.getContractMoneyTax();
        rmatPicketageRefsupplierEntity.setContractMoney(contractMoney.add(tenderPicketageVO.getContractMoney()));
        rmatPicketageRefsupplierEntity.setContractMoneyTax(contractMoneyTax.add(tenderPicketageVO.getContractMoneyTax()));
        if (rmatPicketageRefsupplierEntity.getContractMoneyTax().compareTo(rmatPicketageRefsupplierEntity.getMoneyTax())  > -1){
            rmatPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.全部已签.getCode());
        }
        if (rmatPicketageRefsupplierEntity.getContractMoneyTax().compareTo(rmatPicketageRefsupplierEntity.getMoneyTax()) == -1){
            rmatPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.部分签订.getCode());
        }
        if (rmatPicketageRefsupplierEntity.getContractMoneyTax().compareTo(BigDecimal.ZERO) == 0){
            rmatPicketageRefsupplierEntity.setSignStatus(TenderSignStatusEnum.未签订.getCode());
        }
        super.updateById(rmatPicketageRefsupplierEntity);

        //更新招标状态
        LambdaQueryWrapper<RmatPicketageRefsupplierEntity> lambdaRef = Wrappers.<RmatPicketageRefsupplierEntity>lambdaQuery();
        lambdaRef.eq(RmatPicketageRefsupplierEntity::getPicketageId, rmatPicketageRefsupplierEntity.getPicketageId());
        List<RmatPicketageRefsupplierEntity> picketageRefsupplierList = super.list(lambdaRef);
        //签订状态:0-未签订,1-部分签订,2-全部已签,3-已关闭
        Boolean inviteWSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.未签订.getCode());
        Boolean inviteAllSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.全部已签.getCode());
        Boolean inviteAllCloseSign = picketageRefsupplierList.stream().allMatch(e -> e.getSignStatus() == TenderSignStatusEnum.已关闭.getCode());
        Integer signStatus = null;
        if (inviteWSign) {
            signStatus = TenderSignStatusEnum.未签订.getCode();
        }
        if (inviteAllSign) {
            signStatus = TenderSignStatusEnum.全部已签.getCode();
        }
        if (inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.已关闭.getCode();
        }
        if (!inviteWSign && !inviteAllSign && !inviteAllCloseSign) {
            signStatus = TenderSignStatusEnum.部分签订.getCode();
        }

        rmatInviteEntity.setSignStatus(signStatus);
        //更新参照表状态
        rmatInviteService.updateById(rmatInviteEntity);

        return "更新成功";
    }
}
