package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.ejianc.business.tender.stuff.vo.StuffDocumentVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageSupplierVO;
import com.ejianc.business.tender.stuff.vo.StuffPicketageVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.tender.stuff.bean.StuffBidEntity;
import com.ejianc.business.tender.stuff.service.IStuffBidService;
import com.ejianc.business.tender.stuff.vo.StuffBidVO;

/**
 * 中标主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("stuffBid")
@Api(value = "中标主表", tags = {"中标主表"})
public class StuffBidController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-bid-code";//此处需要根据实际修改

    @Autowired
    private IStuffBidService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffBidVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody StuffBidVO saveorUpdateVO) {
    	StuffBidEntity entity = BeanMapper.map(saveorUpdateVO, StuffBidEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	StuffBidVO vo = BeanMapper.map(entity, StuffBidVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("生成中标通知书接口")
    @RequestMapping(value = "/saveBid", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffBidVO> saveBid(@RequestParam Long picketageId) {
        StuffBidVO stuffBidVO = service.saveBid(picketageId);
    	return CommonResponse.success("保存或修改单据成功！",stuffBidVO);
    }
    @ApiOperation("新增进展接口")
    @RequestMapping(value = "/insertProcess", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffPicketageVO> insertProcess(@RequestParam Long picketageId) {
        StuffPicketageVO stuffPicketageVO = service.insertProcess(picketageId);
    	return CommonResponse.success("保存或修改单据成功！",stuffPicketageVO);
    }
    @ApiOperation("中标公告下一步接口")
    @RequestMapping(value = "/nextPaper", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffBidVO> nextPaper(@RequestParam Long winnoticeId) {
        StuffBidVO stuffBidVO = service.nextPaper(winnoticeId);
        return CommonResponse.success("初始化基础数据成功！",stuffBidVO);
    }


    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishBid", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffBidVO> publishBid(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody StuffBidVO saveorUpdateVO) {
        StuffBidVO stuffBidVO = service.publishBid(saveorUpdateVO);
        return CommonResponse.success("发布成功！",stuffBidVO);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<StuffPicketageSupplierVO>> querySupplierDetail(@RequestParam Long id) {
        List<StuffPicketageSupplierVO> list = service.querySupplierDetail(id);
        return CommonResponse.success("查询详情数据成功！",list);
    }

//    @ApiOperation("查询供应商列表详情")
//    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<List<StuffPicketageSupplierVO>> querySupplierList(@RequestParam Long picketageId) {
//        List<StuffPicketageSupplierVO> list = service.querySupplierList(picketageId);
//        return CommonResponse.success("查询详情数据成功！",list);
//    }
    @ApiOperation("定标下一步查询详情接口")
    @RequestMapping(value = "/queryDbDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffBidVO> queryDbDetail(@RequestParam Long picketage) {
        StuffBidVO stuffBidVO = service.queryDbDetail(picketage);
        return CommonResponse.success("查询详情数据成功！",stuffBidVO);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StuffBidVO> vos) {
        service.removeByIds(vos.stream().map(StuffBidVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }




}
