package com.ejianc.business.tender.stuff.controller;

import java.io.Serializable;

import com.ejianc.business.tender.stuff.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.tender.stuff.bean.StuffTalkEntity;
import com.ejianc.business.tender.stuff.service.IStuffTalkService;

/**
 * 洽商谈判主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("stuffTalk")
@Api(value = "洽商谈判主表", tags = {"洽商谈判主表"})
public class StuffTalkController implements Serializable {
	private static final long serialVersionUID = 1L;


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "invite-talk-code";//此处需要根据实际修改

    @Autowired
    private IStuffTalkService service;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffTalkVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody StuffTalkVO saveorUpdateVO) {
        StuffTalkVO stuffTalkVO = service.saveOrUpdates(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",stuffTalkVO);
    }

    @ApiOperation("发布接口")
    @RequestMapping(value = "/publishTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffTalkVO> publishTalk(@RequestParam Long id) {
        return CommonResponse.success("发布成功！",service.publishTalk(id));
    }
    @ApiOperation("延长截止时间接口")
    @RequestMapping(value = "/extendTalk", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<StuffTalkVO> extendTalk(@RequestBody StuffTalkDetailVO stuffDocumentRecordVO) {
        return CommonResponse.success("延长截止时间成功！",service.extendTalk(stuffDocumentRecordVO));
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffTalkVO> queryDetail(@RequestParam Long id) {
        StuffTalkVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("其他单据点击下一步接口")
    @RequestMapping(value = "/saveTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffTalkVO> saveTalk(@RequestParam Long documentId) {
        return CommonResponse.success("保存成功！",service.saveTalk(documentId));
    }
    @ApiOperation("再次洽商")
    @RequestMapping(value = "/againSaveTalk", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffTalkVO> againSaveTalk(@RequestParam Long id) {
        return CommonResponse.success("保存成功！",service.againSaveTalk(id));
    }
    @ApiOperation("下一步补充数据接口")
    @RequestMapping(value = "/replenishSell", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StuffTalkVO> replenishSell(@RequestParam Long id) {
        return CommonResponse.success("保存成功！",service.replenishSell(id));
    }
    @ApiOperation("获取供应商报价是否报全")
    @RequestMapping(value = "/getSellFull", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> getSellFull(@RequestParam Long id) {
        return CommonResponse.success("保存成功！",service.getSellFull(id));
    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<StuffTalkVO> vos) {
        service.removeByIds(vos.stream().map(StuffTalkVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("多个供应商详情查询")
    @RequestMapping(value = "/querySupplierList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> querySupplierList(Long talkId) {
        return CommonResponse.success("查询成功！",service.querySupplierList(talkId));
    }
    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<StuffTalkVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<StuffTalkEntity> page = service.queryPage(param,false);
        IPage<StuffTalkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffTalkVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<StuffTalkEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("StuffTalk-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refStuffTalkData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StuffTalkVO>> refStuffTalkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<StuffTalkEntity> page = service.queryPage(param,false);
        IPage<StuffTalkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), StuffTalkVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
