package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.equipment.bean.EquipmentDocumentSellEntity;
import com.ejianc.business.tender.prosub.service.IProsubDocumentSellService;
import com.ejianc.business.tender.prosub.vo.ProsubDocumentSellVO;
import com.ejianc.business.tender.prosub.vo.ProsubSupplierDataVO;
import com.ejianc.business.tender.rmat.bean.RmatDocumentSupplierEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailBidderEntity;
import com.ejianc.business.tender.rmat.vo.RmatDocumentSellVO;
import com.ejianc.business.tender.stuff.bean.StuffInviteDetailRecordEntity;
import com.ejianc.business.tender.stuff.bean.StuffPicketageRefsupplierEntity;
import com.ejianc.business.tender.stuff.service.IStuffPicketageRefsupplierService;
import com.ejianc.business.tender.sub.bean.*;
import com.ejianc.business.tender.sub.service.*;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.mapper.SubDocumentSellMapper;
import com.ejianc.business.tender.sub.vo.SubInviteDetailBidderVO;
import com.ejianc.business.tender.sub.vo.SubSupplierDataVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.business.tender.util.TreeNodeBUtil;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 招标文件报价表
 *
 * @author generator
 */
@Service("subDocumentSellService")
public class SubDocumentSellServiceImpl extends BaseServiceImpl<SubDocumentSellMapper, SubDocumentSellEntity> implements ISubDocumentSellService {
    @Autowired
    private ISubPicketageService subPicketageService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private ISubDocumentDetailService subDocumentDetailService;
    @Autowired
    private ISubInviteDetailBidderService bidderService;
    @Autowired
    private ISubPicketageRefsupplierService subPicketageRefsupplierService;

    @Autowired
    private IProsubDocumentSellService prosubDocumentSellService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public List<SubDocumentSellEntity> selectMaterialType(Long documentId) {
        return baseMapper.selectMaterialType(documentId);
    }

    @Override
    public List<SubDocumentSellVO> queryListByIds(Long projectId, Long supplierId, Long picketageId) {
        SubPicketageEntity subPicketageEntity = subPicketageService.selectById(picketageId);
        LambdaQueryWrapper<SubDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
        listWrapper.eq(SubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());
        listWrapper.eq(SubDocumentSellEntity::getSupplierId, supplierId);
        listWrapper.eq(SubDocumentSellEntity::getProjectId, projectId);
        listWrapper.eq(SubDocumentSellEntity::getTenderFlag, 1);
        listWrapper.eq(SubDocumentSellEntity::getPassFlag, 1);
        List<SubDocumentSellEntity> documentSellList = super.list(listWrapper);
        List<SubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(documentSellList, SubDocumentSellVO.class);
        return subDocumentSellVOList;
    }

    @Override
    public List<SubDocumentSellVO> queryTreeByIds(Long id) {
        SubPicketageRefsupplierEntity subPicketageRefsupplierEntity = subPicketageRefsupplierService.selectById(id);
        if (subPicketageRefsupplierEntity != null) {
            List<SubDocumentSellVO> subDocumentSellVOS = new ArrayList<>();
            //流程定标
            if (subPicketageRefsupplierEntity.getPicketageFlag() == 0) {
                SubPicketageEntity subPicketageEntity = subPicketageService.selectById(subPicketageRefsupplierEntity.getPicketageId());
                LambdaQueryWrapper<SubDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
                listWrapper.eq(SubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());

                //TeamId为空则代表是供应商，不为空代表是负责人
                if (subPicketageRefsupplierEntity.getTeamId() == null){
                    listWrapper.eq(SubDocumentSellEntity::getSupplierId, subPicketageRefsupplierEntity.getSupplierId());
                }else {
                    listWrapper.eq(SubDocumentSellEntity::getSupplierId, subPicketageRefsupplierEntity.getTeamId());
                }

                if (subPicketageRefsupplierEntity.getPurchaseType() == 0) {
                    listWrapper.eq(SubDocumentSellEntity::getProjectId, subPicketageRefsupplierEntity.getProjectId());
                }
                listWrapper.eq(SubDocumentSellEntity::getTenderFlag, 1);
                listWrapper.eq(SubDocumentSellEntity::getPassFlag, 1);
                List<SubDocumentSellEntity> documentSellList = super.list(listWrapper);


                List<SubDocumentSellEntity> listSell = documentSellList.stream().filter(map -> (map.getSignNum() == null ? BigDecimal.ZERO : map.getSignNum()).compareTo(map.getTenderNum()) == -1).collect(Collectors.toList());

                if (CollectionUtils.isEmpty(listSell)) {
                    return null;
                }
                SubInviteEntity subInviteEntity = subInviteService.selectById(subPicketageEntity.getInviteId());
                List<SubInviteDetailRecordEntity> subDetailRecord = subInviteEntity.getSubDetailRecord();
                //获取计价方式
                Integer valueType = subInviteEntity.getValueType();

                List<SubDocumentSellVO> subDocumentSellVOList = BeanMapper.mapList(listSell, SubDocumentSellVO.class);
                for (SubDocumentSellVO subDocumentSellVO : subDocumentSellVOList) {
                    subDocumentSellVO.setSurplusNum(subDocumentSellVO.getTenderNum().subtract(subDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : subDocumentSellVO.getSignNum()));
                }
                List<SubDocumentSellVO> listAll = new ArrayList<>();
                for (SubDocumentSellVO subDocumentSellVO : subDocumentSellVOList) {
                    SubDocumentDetailEntity subDocumentDetailEntity = subDocumentDetailService.selectById(subDocumentSellVO.getDetailId());
                    Long parentId = subDocumentDetailEntity.getParentId();
                    List<SubDocumentSellVO> detailByPid = getDetailByPid(parentId, subDetailRecord);
                    listAll.addAll(detailByPid);
                    sellList.clear();
                    subDocumentSellVO.setSellId(subDocumentSellVO.getId());
                    subDocumentSellVO.setParentId(subDocumentDetailEntity.getParentId());
                    subDocumentSellVO.setId(subDocumentSellVO.getDetailId());
                    listAll.add(subDocumentSellVO);
                }
                //实体去重
                listAll = listAll.stream().collect(
                        Collectors.collectingAndThen(
                                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(SubDocumentSellVO::getId))), ArrayList::new)
                );
                if (valueType == 3) {//费率招标
                    for (SubDocumentSellVO prosubDocumentSellVO : listAll) {
                        BigDecimal priceTax = prosubDocumentSellVO.getPriceTax();//含税单价
                        prosubDocumentSellVO.setPriceTax(new BigDecimal(1));//单价(含税)
                        if (prosubDocumentSellVO.getPrice() != null) {
                            prosubDocumentSellVO.setPrice(prosubDocumentSellVO.getPrice().divide(priceTax, 8, BigDecimal.ROUND_HALF_UP));//单价
                        }
                        if (prosubDocumentSellVO.getMoney() != null) {
                            prosubDocumentSellVO.setMoney(prosubDocumentSellVO.getMoney());//总额
                        }
                        if (prosubDocumentSellVO.getSellTax() != null) {
                            prosubDocumentSellVO.setSellTax(prosubDocumentSellVO.getSellTax());//税额
                        }
                        if (prosubDocumentSellVO.getMoneyTax() != null) {
                            prosubDocumentSellVO.setMoneyTax(prosubDocumentSellVO.getMoneyTax());//总额(含税)
                        }
                        if (prosubDocumentSellVO.getTenderNum() != null) {
                            prosubDocumentSellVO.setTenderNum(priceTax);//中标数量
                        }
                        if (prosubDocumentSellVO.getTenderMoney() != null) {
                            prosubDocumentSellVO.setTenderMoney(prosubDocumentSellVO.getTenderMoney());//中标金额
                        }
                        if (prosubDocumentSellVO.getTenderMoneyTax() != null) {
                            prosubDocumentSellVO.setTenderMoneyTax(prosubDocumentSellVO.getTenderMoneyTax());//中标金额(含税)
                        }
                        if (prosubDocumentSellVO.getInvitePrice() != null) {
                            prosubDocumentSellVO.setInvitePrice(prosubDocumentSellVO.getInvitePrice().divide(priceTax,8,BigDecimal.ROUND_HALF_UP));//招标控制单价
                        }
                        if (prosubDocumentSellVO.getInvitePriceTax() != null) {
                            prosubDocumentSellVO.setInvitePriceTax(prosubDocumentSellVO.getInvitePriceTax().divide(priceTax,8,BigDecimal.ROUND_HALF_UP));//招标控制单价(含税)
                        }

                        //可签数量（劳务分包费率合同的特殊性）
                        if (prosubDocumentSellVO.getPriceTax() != null){
                            prosubDocumentSellVO.setSurplusNum(priceTax.subtract(prosubDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : prosubDocumentSellVO.getSignNum()));
                        }
                    }
                }
                List<SubDocumentSellVO> sellList = listAll.stream().collect(Collectors.toList());
                subDocumentSellVOS = TreeNodeBUtil.buildTree(sellList);
            }
            //直接定标
            else {
                List<SubInviteDetailBidderEntity> bidderEntityList1 = subInviteService.selectById(subPicketageRefsupplierEntity.getPicketageId()).getSubDetailBidder();
                List<SubInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t -> t.getNum() != null).filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
                for (SubInviteDetailBidderEntity bidderEntity : bidderEntityList1) {
                    if (bidderEntity.getNum() == null) {
                        bidderEntityList.add(bidderEntity);
                    }
                }
                List<SubInviteDetailBidderVO> subDetailBidder = BeanMapper.mapList(bidderEntityList, SubInviteDetailBidderVO.class);
                for (SubInviteDetailBidderVO bidderVO : subDetailBidder) {
                    SubDocumentSellVO subDocumentSellVO = new SubDocumentSellVO();
                    subDocumentSellVO.setId(bidderVO.getId());
                    subDocumentSellVO.setSellId(bidderVO.getId());
                    subDocumentSellVO.setTreeIndex(bidderVO.getTreeIndex());
                    subDocumentSellVO.setParentId(bidderVO.getParentId());
                    subDocumentSellVO.setChildren(bidderVO.getChildren());
                    subDocumentSellVO.setContent(bidderVO.getContent());
                    subDocumentSellVO.setRule(bidderVO.getRule());
                    subDocumentSellVO.setMaterialId(bidderVO.getDocId());
                    subDocumentSellVO.setMaterialTypeId(bidderVO.getDocCategoryId());
                    subDocumentSellVO.setMaterialCode(bidderVO.getDetailCode());
                    subDocumentSellVO.setMaterialName(bidderVO.getDetailName());
                    subDocumentSellVO.setUnit(bidderVO.getUnit());
                    subDocumentSellVO.setTenderNum(bidderVO.getNum());
                    subDocumentSellVO.setRate(bidderVO.getTaxRate());
                    subDocumentSellVO.setMemo(bidderVO.getMemo());
                    subDocumentSellVO.setPrice(bidderVO.getPrice());
                    subDocumentSellVO.setPriceTax(bidderVO.getTaxPrice());
                    subDocumentSellVO.setTenderMoney(bidderVO.getMny());
                    subDocumentSellVO.setTenderMoneyTax(bidderVO.getTaxMny());
                    subDocumentSellVO.setSellTax(bidderVO.getTax());
                    if (bidderVO.getNum() != null) {
                        subDocumentSellVO.setSignNum(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum());
                        subDocumentSellVO.setSurplusNum(bidderVO.getNum().subtract(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum()));
                    }

                    subDocumentSellVOS.add(subDocumentSellVO);
                }
                subDocumentSellVOS = TreeNodeBUtil.buildTree(subDocumentSellVOS);
            }

            return subDocumentSellVOS;
        }else {
            //处理专业分包
            List<ProsubDocumentSellVO> prosubDocumentSellVOS = prosubDocumentSellService.queryTreeByIds(id);
            return BeanMapper.mapList(prosubDocumentSellVOS,SubDocumentSellVO.class);
        }
    }

    @Override
    public List<SubSupplierDataVO> queryTreeList(Long id) {
        SubPicketageRefsupplierEntity subPicketageRefsupplierEntity = subPicketageRefsupplierService.selectById(id);
        if (subPicketageRefsupplierEntity != null) {
            //流程定标
            List<SubSupplierDataVO> subSupplierDataVOS = new ArrayList<>();
            if (subPicketageRefsupplierEntity.getPicketageFlag() == 0) {
                SubPicketageEntity subPicketageEntity = subPicketageService.selectById(subPicketageRefsupplierEntity.getPicketageId());
                LambdaQueryWrapper<SubDocumentSellEntity> listWrapper = Wrappers.lambdaQuery();
                listWrapper.eq(SubDocumentSellEntity::getDocumentId, subPicketageEntity.getDocumentId());
                listWrapper.eq(SubDocumentSellEntity::getSupplierId, subPicketageRefsupplierEntity.getSupplierId());
                if (subPicketageRefsupplierEntity.getPurchaseType() == 0) {
                    listWrapper.eq(SubDocumentSellEntity::getProjectId, subPicketageRefsupplierEntity.getProjectId());
                }
                listWrapper.eq(SubDocumentSellEntity::getTenderFlag, 1);
                listWrapper.eq(SubDocumentSellEntity::getPassFlag, 1);
                List<SubDocumentSellEntity> documentSellList = super.list(listWrapper);

                logger.info("流程定标数据{}", JSONObject.toJSONString(documentSellList));

                List<SubDocumentSellEntity> listSell = documentSellList.stream().filter(map -> (map.getSignNum() == null ? BigDecimal.ZERO : map.getSignNum()).compareTo(map.getTenderNum()) == -1).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(listSell)) {
                    return null;
                }

                subSupplierDataVOS = BeanMapper.mapList(listSell, SubSupplierDataVO.class);
                for (SubSupplierDataVO subDocumentSellVO : subSupplierDataVOS) {
                    subDocumentSellVO.setSellId(subDocumentSellVO.getId());
                    subDocumentSellVO.setSurplusNum(subDocumentSellVO.getTenderNum().subtract(subDocumentSellVO.getSignNum() == null ? BigDecimal.ZERO : subDocumentSellVO.getSignNum()));
                }
            }
            //直接定标
            else {
                List<SubInviteDetailBidderEntity> bidderEntityList1 = subInviteService.selectById(subPicketageRefsupplierEntity.getPicketageId()).getSubDetailBidder();
                List<SubInviteDetailBidderEntity> bidderEntityList = bidderEntityList1.stream().filter(t -> t.getNum() != null).filter(t -> t.getNum().compareTo(t.getSignNum() == null ? BigDecimal.ZERO : t.getSignNum()) > 0).collect(Collectors.toList());
                List<SubInviteDetailBidderVO> subDetailBidder = BeanMapper.mapList(bidderEntityList, SubInviteDetailBidderVO.class);
                for (SubInviteDetailBidderVO bidderVO : subDetailBidder) {
                    SubSupplierDataVO subDocumentSellVO = new SubSupplierDataVO();
                    subDocumentSellVO.setId(bidderVO.getId());
                    subDocumentSellVO.setSellId(bidderVO.getId());
                    subDocumentSellVO.setTreeIndex(bidderVO.getTreeIndex());
                    subDocumentSellVO.setParentId(bidderVO.getParentId());
                    subDocumentSellVO.setContent(bidderVO.getContent());
                    subDocumentSellVO.setRule(bidderVO.getRule());
                    subDocumentSellVO.setMaterialId(bidderVO.getDocId());
                    subDocumentSellVO.setMaterialTypeId(bidderVO.getDocCategoryId());
                    subDocumentSellVO.setMaterialCode(bidderVO.getDetailCode());
                    subDocumentSellVO.setMaterialName(bidderVO.getDetailName());
                    subDocumentSellVO.setUnit(bidderVO.getUnit());
                    subDocumentSellVO.setTenderNum(bidderVO.getNum());
                    subDocumentSellVO.setRate(bidderVO.getTaxRate());
                    subDocumentSellVO.setMemo(bidderVO.getMemo());
                    subDocumentSellVO.setPrice(bidderVO.getPrice());
                    subDocumentSellVO.setPriceTax(bidderVO.getTaxPrice());
                    subDocumentSellVO.setTenderMoney(bidderVO.getMny());
                    subDocumentSellVO.setTenderMoneyTax(bidderVO.getTaxMny());
                    subDocumentSellVO.setSellTax(bidderVO.getTax());
                    if (bidderVO.getNum() != null) {
                        subDocumentSellVO.setSignNum(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum());
                        subDocumentSellVO.setSurplusNum(bidderVO.getNum().subtract(bidderVO.getSignNum() == null ? BigDecimal.ZERO : bidderVO.getSignNum()));
                    }

                    subSupplierDataVOS.add(subDocumentSellVO);
                }
            }

            return subSupplierDataVOS;
        }else {
            //处理专业分包
            List<ProsubSupplierDataVO> prosubSupplierDataVOS = prosubDocumentSellService.queryTreeList(id);
            if (prosubSupplierDataVOS != null) {
                return BeanMapper.mapList(prosubSupplierDataVOS, SubSupplierDataVO.class);
            }else {
                return null;
            }
        }
    }

    List<SubDocumentSellVO> sellList = new ArrayList<SubDocumentSellVO>();

    private List<SubDocumentSellVO> getDetailByPid(Long id, List<SubInviteDetailRecordEntity> list) {

        for (SubInviteDetailRecordEntity recordEntity : list) {
            if (id != null && id.equals(recordEntity.getId())) {
                id = recordEntity.getParentId();
                getDetailByPid(id, list);

                //转换
                SubDocumentSellVO subDocumentSellVO = new SubDocumentSellVO();
                subDocumentSellVO.setMaterialCode(recordEntity.getDetailCode());
                subDocumentSellVO.setMaterialName(recordEntity.getDetailName());
                subDocumentSellVO.setRule(recordEntity.getRule());
                subDocumentSellVO.setContent(recordEntity.getContent());
                subDocumentSellVO.setUnit(recordEntity.getUnit());
                subDocumentSellVO.setParentId(recordEntity.getParentId());
                subDocumentSellVO.setId(recordEntity.getId());
                subDocumentSellVO.setTreeIndex(recordEntity.getTreeIndex());
                subDocumentSellVO.setMemo(recordEntity.getMemo());
                subDocumentSellVO.setMaterialId(recordEntity.getDocId());
                subDocumentSellVO.setMaterialTypeId(recordEntity.getDocCategoryId());
                sellList.add(subDocumentSellVO);
            }
        }
        return sellList;
    }
}

