package com.ejianc.business.tender.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.sub.bean.SubPicketageSupplierEntity;
import com.ejianc.business.tender.sub.mapper.SubPicketageSupplierMapper;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.service.ISubPicketageService;
import com.ejianc.business.tender.sub.service.ISubPicketageSupplierService;
import com.ejianc.business.tender.sub.service.ISubWinnoticeService;
import com.ejianc.business.tender.sub.vo.SubPicketageSupplierVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 定标供应商表
 *
 * @author generator
 *
 */
@Service("subPicketageSupplierService")
public class SubPicketageSupplierServiceImpl extends BaseServiceImpl<SubPicketageSupplierMapper, SubPicketageSupplierEntity> implements ISubPicketageSupplierService {
    @Autowired
    private ISubPicketageSupplierService subPicketageSupplierService;
    @Autowired
    private ISubPicketageService subPicketageService;
    @Autowired
    private ISubWinnoticeService subWinnoticeService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private IProcessService processService;
    @Override
    public List<SubPicketageSupplierVO> queryDetail(Long id) {
        LambdaQueryWrapper<SubPicketageSupplierEntity> lambdaSupplierList = Wrappers.lambdaQuery();
        lambdaSupplierList.eq(SubPicketageSupplierEntity::getPicketageId,id);
        List<SubPicketageSupplierEntity> listSupplier = subPicketageSupplierService.list(lambdaSupplierList);
        List<SubPicketageSupplierVO> subPicketageSupplierVOS = BeanMapper.mapList(listSupplier, SubPicketageSupplierVO.class);

        return subPicketageSupplierVOS;
    }
}
