package com.ejianc.business.tender.util;

import java.math.BigDecimal;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.TimeZone;

public class MyDateUtil {

    /**
     * 本月开始时间
     * @param dateTimeFormatter
     * @return
     */
    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    /**
     * 本月结束时间
     *
     * @return
     */
    public static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));// 获取当前月最后一天
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }


    //获取本季度开始时间
    public static String getFromThisQuarterStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);

    }
    //获取本季度结束时间
    public static String getFromThisQuarterEndTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    /**
     * 今年起开始时间
     *
     * @return
     */
    public static String getFromThisYearStartTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    /**
     * 今年起结束时间
     *
     * @return
     */
    public static String getFromThisYearEndTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }


}
