/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.cost.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.vo.BatPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanVO;
import com.ejianc.business.tender.cost.bean.AllPlanDetailEntity;
import com.ejianc.business.tender.cost.bean.PlanControlRuleDetailEntity;
import com.ejianc.business.tender.cost.service.IAllPlanDetailService;
import com.ejianc.business.tender.cost.vo.AllPlanDetailVO;
import com.ejianc.business.tender.cost.vo.PlanControlRuleDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/allPlanDetail"})
public class CostApi
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAllPlanDetailService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AllPlanDetailVO> saveOrUpdate(@RequestBody AllPlanDetailVO saveOrUpdateVO) {
        AllPlanDetailEntity entity = (AllPlanDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllPlanDetailEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        AllPlanDetailVO vo = (AllPlanDetailVO)BeanMapper.map((Object)((Object)entity), AllPlanDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PlanControlRuleDetailVO>> saveOrUpdateBatch(@RequestBody BatPlanVO vo) {
        List batPlanDetailList = vo.getBatPlanDetailList();
        List saveOrUpdateVO = BeanMapper.mapList((Iterable)batPlanDetailList, AllPlanDetailVO.class);
        for (Object allPlanDetailVO : saveOrUpdateVO) {
            allPlanDetailVO.setProjectId(vo.getProjectId());
        }
        this.logger.info("\u91c7\u8d2d\u8ba1\u5212\u63a8\u9001\u63a5\u53e3\uff1a{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO));
        List entity = BeanMapper.mapList((Iterable)saveOrUpdateVO, AllPlanDetailEntity.class);
        if (entity != null && entity.size() > 0 && ((AllPlanDetailEntity)((Object)entity.get(0))).getUpdateTime() != null) {
            for (AllPlanDetailEntity allPlanDetailEntity : entity) {
                allPlanDetailEntity.setVersion(allPlanDetailEntity.getVersion() - 1);
            }
            this.service.updateBatchById(entity);
            this.logger.info("\u91c7\u8d2d\u8ba1\u5212\u63a8\u9001\u6267\u884c\u66f4\u65b0\u64cd\u4f5c\uff01");
        } else {
            this.service.saveBatch(entity);
            this.logger.info("\u91c7\u8d2d\u8ba1\u5212\u63a8\u9001\u6267\u884c\u65b0\u589e\u64cd\u4f5c\uff01");
        }
        List<PlanControlRuleDetailEntity> planControlRuleDetailEntityList = this.service.compareWithCost(saveOrUpdateVO);
        List planControlRuleDetailVOS = BeanMapper.mapList(planControlRuleDetailEntityList, PlanControlRuleDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)planControlRuleDetailVOS);
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PlanControlRuleDetailVO>> check(@RequestBody BatPlanVO vo) {
        List batPlanDetailList = vo.getBatPlanDetailList();
        List saveOrUpdateVO = BeanMapper.mapList((Iterable)batPlanDetailList, AllPlanDetailVO.class);
        for (AllPlanDetailVO allPlanDetailVO : saveOrUpdateVO) {
            allPlanDetailVO.setProjectId(vo.getProjectId());
        }
        this.logger.info("\u91c7\u8d2d\u8ba1\u5212\u67e5\u8be2\u63a5\u53e3\uff1a{}", (Object)JSONObject.toJSONString((Object)saveOrUpdateVO));
        List<PlanControlRuleDetailEntity> planControlRuleDetailEntityList = this.service.compareWithCost(saveOrUpdateVO);
        List planControlRuleDetailVOS = BeanMapper.mapList(planControlRuleDetailEntityList, PlanControlRuleDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)planControlRuleDetailVOS);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BatPlanDetailVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AllPlanDetailVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllPlanDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AllPlanDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAllPlanDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AllPlanDetailVO>> refAllPlanDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AllPlanDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

