/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rmat.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.assist.material.vo.MaterialBatchPlanEnum;
import com.ejianc.business.pro.rmat.api.IBatchPlanApi;
import com.ejianc.business.pro.rmat.api.IPrormatContractApi;
import com.ejianc.business.pro.rmat.vo.BatchPlanEnum;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.enums.TenderSignStatusEnum;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailBidderEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteDetailRecordEntity;
import com.ejianc.business.tender.rmat.bean.RmatInviteEntity;
import com.ejianc.business.tender.rmat.bean.RmatPicketageEntity;
import com.ejianc.business.tender.rmat.service.IRmatInviteDetailRecordService;
import com.ejianc.business.tender.rmat.service.IRmatInviteService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageRefsupplierService;
import com.ejianc.business.tender.rmat.service.IRmatPicketageService;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailBidderVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteDetailRecordVO;
import com.ejianc.business.tender.rmat.vo.RmatInviteVO;
import com.ejianc.business.tender.rmat.vo.TenderStageEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rmatInvite"})
public class RmatInviteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TENDER_RMAT";
    private static final String CONDITION_PROJECT_ID = "projectId";
    private static final String CONDITION_ORG_ID = "orgId";
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IRmatInviteService service;
    @Autowired
    private IRmatInviteDetailRecordService detailRecordService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private IBatchPlanApi batPlanApi;
    @Autowired
    private IRmatPicketageService picketageService;
    @Autowired
    private IRmatPicketageRefsupplierService refsupplierService;
    @Autowired
    private IPrormatContractApi contractApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RmatInviteVO> saveOrUpdate(@RequestBody RmatInviteVO saveorUpdateVO) {
        List inviteIdList;
        RmatInviteEntity rmatInviteEntity;
        List rmatInviteDetailList = saveorUpdateVO.getRmatDetailRecord();
        ArrayList<RmatInviteDetailBidderEntity> biddermatityList = new ArrayList<RmatInviteDetailBidderEntity>();
        if (CollectionUtils.isNotEmpty((Collection)rmatInviteDetailList)) {
            for (RmatInviteDetailRecordVO rmatInviteDetailVO : rmatInviteDetailList) {
                List bidderList;
                if (rmatInviteDetailVO.getId() == null) {
                    long id = IdWorker.getId();
                    rmatInviteDetailVO.setId(Long.valueOf(id));
                }
                if (!CollectionUtils.isNotEmpty((Collection)(bidderList = rmatInviteDetailVO.getRmatDetailBidder()))) continue;
                for (RmatInviteDetailBidderVO bidderVO : bidderList) {
                    bidderVO.setInviteDetailId(rmatInviteDetailVO.getId());
                    RmatInviteDetailBidderEntity biddermatity = (RmatInviteDetailBidderEntity)((Object)BeanMapper.map((Object)bidderVO, RmatInviteDetailBidderEntity.class));
                    biddermatityList.add(biddermatity);
                }
            }
        }
        RmatInviteEntity entity = (RmatInviteEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, RmatInviteEntity.class));
        if (CollectionUtils.isNotEmpty(biddermatityList)) {
            entity.setRmatDetailBidder(biddermatityList);
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (null != (rmatInviteEntity = (RmatInviteEntity)((Object)this.service.selectById(saveorUpdateVO.getId())))) {
            this.service.updateApiState(rmatInviteEntity, BatchPlanEnum.PLAN_STATE_WAIT.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_WAIT.getPlanState());
        }
        entity.setSignStatus(TenderSignStatusEnum.\u672a\u7b7e\u8ba2.getCode());
        this.service.saveOrUpdate((Object)entity, false);
        RmatInviteVO vo = (RmatInviteVO)BeanMapper.map((Object)((Object)entity), RmatInviteVO.class);
        List rmatInviteDetailVOList = vo.getRmatDetailRecord();
        List rmatInviteDetailBidderVOList = vo.getRmatDetailBidder();
        if (CollectionUtils.isNotEmpty((Collection)rmatInviteDetailBidderVOList)) {
            Map<Long, List<RmatInviteDetailBidderVO>> bidderMap = rmatInviteDetailBidderVOList.stream().collect(Collectors.groupingBy(RmatInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty((Collection)rmatInviteDetailVOList)) {
                for (RmatInviteDetailRecordVO rmatInviteDetailVO : rmatInviteDetailVOList) {
                    List<RmatInviteDetailBidderVO> rmatInviteDetailBidderVOS = bidderMap.get(rmatInviteDetailVO.getId());
                    if (!CollectionUtils.isNotEmpty(rmatInviteDetailBidderVOS)) continue;
                    rmatInviteDetailVO.setRmatDetailBidder(rmatInviteDetailBidderVOS);
                }
            }
        }
        this.service.updateApiState(entity, BatchPlanEnum.PLAN_STATE_EXEC.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_EXEC.getPlanState());
        if (entity.getEstablishType() == 1 && CollectionUtils.isNotEmpty(inviteIdList = entity.getRmatDetailRecord().stream().map(RmatInviteDetailRecordEntity::getPlanId).distinct().collect(Collectors.toList()))) {
            UpdateWrapper wrapper = new UpdateWrapper();
            ((UpdateWrapper)wrapper.set((Object)"occupy_state", (Object)1)).in((Object)"id", inviteIdList);
            this.service.update((Wrapper)wrapper);
        }
        if (!this.processService.selectByBillId(entity.getId())) {
            ProcessEntity processEntity = new ProcessEntity();
            processEntity.setBillId(entity.getId());
            if (vo.getEstablishType() == 1) {
                processEntity.setBillName("\u5b9a\u6807\u7acb\u9879");
            } else {
                processEntity.setBillName("\u62db\u6807\u7acb\u9879");
            }
            processEntity.setTenderId(entity.getId());
            processEntity.setType(4);
            processEntity.setFrontendUrl("rmat/invite/card");
            this.processService.saveOrUpdate((Object)processEntity);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RmatInviteVO> queryDetail(Long id) {
        RmatInviteEntity entity = (RmatInviteEntity)((Object)this.service.selectById(id));
        RmatInviteVO vo = (RmatInviteVO)BeanMapper.map((Object)((Object)entity), RmatInviteVO.class);
        List rmatInviteDetailVOList = vo.getRmatDetailRecord();
        List rmatInviteDetailBidderVOList = vo.getRmatDetailBidder();
        if (CollectionUtils.isNotEmpty((Collection)rmatInviteDetailBidderVOList)) {
            Map<Long, List<RmatInviteDetailBidderVO>> bidderMap = rmatInviteDetailBidderVOList.stream().collect(Collectors.groupingBy(RmatInviteDetailBidderVO::getInviteDetailId));
            if (CollectionUtils.isNotEmpty((Collection)rmatInviteDetailVOList)) {
                for (RmatInviteDetailRecordVO rmatInviteDetailVO : rmatInviteDetailVOList) {
                    List<RmatInviteDetailBidderVO> rmatInviteDetailBidderVOS = bidderMap.get(rmatInviteDetailVO.getId());
                    if (!CollectionUtils.isNotEmpty(rmatInviteDetailBidderVOS)) continue;
                    rmatInviteDetailVO.setRmatDetailBidder(rmatInviteDetailBidderVOS);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RmatInviteVO> vos) {
        List idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long inviteId : idList) {
            List inviteIdList;
            this.service.updateApiState((RmatInviteEntity)((Object)this.service.selectById(inviteId)), BatchPlanEnum.PLAN_STATE_WAIT.getPlanState(), MaterialBatchPlanEnum.PLAN_STATE_WAIT.getPlanState());
            RmatInviteEntity inviteEntity = (RmatInviteEntity)((Object)this.service.selectById(inviteId));
            if (inviteEntity.getEstablishType() != 1 || !CollectionUtils.isNotEmpty(inviteIdList = this.detailRecordService.list((Wrapper)new LambdaQueryWrapper().eq(RmatInviteDetailRecordEntity::getInviteId, (Object)inviteId)).stream().map(RmatInviteDetailRecordEntity::getPlanId).map(String::valueOf).distinct().collect(Collectors.toList()))) continue;
            UpdateWrapper wrapper = new UpdateWrapper();
            ((UpdateWrapper)wrapper.set((Object)"occupy_state", (Object)0)).in((Object)"id", inviteIdList);
            this.service.update((Wrapper)wrapper);
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.processService.remove((Wrapper)new LambdaQueryWrapper().in(ProcessEntity::getBillId, (Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList())));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RmatInviteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("purchaseTypeName");
        fuzzyFields.add("tenderStage");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter isMyOrder = (Parameter)param.getParams().get("isMyOrder");
        if (null != isMyOrder && isMyOrder.getValue().toString().contains("0") && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().remove("employeeId");
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("0")) {
            param.getParams().put("employeeId", new Parameter("eq", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        } else if (null != isMyOrder && isMyOrder.getValue().toString().contains("1")) {
            param.getParams().put("employeeId", new Parameter("ne", (Object)Long.valueOf(InvocationInfoProxy.getEmployeeId())));
        }
        param.getParams().remove("isMyOrder");
        param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RmatInviteVO.class));
        for (RmatInviteVO record : pageData.getRecords()) {
            if (record.getTenderType() != null) {
                switch (record.getTenderType()) {
                    case 0: {
                        record.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                        break;
                    }
                    case 1: {
                        record.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                        break;
                    }
                    case 2: {
                        record.setTenderTypeName("\u8be2\u4ef7");
                        break;
                    }
                    case 3: {
                        record.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                        break;
                    }
                    case 4: {
                        record.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                        break;
                    }
                    case 5: {
                        record.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                    }
                }
                switch (record.getSignStatus()) {
                    case 0: {
                        record.setSignStatusName("\u672a\u7b7e\u8ba2");
                        break;
                    }
                    case 1: {
                        record.setSignStatusName("\u90e8\u5206\u7b7e\u8ba2");
                        break;
                    }
                    case 2: {
                        record.setSignStatusName("\u5168\u90e8\u5df2\u7b7e");
                        break;
                    }
                    case 3: {
                        record.setSignStatusName("\u5df2\u5173\u95ed");
                    }
                }
            }
            record.setEstablishTypeName(record.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            record.setPurchaseTypeName(record.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            record.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)record.getTenderStage()).getDescription());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("tenderName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List voList = JSON.parseArray((String)JSON.toJSONString((Object)list), RmatInviteVO.class);
        for (RmatInviteVO rmatInviteVO : voList) {
            switch (rmatInviteVO.getTenderType()) {
                case 0: {
                    rmatInviteVO.setTenderTypeName("\u5e73\u53f0\u516c\u5f00\u62db\u6807");
                    break;
                }
                case 1: {
                    rmatInviteVO.setTenderTypeName("\u9080\u8bf7\u62db\u6807");
                    break;
                }
                case 2: {
                    rmatInviteVO.setTenderTypeName("\u8be2\u4ef7");
                    break;
                }
                case 3: {
                    rmatInviteVO.setTenderTypeName("\u7ade\u4e89\u6027\u8c08\u5224");
                    break;
                }
                case 4: {
                    rmatInviteVO.setTenderTypeName("\u5355\u4e00\u6765\u6e90");
                    break;
                }
                case 5: {
                    rmatInviteVO.setTenderTypeName("\u7d27\u6025\u62db\u6807");
                }
            }
            rmatInviteVO.setEstablishTypeName(rmatInviteVO.getEstablishType() == 0 ? "\u62db\u6807\u7acb\u9879" : "\u5b9a\u6807\u7acb\u9879");
            rmatInviteVO.setPurchaseTypeName(rmatInviteVO.getPurchaseType() == 0 ? "\u9879\u76ee\u91c7\u8d2d" : "\u5355\u4f4d\u91c7\u8d2d");
            rmatInviteVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)rmatInviteVO.getBillState()).getDescription());
            rmatInviteVO.setTenderStageName(TenderStageEnum.getEnumByStateCode((Integer)rmatInviteVO.getTenderStage()).getDescription());
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("\u6750\u6599\u7acb\u9879.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRmatInviteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RmatInviteVO>> refRmatInviteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("tenderPlatform", new Parameter("eq", (Object)2));
        param.getParams().put("occupyState", new Parameter("eq", (Object)0));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("tenderName");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)CONDITION_PROJECT_ID)) {
                Long projectId = Long.parseLong(_con.get((Object)CONDITION_PROJECT_ID).toString());
                CommonResponse projectResponse = this.projectPoolApi.queryProjectIdsByParentProjectId(projectId);
                if (!projectResponse.isSuccess()) {
                    throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                param.getParams().put(CONDITION_PROJECT_ID, new Parameter("in", projectResponse.getData()));
            }
            if (_con.containsKey((Object)CONDITION_ORG_ID)) {
                Long orgId = Long.valueOf(_con.get((Object)CONDITION_ORG_ID).toString());
                CommonResponse orgResp = this.iOrgApi.getOneById(orgId);
                OrgVO orgVO = (OrgVO)orgResp.getData();
                if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("eq", (Object)orgId));
                } else {
                    param.getParams().put(CONDITION_ORG_ID, new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                }
            }
            if (_con.containsKey((Object)"purchaseType")) {
                Integer purchaseType = _con.getInteger("purchaseType");
                param.getParams().put("purchaseType", new Parameter("eq", (Object)purchaseType));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RmatInviteVO.class));
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List rmatInviteVOList = pageData.getRecords();
            List idList = rmatInviteVOList.stream().map(BaseVO::getId).map(String::valueOf).collect(Collectors.toList());
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("inviteId", new Parameter("in", idList));
            List detailEntityList = this.detailRecordService.queryList(detailParam);
            List detailVOList = BeanMapper.mapList((Iterable)detailEntityList, RmatInviteDetailRecordVO.class);
            HashMap detailMap = new HashMap();
            for (RmatInviteDetailRecordVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getInviteId())) {
                    ((List)detailMap.get(vo.getInviteId())).add(vo);
                    continue;
                }
                ArrayList<RmatInviteDetailRecordVO> mapList = new ArrayList<RmatInviteDetailRecordVO>();
                mapList.add(vo);
                detailMap.put(vo.getInviteId(), mapList);
            }
            rmatInviteVOList.forEach(t -> t.setRmatDetailRecord((List)detailMap.get(t.getId())));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getAType"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, Object>> getAType(Long tenderId) {
        Map<String, Object> map = this.service.getAbolishType(tenderId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6d41/\u5e9f\u6807\u72b6\u6001\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"/detailExcelExport"}, method={RequestMethod.GET})
    @ResponseBody
    public void detailExcelExport(Long id, HttpServletResponse response) {
        RmatInviteVO equipmentInviteVO = (RmatInviteVO)this.queryDetail(id).getData();
        List detailList = equipmentInviteVO.getRmatDetailRecord();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", detailList);
        ExcelExport.getInstance().export("rmatInviteDetail.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryContract"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SignContractVo>> queryContract(@RequestBody RmatInviteVO inviteVO) {
        Long refId;
        if (inviteVO.getEstablishType() == 0) {
            RmatPicketageEntity picketageEntity = (RmatPicketageEntity)((Object)this.picketageService.list((Wrapper)new QueryWrapper().eq((Object)"invite_id", (Object)inviteVO.getId())).get(0));
            refId = picketageEntity.getId();
        } else {
            refId = inviteVO.getId();
        }
        this.logger.info("\u5b9a\u6807ID" + refId);
        List refsupplierList = this.refsupplierService.list((Wrapper)new QueryWrapper().eq((Object)"picketage_id", (Object)refId));
        List idList = refsupplierList.stream().map(BaseEntity::getId).map(String::valueOf).collect(Collectors.toList());
        this.logger.info("\u5b9a\u6807\u53c2\u7167ID" + JSONObject.toJSONString(idList));
        CommonResponse response = this.contractApi.queryContractByTargetResultId(idList);
        if (!response.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5408\u540c\u5931\u8d25" + response.getMsg());
        }
        ((List)response.getData()).forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        return CommonResponse.success((Object)response.getData());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/closeSignStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse closeSignStatus(Long id) {
        RmatInviteEntity entity = (RmatInviteEntity)((Object)this.service.selectById(id));
        Long refId = null;
        Integer tenderStage = entity.getTenderStage();
        Integer establishType = entity.getEstablishType();
        if (!this.sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) throw new BusinessException("\u53ea\u6709\u62db\u6807\u7ecf\u529e\u4eba\u624d\u80fd\u5173\u95ed");
        if (entity.getSignStatus() != 0 && entity.getSignStatus() != 1) throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        if (establishType == 0) {
            if (tenderStage == 5 || tenderStage == 13 || tenderStage == 14) {
                RmatPicketageEntity picketageEntity = (RmatPicketageEntity)((Object)this.picketageService.list((Wrapper)new QueryWrapper().eq((Object)"invite_id", (Object)id)).get(0));
                refId = picketageEntity.getId();
            }
        } else if (entity.getBillState() == 1 || entity.getBillState() == 3) {
            refId = id;
        }
        if (refId == null) throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        this.logger.info("\u5b9a\u6807ID" + refId);
        List refsupplierList = this.refsupplierService.list((Wrapper)new QueryWrapper().eq((Object)"picketage_id", (Object)refId));
        if (!CollectionUtils.isNotEmpty((Collection)refsupplierList)) {
            throw new BusinessException("\u4e0d\u7b26\u5408\u5173\u95ed\u6761\u4ef6");
        }
        refsupplierList.forEach(t -> t.setSignStatus(TenderSignStatusEnum.\u5df2\u5173\u95ed.getCode()));
        this.refsupplierService.saveOrUpdateBatch(refsupplierList);
        entity.setSignStatus(TenderSignStatusEnum.\u5df2\u5173\u95ed.getCode());
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/judgeEmployee"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> judgeEmployee(Long inviteId) {
        boolean flag = false;
        RmatInviteEntity entity = (RmatInviteEntity)((Object)this.service.selectById(inviteId));
        if (this.sessionManager.getUserContext().getEmployeeId().equals(entity.getEmployeeId())) {
            flag = true;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)flag);
    }
}

