/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.sub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.stuff.vo.SupplierSellVO;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSchemeEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSellEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubInviteEntity;
import com.ejianc.business.tender.sub.bean.SubTalkDetailEntity;
import com.ejianc.business.tender.sub.bean.SubTalkEntity;
import com.ejianc.business.tender.sub.bean.SubTalkRecordDetailEntity;
import com.ejianc.business.tender.sub.bean.SubTalkRecordEntity;
import com.ejianc.business.tender.sub.mapper.SubTalkMapper;
import com.ejianc.business.tender.sub.service.ISubDocumentSchemeService;
import com.ejianc.business.tender.sub.service.ISubDocumentSellService;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubDocumentSupplierService;
import com.ejianc.business.tender.sub.service.ISubInviteService;
import com.ejianc.business.tender.sub.service.ISubTalkDetailService;
import com.ejianc.business.tender.sub.service.ISubTalkRecordDetailService;
import com.ejianc.business.tender.sub.service.ISubTalkRecordService;
import com.ejianc.business.tender.sub.service.ISubTalkService;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSupplierTbVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSupplierVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.business.tender.sub.vo.SubQuotationMaterialVO;
import com.ejianc.business.tender.sub.vo.SubQuotationSchemeVO;
import com.ejianc.business.tender.sub.vo.SubQuotationSupplierVO;
import com.ejianc.business.tender.sub.vo.SubTalkDetailVO;
import com.ejianc.business.tender.sub.vo.SubTalkRecordVO;
import com.ejianc.business.tender.sub.vo.SubTalkVO;
import com.ejianc.business.tender.sub.vo.SupplierReplenishVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="subTalkService")
public class SubTalkServiceImpl
extends BaseServiceImpl<SubTalkMapper, SubTalkEntity>
implements ISubTalkService {
    @Value(value="${gysUrl.updateTimeUrl}")
    private String updateTimeUrl;
    @Value(value="${gysUrl.saveOrUpdateUrl}")
    private String saveOrUpdateUrl;
    @Value(value="${gysUrl.updateSupOffer}")
    private String updateSupOffer;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private CacheManager cacheManager;
    private static final String BILL_CODE = "invite-talk-code";
    @Autowired
    private ISubTalkDetailService subTalkDetailService;
    @Autowired
    private ISubTalkRecordService subTalkRecordService;
    @Autowired
    private ISubTalkRecordDetailService subTalkRecordDetailService;
    @Autowired
    private ISubDocumentSellService subDocumentSellService;
    @Autowired
    private ISubDocumentService subDocumentService;
    @Autowired
    private ISubInviteService subInviteService;
    @Autowired
    private ISubDocumentSupplierService subDocumentSupplierService;
    @Autowired
    private ISubDocumentSchemeService subDocumentSchemeService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IProcessService processService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String BILL_SUPPLIER_TYPE = "BT202202000002";

    @Override
    @Transactional
    public SubTalkVO publishTalk(Long id) {
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)super.selectById((Serializable)id));
        subTalkEntity.setPublishFlag(0);
        super.updateById((Object)subTalkEntity);
        SubDocumentSupplierTbVO subDocumentSupplierTbVO = new SubDocumentSupplierTbVO();
        subDocumentSupplierTbVO.setSourceId(subTalkEntity.getInviteId().toString());
        subDocumentSupplierTbVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u6d3d\u5546\u8c08\u5224");
        subDocumentSupplierTbVO.setNoticeType(Integer.valueOf(4));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStart = simpleDateFormat.format(subTalkEntity.getTalkStartTime());
        subDocumentSupplierTbVO.setOfferStartTime(formatStart);
        String formatEnd = simpleDateFormat.format(subTalkEntity.getTalkEndTime());
        subDocumentSupplierTbVO.setOfferEndTime(formatEnd);
        subDocumentSupplierTbVO.setMemo(subTalkEntity.getMemo());
        subDocumentSupplierTbVO.setTalkMoney(subTalkEntity.getTalkMoney());
        subDocumentSupplierTbVO.setTalkNum(subTalkEntity.getTalkNum());
        subDocumentSupplierTbVO.setTenderName(subTalkEntity.getTalkName());
        subDocumentSupplierTbVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        String stringFb = JSONObject.toJSONString((Object)subDocumentSupplierTbVO);
        this.logger.info("\u6d3d\u5546\u8c08\u5224\u53d1\u5e03" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.saveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public SubTalkVO extendTalk(SubTalkDetailVO subTalkDetailVO) {
        SubTalkDetailEntity subDocumentRecordEntity = (SubTalkDetailEntity)((Object)BeanMapper.map((Object)subTalkDetailVO, SubTalkDetailEntity.class));
        this.subTalkDetailService.save((Object)subDocumentRecordEntity);
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)super.selectById((Serializable)subTalkDetailVO.getTalkId()));
        subTalkEntity.setTalkEndTime(subTalkDetailVO.getNewTime());
        boolean b = super.updateById((Object)subTalkEntity);
        SupplierSellVO supplierSellVO = new SupplierSellVO();
        supplierSellVO.setSourceId(Long.toString(subTalkEntity.getInviteId()));
        supplierSellVO.setOfferEndTime(subTalkDetailVO.getNewTime());
        String stringFb = JSONObject.toJSONString((Object)supplierSellVO);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateTimeUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u6d3d\u5546\u8c08\u5224\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(subTalkDetailVO.getTalkId());
    }

    @Override
    public SubTalkVO saveTalk(Long documentId) {
        SubTalkEntity entity = new SubTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        SubDocumentEntity documentEntity = (SubDocumentEntity)((Object)this.subDocumentService.selectById(documentId));
        documentEntity.setNextFlag(0);
        this.subDocumentService.saveOrUpdate((Object)documentEntity);
        SubDocumentEntity subDocumentEntity = (SubDocumentEntity)((Object)this.subDocumentService.selectById(documentId));
        SubInviteEntity subInviteEntity = (SubInviteEntity)((Object)this.subInviteService.selectById(subDocumentEntity.getInviteId()));
        entity.setProjectCode(subDocumentEntity.getProjectCode());
        entity.setInviteId(subDocumentEntity.getInviteId());
        entity.setProjectId(subDocumentEntity.getProjectId());
        entity.setProjectName(subDocumentEntity.getProjectName());
        entity.setOrgId(subDocumentEntity.getOrgId());
        entity.setOrgName(subDocumentEntity.getOrgName());
        entity.setParentOrgId(subDocumentEntity.getParentOrgId());
        entity.setParentOrgName(subDocumentEntity.getParentOrgName());
        entity.setBrandFlag(subDocumentEntity.getBrandFlag());
        entity.setBillId(documentId);
        entity.setTalkNum(1);
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(subDocumentEntity.getPurchaseType());
        entity.setTalkName(subInviteEntity.getTenderName());
        super.save((Object)entity);
        subInviteEntity.setTenderStage(7);
        this.subInviteService.updateById((Object)subInviteEntity);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName("\u6d3d\u5546\u8c08\u5224");
        processEntity.setTenderId(subDocumentEntity.getInviteId());
        processEntity.setType(1);
        processEntity.setFrontendUrl("sub/talkNegotiate");
        this.processService.saveOrUpdate((Object)processEntity);
        SubTalkVO vo = (SubTalkVO)BeanMapper.map((Object)((Object)entity), SubTalkVO.class);
        SubTalkVO subTalkVO = this.queryDetail(vo.getId());
        return subTalkVO;
    }

    @Override
    public SubTalkVO queryDetail(Long id) {
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)super.selectById((Serializable)id));
        SubTalkVO subTalkVO = (SubTalkVO)BeanMapper.map((Object)((Object)subTalkEntity), SubTalkVO.class);
        Integer talkNum = subTalkEntity.getTalkNum();
        if (subTalkEntity.getPublishFlag() == 1) {
            talkNum = talkNum - 1;
        }
        SubDocumentVO subDocumentVO = this.subDocumentService.queryDocDetailTalk(subTalkEntity.getBillId(), talkNum);
        subTalkVO.setSubDocumentDetailSellList(subDocumentVO.getSubDocumentDetailSellList());
        subTalkVO.setSubDocumentSupplierSchemeList(subDocumentVO.getSubDocumentSupplierSchemeList());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SubDocumentSupplierEntity::getDocumentId, (Object)subTalkEntity.getBillId());
        lambda.eq(SubDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambda);
        List documentSupplierVOList = BeanMapper.mapList((Iterable)supplierList, SubDocumentSupplierVO.class);
        subTalkVO.setSubDocumentSupplierList(documentSupplierVOList);
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(SubTalkRecordEntity::getBillId, (Object)subTalkEntity.getBillId());
        lambdaRecord.orderByAsc(SubTalkRecordEntity::getTalkNum);
        List subTalkRecordEntityList = this.subTalkRecordService.list((Wrapper)lambdaRecord);
        List subTalkRecordList = BeanMapper.mapList((Iterable)subTalkRecordEntityList, SubTalkRecordVO.class);
        subTalkVO.setTalkRecordEntityList(subTalkRecordList);
        return subTalkVO;
    }

    @Override
    @Transactional
    public SubTalkVO againSaveTalk(Long id) {
        SubTalkEntity entity = new SubTalkEntity();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)super.selectById((Serializable)id));
        entity.setProjectCode(subTalkEntity.getProjectCode());
        entity.setProjectId(subTalkEntity.getProjectId());
        entity.setProjectName(subTalkEntity.getProjectName());
        entity.setOrgId(subTalkEntity.getOrgId());
        entity.setOrgName(subTalkEntity.getOrgName());
        entity.setParentOrgId(subTalkEntity.getParentOrgId());
        entity.setParentOrgName(subTalkEntity.getParentOrgName());
        entity.setBrandFlag(subTalkEntity.getBrandFlag());
        entity.setBillId(subTalkEntity.getBillId());
        entity.setInviteId(subTalkEntity.getInviteId());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setTalkNum(subTalkEntity.getTalkNum() + 1);
        String taikNumName = "\u7b2c" + entity.getTalkNum() + "\u8f6e\u62a5\u4ef7";
        entity.setTalkNumName(taikNumName);
        entity.setPurchaseType(subTalkEntity.getPurchaseType());
        super.save((Object)entity);
        SubTalkRecordEntity subTalkRecordEntity = (SubTalkRecordEntity)((Object)BeanMapper.map((Object)((Object)subTalkEntity), SubTalkRecordEntity.class));
        subTalkRecordEntity.setTalkId(subTalkEntity.getId());
        subTalkRecordEntity.setId(null);
        this.subTalkRecordService.save((Object)subTalkRecordEntity);
        List<SubTalkDetailEntity> subTalkDetailList = subTalkEntity.getSubTalkDetailList();
        List subTalkRecordDetailEntityList = BeanMapper.mapList(subTalkDetailList, SubTalkRecordDetailEntity.class);
        for (SubTalkRecordDetailEntity subTalkRecordDetailEntity : subTalkRecordDetailEntityList) {
            subTalkRecordDetailEntity.setId(null);
            subTalkRecordDetailEntity.setRecordId(subTalkRecordEntity.getId());
        }
        this.subTalkRecordDetailService.saveBatch(subTalkRecordDetailEntityList);
        super.removeById((Serializable)id, false);
        LambdaQueryWrapper lambdaProcess = Wrappers.lambdaQuery();
        lambdaProcess.eq(ProcessEntity::getBillId, (Object)id);
        lambdaProcess.eq(ProcessEntity::getTenderId, (Object)subTalkEntity.getInviteId());
        ProcessEntity processEntity = (ProcessEntity)((Object)this.processService.getOne((Wrapper)lambdaProcess));
        processEntity.setBillId(entity.getId());
        this.processService.updateById((Object)processEntity);
        SubTalkVO vo = (SubTalkVO)BeanMapper.map((Object)((Object)entity), SubTalkVO.class);
        this.addLastSell(subTalkEntity.getTalkNum(), subTalkEntity.getBillId());
        return this.queryDetail(entity.getId());
    }

    @Override
    public SubTalkVO replenishSell(Long id) {
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = subTalkEntity.getTalkNum();
        Long billId = subTalkEntity.getBillId();
        this.addLastSell(talkNum, billId);
        return new SubTalkVO();
    }

    @Override
    public Boolean getSellFull(Long id) {
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)super.selectById((Serializable)id));
        Integer talkNum = subTalkEntity.getTalkNum();
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(SubDocumentSupplierEntity::getDocumentId, (Object)subTalkEntity.getBillId());
        lambdaSupplier.eq(SubDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierFirst = Wrappers.lambdaQuery();
        lambdaSupplierFirst.eq(SubDocumentSupplierEntity::getDocumentId, (Object)subTalkEntity.getBillId());
        lambdaSupplierFirst.eq(SubDocumentSupplierEntity::getTalkNum, (Object)0);
        List supplierListFirst = this.subDocumentSupplierService.list((Wrapper)lambdaSupplierFirst);
        if (supplierListFirst == null || supplierListFirst.size() == 0) {
            return false;
        }
        if (supplierList.size() != supplierListFirst.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> querySupplierList(Long talkId) {
        HashMap<String, Object> stringListMap = new HashMap<String, Object>();
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)((SubTalkMapper)this.baseMapper).selectById(talkId));
        ArrayList<SubQuotationMaterialVO> materialVOList = new ArrayList<SubQuotationMaterialVO>();
        List<SubDocumentSellEntity> subDocumentSellEntities = this.subDocumentSellService.selectMaterialType(subTalkEntity.getBillId());
        Integer talkNum = subDocumentSellEntities.get(0).getTalkNum();
        List sellEntityList = BeanMapper.mapList(subDocumentSellEntities, SubDocumentSellVO.class);
        Map<String, List<SubDocumentSellVO>> listMap = sellEntityList.stream().filter(map -> map.getMaterialCode() != null).collect(Collectors.groupingBy(SubDocumentSellVO::getMaterialCode));
        for (String materialTypeId : listMap.keySet()) {
            SubQuotationMaterialVO materialVO = new SubQuotationMaterialVO();
            List<SubDocumentSellVO> materialTypeList = listMap.get(materialTypeId);
            for (SubDocumentSellVO sellVO : materialTypeList) {
                materialVO = (SubQuotationMaterialVO)BeanMapper.map((Object)sellVO, SubQuotationMaterialVO.class);
            }
            List subQuotationSupplierVOS = BeanMapper.mapList(materialTypeList, SubQuotationSupplierVO.class);
            List supplierVOS = subQuotationSupplierVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SubQuotationSupplierVO>(Comparator.comparing(f -> f.getSupplierId()))), ArrayList::new));
            materialVO.setSupplierList(supplierVOS);
            Map<Long, List<SubDocumentSellVO>> supplierMap = materialTypeList.stream().filter(map -> map.getSupplierId() != null).collect(Collectors.groupingBy(SubDocumentSellVO::getSupplierId));
            for (SubQuotationSupplierVO supplierVO : materialVO.getSupplierList()) {
                List<SubDocumentSellVO> subDocumentSellVOS = supplierMap.get(supplierVO.getSupplierId());
                for (SubDocumentSellVO subDocumentSellVO : subDocumentSellVOS) {
                    supplierVO.setSupplierName(subDocumentSellVO.getSupplierName());
                }
                List subQuotationSchemeVOS = BeanMapper.mapList(subDocumentSellVOS, SubQuotationSchemeVO.class);
                List schemeVOS = subQuotationSchemeVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SubQuotationSchemeVO>(Comparator.comparing(f -> f.getSchemeName()))), ArrayList::new));
                supplierVO.setSchemeList(schemeVOS);
                Map<String, List<SubDocumentSellVO>> schemeMap = subDocumentSellVOS.stream().filter(map -> map.getSchemeName() != null).collect(Collectors.groupingBy(SubDocumentSellVO::getSchemeName));
                for (SubQuotationSchemeVO subQuotationSchemeVO : supplierVO.getSchemeList()) {
                    List<SubDocumentSellVO> priceList = schemeMap.get(subQuotationSchemeVO.getSchemeName());
                    if (priceList.size() < talkNum + 1) {
                        SubDocumentSellVO documentSellVO = new SubDocumentSellVO();
                        documentSellVO.setPrice(BigDecimal.valueOf(-1L));
                        documentSellVO.setPriceTax(BigDecimal.valueOf(-1L));
                        documentSellVO.setMoney(BigDecimal.valueOf(-1L));
                        documentSellVO.setMoneyTax(BigDecimal.valueOf(-1L));
                        documentSellVO.setTalkNum(talkNum);
                        priceList.add(0, documentSellVO);
                    }
                    subQuotationSchemeVO.setPriceList(priceList);
                }
            }
            materialVOList.add(materialVO);
        }
        stringListMap.put("MaterialTypeList", materialVOList);
        stringListMap.put("offerNum", subDocumentSellEntities.get(0).getTalkNum());
        return stringListMap;
    }

    @Override
    public SubTalkVO saveOrUpdates(SubTalkVO saveorUpdateVO) {
        SubTalkEntity entity = (SubTalkEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SubTalkEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        SubTalkVO vo = (SubTalkVO)BeanMapper.map((Object)((Object)entity), SubTalkVO.class);
        SubTalkVO subTalkVO = this.queryDetail(vo.getId());
        return subTalkVO;
    }

    private void addLastSell(Integer talkNum, Long docId) {
        LambdaQueryWrapper lambdaSupplier = Wrappers.lambdaQuery();
        lambdaSupplier.eq(SubDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplier.eq(SubDocumentSupplierEntity::getTalkNum, (Object)talkNum);
        List supplierList = this.subDocumentSupplierService.list((Wrapper)lambdaSupplier);
        LambdaQueryWrapper lambdaSupplierLast = Wrappers.lambdaQuery();
        lambdaSupplierLast.eq(SubDocumentSupplierEntity::getDocumentId, (Object)docId);
        lambdaSupplierLast.eq(SubDocumentSupplierEntity::getTalkNum, (Object)(talkNum - 1));
        List supplierListLast = this.subDocumentSupplierService.list((Wrapper)lambdaSupplierLast);
        List supplierPk = supplierList.stream().map(SubDocumentSupplierEntity::getSupplierId).collect(Collectors.toList());
        List documentSupplierEntityDataList = supplierListLast.stream().filter(s -> !supplierPk.contains(s.getSupplierId())).collect(Collectors.toList());
        List documentSupplierEntityNewList = BeanMapper.mapList(documentSupplierEntityDataList, SubDocumentSupplierEntity.class);
        if (documentSupplierEntityNewList.size() == 0) {
            return;
        }
        ArrayList<SupplierReplenishVO> replenishVOArrayList = new ArrayList<SupplierReplenishVO>();
        SubDocumentEntity subDocumentEntity = (SubDocumentEntity)((Object)this.subDocumentService.selectById(docId));
        for (SubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            SupplierReplenishVO supplierReplenishVO = new SupplierReplenishVO();
            supplierReplenishVO.setSourceId(Long.toString(subDocumentEntity.getInviteId()));
            supplierReplenishVO.setTalkNum(talkNum);
            if (subDocumentSupplierEntity.getSupplierTenantId() != null) {
                supplierReplenishVO.setTenantId(Long.toString(subDocumentSupplierEntity.getSupplierTenantId()));
            }
            replenishVOArrayList.add(supplierReplenishVO);
        }
        String stringFb = JSONObject.toJSONString(replenishVOArrayList);
        this.logger.info("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636e:" + stringFb);
        Object response = null;
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.updateSupOffer, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u63a8\u9001\u4f9b\u65b9\u63a5\u53e3\u6570\u636eresponse:" + stringCommonResponse.getMsg());
        }
        List supplierPkNew = documentSupplierEntityNewList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (SubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            subDocumentSupplierEntity.setId(IdWorker.getId());
            subDocumentSupplierEntity.setTalkNum(talkNum);
        }
        this.subDocumentSupplierService.saveBatch(documentSupplierEntityNewList);
        for (SubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
            for (Object subDocumentSupplierLastEntity : supplierListLast) {
                CommonResponse responseCopy;
                if (!(subDocumentSupplierEntity.getSupplierId() != null ? subDocumentSupplierEntity.getSupplierId().equals(((SubDocumentSupplierEntity)((Object)subDocumentSupplierLastEntity)).getSupplierId()) && !(responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(subDocumentSupplierLastEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", subDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess() : subDocumentSupplierEntity.getLinkMobile().equals(subDocumentSupplierEntity.getLinkMobile()) && !(responseCopy = this.attachmentApi.copyFilesFromSourceBillToTargetBill(subDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType", subDocumentSupplierEntity.getId().toString(), BILL_SUPPLIER_TYPE, "supplierFileType")).isSuccess())) continue;
                throw new BusinessException("\u518d\u6b21\u6d3d\u5546\u9644\u4ef6\u590d\u5236\u5931\u8d25:" + responseCopy.getMsg());
            }
        }
        LambdaQueryWrapper lambdaScheme = Wrappers.lambdaQuery();
        lambdaScheme.eq(SubDocumentSchemeEntity::getDocumentId, (Object)docId);
        lambdaScheme.eq(SubDocumentSchemeEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaScheme.in(SubDocumentSchemeEntity::getDocumentSupplierId, supplierPkNew);
        List schemeList = this.subDocumentSchemeService.list((Wrapper)lambdaScheme);
        List schemePkList = schemeList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        for (SubDocumentSchemeEntity subDocumentSchemeEntity : schemeList) {
            subDocumentSchemeEntity.setId(IdWorker.getId());
            subDocumentSchemeEntity.setTalkNum(talkNum);
            for (SubDocumentSupplierEntity subDocumentSupplierEntity : documentSupplierEntityNewList) {
                if (subDocumentSchemeEntity.getIsMobile() != null && subDocumentSchemeEntity.getIsMobile() != 1) {
                    if (!subDocumentSchemeEntity.getSupplierId().equals(subDocumentSupplierEntity.getSupplierId())) continue;
                    subDocumentSchemeEntity.setDocumentSupplierId(subDocumentSupplierEntity.getId());
                    continue;
                }
                if (!subDocumentSchemeEntity.getSupplierName().equals(subDocumentSupplierEntity.getSupplierName())) continue;
                subDocumentSchemeEntity.setDocumentSupplierId(subDocumentSupplierEntity.getId());
            }
        }
        this.subDocumentSchemeService.saveBatch(schemeList);
        LambdaQueryWrapper lambdaSell = Wrappers.lambdaQuery();
        lambdaSell.eq(SubDocumentSellEntity::getDocumentId, (Object)docId);
        lambdaSell.eq(SubDocumentSellEntity::getTalkNum, (Object)(talkNum - 1));
        lambdaSell.in(SubDocumentSellEntity::getSchemeId, schemePkList);
        List sellList = this.subDocumentSellService.list((Wrapper)lambdaSell);
        for (SubDocumentSellEntity subDocumentSellEntity : sellList) {
            subDocumentSellEntity.setId(null);
            subDocumentSellEntity.setTalkNum(talkNum);
            for (SubDocumentSchemeEntity subDocumentSchemeEntity : schemeList) {
                if (subDocumentSellEntity.getIsMobile() != null) {
                    if (!subDocumentSellEntity.getSupplierId().equals(subDocumentSchemeEntity.getSupplierId()) || !subDocumentSellEntity.getSchemeName().equals(subDocumentSchemeEntity.getSchemeName())) continue;
                    subDocumentSellEntity.setSchemeId(subDocumentSchemeEntity.getId());
                    continue;
                }
                if (!subDocumentSellEntity.getSupplierName().equals(subDocumentSchemeEntity.getSupplierName()) || !subDocumentSellEntity.getSchemeName().equals(subDocumentSchemeEntity.getSchemeName())) continue;
                subDocumentSellEntity.setSchemeId(subDocumentSchemeEntity.getId());
            }
        }
        this.subDocumentSellService.saveBatch(sellList);
    }
}

