/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.tender.process.bean.ProcessEntity;
import com.ejianc.business.tender.process.service.IProcessService;
import com.ejianc.business.tender.rent.bean.RentDocumentEntity;
import com.ejianc.business.tender.rent.bean.RentInviteEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageEntity;
import com.ejianc.business.tender.rent.bean.RentPicketageSupplierEntity;
import com.ejianc.business.tender.rent.bean.RentWinnoticeEntity;
import com.ejianc.business.tender.rent.mapper.RentWinnoticeMapper;
import com.ejianc.business.tender.rent.service.IRentBidDetailService;
import com.ejianc.business.tender.rent.service.IRentBidSupplierService;
import com.ejianc.business.tender.rent.service.IRentDocumentSellService;
import com.ejianc.business.tender.rent.service.IRentDocumentService;
import com.ejianc.business.tender.rent.service.IRentDocumentSupplierService;
import com.ejianc.business.tender.rent.service.IRentInviteService;
import com.ejianc.business.tender.rent.service.IRentNoticeService;
import com.ejianc.business.tender.rent.service.IRentPicketageService;
import com.ejianc.business.tender.rent.service.IRentPicketageSupplierService;
import com.ejianc.business.tender.rent.service.IRentWinnoticeService;
import com.ejianc.business.tender.rent.vo.RentPicketageSupplierVO;
import com.ejianc.business.tender.rent.vo.RentWinDetailVO;
import com.ejianc.business.tender.rent.vo.RentWinVO;
import com.ejianc.business.tender.rent.vo.RentWinnoticeVO;
import com.ejianc.business.tender.rent.vo.TenderStageEnum;
import com.ejianc.business.tender.util.CommonUtils;
import com.ejianc.business.tender.util.TenderTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IShareSupplierApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rentWinnoticeService")
public class RentWinnoticeServiceImpl
extends BaseServiceImpl<RentWinnoticeMapper, RentWinnoticeEntity>
implements IRentWinnoticeService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRentPicketageService rentPicketageService;
    @Autowired
    private IRentNoticeService rentNoticeService;
    @Autowired
    private IRentDocumentService rentDocumentService;
    @Autowired
    private IRentInviteService rentInviteService;
    @Autowired
    private IRentBidDetailService rentBidDetailService;
    @Autowired
    private IRentDocumentSellService rentDocumentSellService;
    @Autowired
    private IRentBidSupplierService rentBidSupplierService;
    @Autowired
    private IRentDocumentSupplierService rentDocumentSupplierService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${gysUrl.winSaveOrUpdateUrl}")
    private String winSaveOrUpdateUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Value(value="${gysUrl.appId}")
    private String appId;
    @Value(value="${gysUrl.appSecret}")
    private String appSecret;
    @Value(value="${gysUrl.appHost}")
    private String appHost;
    @Autowired
    private IShareSupplierApi shareSupplierApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentPicketageSupplierService rentPicketageSupplierService;
    private static final String BILL_TYPE = "BT220125000000001";
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional
    public RentWinnoticeVO saveWinnotice(Long picketageId) {
        RentWinnoticeEntity entity = new RentWinnoticeEntity();
        entity.setPicketageId(picketageId);
        RentPicketageEntity rentPicketageEntity = (RentPicketageEntity)((Object)this.rentPicketageService.selectById(picketageId));
        RentInviteEntity inviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentPicketageEntity.getInviteId()));
        entity.setInviteId(rentPicketageEntity.getInviteId());
        entity.setTitleName(inviteEntity.getTenderName() + "\u4e2d\u6807\u516c\u544a");
        entity.setInviteName(inviteEntity.getTenderName());
        entity.setUnitId(inviteEntity.getUnitId());
        entity.setUnitName(inviteEntity.getUnitName());
        if (inviteEntity.getPurchaseType().equals(0)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
            entity.setProjectId(inviteEntity.getProjectId());
            entity.setProjectName(inviteEntity.getProjectName());
            entity.setProjectCode(inviteEntity.getProjectCode());
            entity.setParentOrgId(inviteEntity.getParentOrgId());
            entity.setParentOrgName(inviteEntity.getParentOrgName());
        }
        if (inviteEntity.getPurchaseType().equals(1)) {
            entity.setOrgId(inviteEntity.getOrgId());
            entity.setOrgName(inviteEntity.getOrgName());
        }
        RentDocumentEntity rentDocumentEntity = (RentDocumentEntity)((Object)this.rentDocumentService.selectById(rentPicketageEntity.getDocumentId()));
        entity.setEmployeeId(rentDocumentEntity.getEmployeeId());
        entity.setEmployeeName(rentDocumentEntity.getEmployeeName());
        entity.setEmployeeMobile(rentDocumentEntity.getEmployeeMobile());
        entity.setPurchaseType(inviteEntity.getPurchaseType());
        entity.setPublishFlag(1);
        entity.setNextFlag(1);
        entity.setSignFlag(0);
        entity.setLineTypeName(CommonUtils.getTypeName(3));
        entity.setTenderTypeName(TenderTypeEnum.getEnumByStateCode((Integer)inviteEntity.getTenderType()).getDescription());
        super.saveOrUpdate((Object)entity, false);
        rentPicketageEntity.setWinnoticeStatus(1);
        rentPicketageEntity.setWinnoticeId(entity.getId());
        this.rentPicketageService.updateById((Object)rentPicketageEntity);
        inviteEntity.setTenderStage(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getTenderTypeCode());
        this.rentInviteService.updateById((Object)inviteEntity);
        List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
        for (RentPicketageSupplierEntity rentPicketageSupplierEntity : picketageSupplierList) {
            rentPicketageSupplierEntity.setWinnoticeId(entity.getId());
        }
        this.rentPicketageSupplierService.updateBatchById(picketageSupplierList);
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setBillId(entity.getId());
        processEntity.setBillName(TenderStageEnum.BID_ANNOUNCEMENT_STATE.getDescription());
        processEntity.setTenderId(entity.getInviteId());
        processEntity.setType(3);
        processEntity.setFrontendUrl("rent/winnotice");
        this.processService.saveOrUpdate((Object)processEntity);
        RentWinnoticeVO rentWinnoticeVO = (RentWinnoticeVO)BeanMapper.map((Object)((Object)entity), RentWinnoticeVO.class);
        return rentWinnoticeVO;
    }

    @Override
    public RentWinnoticeVO queryDetail(Long id) {
        Map attacMap;
        AttachmentVO attachmentVO;
        List data;
        Long id1;
        CommonResponse listCommonResponse;
        RentWinnoticeEntity rentWinnoticeEntity = (RentWinnoticeEntity)((Object)super.selectById((Serializable)id));
        RentWinnoticeVO rentWinnoticeVO = (RentWinnoticeVO)BeanMapper.map((Object)((Object)rentWinnoticeEntity), RentWinnoticeVO.class);
        RentPicketageEntity rentPicketageEntity = (RentPicketageEntity)((Object)this.rentPicketageService.selectById(rentWinnoticeEntity.getPicketageId()));
        List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
        List rentPicketageSupplierList = BeanMapper.mapList(picketageSupplierList, RentPicketageSupplierVO.class);
        rentWinnoticeVO.setPicketageSupplierList(rentPicketageSupplierList);
        if (rentWinnoticeVO != null && (listCommonResponse = this.attachmentApi.queryListBySourceId(id1 = rentWinnoticeVO.getId(), BILL_TYPE, "tenderWinnotice", "")).isSuccess() && CollectionUtils.isNotEmpty((Collection)(data = (List)listCommonResponse.getData())) && (attachmentVO = (AttachmentVO)(attacMap = data.stream().filter(s -> s.getSourceType().equals("tenderWinnotice")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()))).get(rentWinnoticeVO.getId())) != null) {
            rentWinnoticeVO.setAttachId(attachmentVO.getId());
            rentWinnoticeVO.setFileName(attachmentVO.getFileName());
            rentWinnoticeVO.setFilePath(attachmentVO.getFilePath());
        }
        return rentWinnoticeVO;
    }

    @Override
    public RentWinnoticeVO publishWinnotice(Long id) {
        RentWinnoticeEntity rentWinnoticeEntity = (RentWinnoticeEntity)((Object)super.selectById((Serializable)id));
        rentWinnoticeEntity.setPublishFlag(0);
        super.updateById((Object)rentWinnoticeEntity);
        RentPicketageEntity rentPicketageEntity = (RentPicketageEntity)((Object)this.rentPicketageService.selectById(rentWinnoticeEntity.getPicketageId()));
        rentPicketageEntity.setWinnoticeStatus(2);
        this.rentPicketageService.updateById((Object)rentPicketageEntity);
        RentInviteEntity rentInviteEntity = (RentInviteEntity)((Object)this.rentInviteService.selectById(rentPicketageEntity.getInviteId()));
        RentWinVO winVO = new RentWinVO();
        winVO.setSourceType("\u90d1\u5dde\u4e00\u5efa\u4e2d\u6807\u516c\u544a");
        winVO.setSourceId(Long.toString(rentWinnoticeEntity.getInviteId()));
        winVO.setBillCode(rentInviteEntity.getBillCode());
        if (rentInviteEntity.getPurchaseType() == 0) {
            winVO.setSourceProjectId(Long.toString(rentInviteEntity.getProjectId()));
            winVO.setProjectName(rentInviteEntity.getProjectName());
            winVO.setProjectCode(rentInviteEntity.getProjectCode());
        }
        if (rentInviteEntity.getPurchaseType() == 1) {
            winVO.setOrgName(rentInviteEntity.getOrgName());
            winVO.setSourceOrgId(Long.toString(rentInviteEntity.getOrgId()));
        }
        winVO.setSourceUnitId(Long.toString(rentInviteEntity.getUnitId()));
        winVO.setUnitName(rentInviteEntity.getUnitName());
        winVO.setType("RENT");
        winVO.setTenderName(rentInviteEntity.getTenderName());
        winVO.setTenderType(rentInviteEntity.getTenderType());
        winVO.setSourceEmployeeId(Long.toString(rentWinnoticeEntity.getEmployeeId()));
        winVO.setEmployeeName(rentWinnoticeEntity.getEmployeeName());
        winVO.setEmployeeMobile(rentWinnoticeEntity.getEmployeeMobile());
        winVO.setPurchaseType(rentInviteEntity.getPurchaseType());
        winVO.setWinDate(rentWinnoticeEntity.getWinDate());
        winVO.setStopDate(rentWinnoticeEntity.getStopDate());
        winVO.setWinTitle(rentWinnoticeEntity.getTitleName());
        winVO.setMemo(rentWinnoticeEntity.getMemo());
        winVO.setSystemId((String)this.proSupplierApi.getEjcCloudSystemCode().getData());
        List<RentPicketageSupplierEntity> picketageSupplierList = rentPicketageEntity.getPicketageSupplierList();
        ArrayList<RentWinDetailVO> winDetailVOS = new ArrayList<RentWinDetailVO>();
        for (RentPicketageSupplierEntity rentPicketageSupplierEntity : picketageSupplierList) {
            RentWinDetailVO winDetailVO = new RentWinDetailVO();
            winDetailVO.setWinId(rentWinnoticeEntity.getId());
            winDetailVO.setSupplierName(rentPicketageSupplierEntity.getSupplierName());
            winDetailVO.setTenderFlag(rentPicketageSupplierEntity.getTenderFlag());
            SupplierDTO supplierVO = (SupplierDTO)this.shareSupplierApi.queryById(rentPicketageSupplierEntity.getSupplierId()).getData();
            winDetailVO.setTenantId(supplierVO.getTenant());
            winDetailVO.setMoney(rentPicketageSupplierEntity.getMoneyTax());
            winDetailVOS.add(winDetailVO);
        }
        winVO.setWinDetailList(winDetailVOS);
        String stringFb = JSONObject.toJSONString((Object)winVO);
        this.logger.info("\u4e2d\u6807\u516c\u544a\u53d1\u5e03" + stringFb);
        CommonResponse stringCommonResponse = this.systemDataPushService.exchangeDataWithUniversal(this.winSaveOrUpdateUrl, RequestMethod.POST, stringFb, this.appId, this.appSecret, this.appHost);
        if (!stringCommonResponse.isSuccess()) {
            throw new BusinessException("\u4e2d\u6807\u516c\u544a\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3\u62a5\u9519" + stringCommonResponse.getMsg());
        }
        return this.queryDetail(id);
    }

    @Override
    public RentWinnoticeVO saveOrUpdates(RentWinnoticeEntity entity) {
        super.saveOrUpdate((Object)entity, false);
        return this.queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> changeStatus(Long billId, int status, String refCode) {
        RentWinnoticeEntity rentWinnoticeEntity = (RentWinnoticeEntity)((Object)super.selectById((Serializable)billId));
        if (status == 5 || status == 6 || status == 7 || status == 8) {
            rentWinnoticeEntity.setSignFlag(0);
        }
        if (status == 2 || status == 3) {
            rentWinnoticeEntity.setSignFlag(1);
        }
        if (status == 4) {
            rentWinnoticeEntity.setSignFlag(2);
            ContractVO cv = new ContractVO();
            cv.setContractId(rentWinnoticeEntity.getId());
            cv.setContractName(rentWinnoticeEntity.getTitleName());
            cv.setBillType(BILL_TYPE);
            cv.setSourceType("tenderWinnotice");
            ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
            cvs.add(cv);
            CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
            if (!signResp.isSuccess()) {
                throw new BusinessException("\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25!");
            }
        }
        super.updateById((Object)rentWinnoticeEntity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f!");
    }
}

