/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tender.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tender.stuff.bean.StuffCheckEntity;
import com.ejianc.business.tender.stuff.service.IStuffCheckService;
import com.ejianc.business.tender.sub.bean.SubDocumentEntity;
import com.ejianc.business.tender.sub.bean.SubDocumentSupplierEntity;
import com.ejianc.business.tender.sub.bean.SubTalkEntity;
import com.ejianc.business.tender.sub.service.ISubDocumentService;
import com.ejianc.business.tender.sub.service.ISubDocumentSupplierService;
import com.ejianc.business.tender.sub.service.ISubTalkService;
import com.ejianc.business.tender.sub.vo.SubDocumentRecordVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSupplierSellVO;
import com.ejianc.business.tender.sub.vo.SubDocumentSupplierVO;
import com.ejianc.business.tender.sub.vo.SubDocumentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.vo.SubleadersVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"subDocument"})
@Api(value="\u62db\u6807\u6587\u4ef6\u4e3b\u8868", tags={"\u62db\u6807\u6587\u4ef6\u4e3b\u8868"})
public class SubDocumentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "invite-document-code";
    @Autowired
    private ISubDocumentService service;
    @Autowired
    private ISubTalkService talkService;
    @Autowired
    private ISubDocumentSupplierService documentSupplierService;
    @Autowired
    private IStuffCheckService checkService;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubDocumentVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SubDocumentVO saveorUpdateVO) {
        SubDocumentVO subDocumentVO = this.service.saveOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)subDocumentVO);
    }

    @ApiOperation(value="\u4f9b\u65b9\u63a8\u9001\u62a5\u4ef7\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"/supplierPushSell"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> supplierPushSell(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile file) {
        Boolean b = this.service.supplierPushSell(request, file);
        return CommonResponse.success((String)"\u63a8\u9001\u62a5\u4ef7\u4fe1\u606f\u6210\u529f\uff01", (Object)b);
    }

    @ApiOperation(value="\u53d1\u5e03\u63a5\u53e3")
    @RequestMapping(value={"/publishDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentVO> publishDocument(@RequestParam Long id) throws Exception {
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01", (Object)this.service.publishDocument(id));
    }

    @ApiOperation(value="\u7b54\u7591\u9644\u4ef6\u4e0a\u4f20\u540c\u6b65\u4f9b\u65b9\u65b0\u589e\u63a5\u53e3")
    @RequestMapping(value={"/uploadById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> uploadById(@RequestParam Long attachId, @RequestParam Long inviteId) throws Exception {
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01", (Object)this.service.uploadById(attachId, inviteId));
    }

    @ApiOperation(value="\u7b54\u7591\u9644\u4ef6\u5220\u9664\u540c\u6b65\u4f9b\u65b9\u63a5\u53e3")
    @RequestMapping(value={"/deleteFileById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteFileById(@RequestBody SubDocumentVO subDocumentVO) throws Exception {
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01", (Object)this.service.deleteFileById(subDocumentVO.getSourceId(), subDocumentVO.getFileNames()));
    }

    @ApiOperation(value="\u7ade\u4e89\u6027\u8c08\u5224\u7b49\u53d1\u5e03\u63a5\u53e3")
    @RequestMapping(value={"/publishManyDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentVO> publish4Document(@RequestParam Long id) throws InvocationTargetException, IllegalAccessException {
        return CommonResponse.success((String)"\u53d1\u5e03\u6210\u529f\uff01", (Object)this.service.publishManyDocument(id));
    }

    @ApiOperation(value="\u6839\u636e\u4f9b\u5e94\u5546\u4e3b\u952e\u548c\u65b9\u6848\u4e3b\u952e\u67e5\u8be2\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/getSchemeDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SubDocumentSellVO>> getSchemeDetail(@RequestBody SubDocumentSellVO subDocumentSellVO) {
        List<SubDocumentSellVO> list = this.service.getSchemeDetail(subDocumentSellVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @ApiOperation(value="\u5f00\u6807\u63a5\u53e3")
    @RequestMapping(value={"/bidDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentVO> bidDocument(@RequestParam Long id) {
        SubDocumentVO s = this.service.bidDocument(id);
        return CommonResponse.success((String)"\u5f00\u6807\u6210\u529f\uff01", (Object)s);
    }

    @ApiOperation(value="\u5ef6\u957f\u622a\u6b62\u65f6\u95f4\u63a5\u53e3")
    @RequestMapping(value={"/extendDocument"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubDocumentVO> extendDocument(@RequestBody SubDocumentRecordVO subDocumentRecordVO) {
        return CommonResponse.success((String)"\u5ef6\u957f\u622a\u6b62\u65f6\u95f4\uff01", (Object)this.service.extendDocument(subDocumentRecordVO));
    }

    @ApiOperation(value="\u5254\u9664\u4f9b\u5e94\u5546")
    @RequestMapping(value={"/delSupplier"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse delSupplier(@RequestParam Long id) {
        return this.service.delSupplier(id);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u65b9\u6848\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/getSupplierSchemeDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentSupplierSellVO> getSupplierSchemeDetail(Long supplierDetailId, Long documentId) {
        SubDocumentSupplierSellVO subDocumentSupplierSellVO = this.service.getSupplierSchemeDetail(supplierDetailId, documentId);
        return CommonResponse.success((String)"\u5f00\u6807\u6210\u529f\uff01", (Object)subDocumentSupplierSellVO);
    }

    @ApiOperation(value="\u5b9a\u6807\u4e2d\u67e5\u8be2\u4f9b\u5e94\u5546\u65b9\u6848\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/getSupplierSchemeDetailDb"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentSupplierSellVO> getSupplierSchemeDetailDb(Long schemeId, Long documentId) {
        SubDocumentSupplierSellVO subDocumentSupplierSellVO = this.service.getSupplierSchemeDetailDb(schemeId, documentId);
        return CommonResponse.success((String)"\u5f00\u6807\u6210\u529f\uff01", (Object)subDocumentSupplierSellVO);
    }

    @ApiOperation(value="\u6d3d\u5546\u8c08\u5224\u67e5\u8be2\u4f9b\u5e94\u5546\u65b9\u6848\u8be6\u60c5\u63a5\u53e3")
    @RequestMapping(value={"/getSupplierSchemeDetailTalk"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentSupplierSellVO> getSupplierSchemeDetailTalk(Long supplierDetailId, Long talkId) {
        SubDocumentSupplierSellVO subDocumentSupplierSellVO = this.service.getSupplierSchemeDetailTalk(supplierDetailId, talkId);
        return CommonResponse.success((String)"\u5f00\u6807\u6210\u529f\uff01", (Object)subDocumentSupplierSellVO);
    }

    @ApiOperation(value="\u6d3d\u5546\u8c08\u5224\u4f9b\u5e94\u5546\u65b9\u6848\u8be6\u60c5\u63a5\u53e3(\u591a\u8f6e\u663e\u793a)")
    @RequestMapping(value={"/getSupplierSchemeTalkDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentSupplierSellVO> getSupplierSchemeTalkDetail(Long supplierDetailId, Long talkId) {
        SubDocumentSupplierSellVO subDocumentSupplierSellVO = this.service.getSupplierSchemeTalkDetail(supplierDetailId, talkId);
        return CommonResponse.success((String)"\u5f00\u6807\u6210\u529f\uff01", (Object)subDocumentSupplierSellVO);
    }

    @ApiOperation(value="\u62db\u6807\u516c\u544a\u4e0b\u4e00\u6b65\u63a5\u53e3")
    @RequestMapping(value={"/saveDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentVO> saveDocument(@RequestParam Long noticeId) {
        SubDocumentVO subDocumentVO = this.service.saveDocument(noticeId);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)subDocumentVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentVO> queryDetail(@RequestParam Long id) {
        SubDocumentVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubDocumentVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubDocumentVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubDocumentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubDocument-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSubDocumentData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubDocumentVO>> refSubDocumentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubDocumentVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u7ade\u4e89\u6027\u8c08\u5224\u7b49\u4e0b\u4e00\u6b65\u63a5\u53e3")
    @RequestMapping(value={"/saveManyDocument"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentVO> saveManyDocument(@RequestParam Long id) {
        SubDocumentEntity subDocumentEntity = new SubDocumentEntity();
        if (subDocumentEntity.getId() == null || subDocumentEntity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                subDocumentEntity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        SubDocumentVO vo = this.service.saveManyDocument(id);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4e3b\u952eID")
    @RequestMapping(value={"/querySupplierId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentSupplierEntity> querySupplierId(@RequestParam Long supplierId, @RequestParam Long talkId) {
        SubTalkEntity subTalkEntity = (SubTalkEntity)((Object)this.talkService.selectById(talkId));
        List list = this.documentSupplierService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"supplier_id", (Object)supplierId)).eq((Object)"document_id", (Object)subTalkEntity.getBillId()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", list.get(0));
    }

    @ApiOperation(value="\u68c0\u67e5\u4e13\u5bb6\u6570\u91cf")
    @RequestMapping(value={"/checkExpertNum"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkExpertNum(@RequestParam Long documentId) {
        CommonResponse<Boolean> response = this.service.checkExpertNum(documentId);
        return response;
    }

    @ApiOperation(value="\u672c\u5730\u63a8\u9001\u62a5\u4ef7\u4fe1\u606f\u63a5\u53e3")
    @RequestMapping(value={"/localPushSell"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> localPushSell(@RequestBody Map<String, Object> params, @RequestParam(value="file", required=false) MultipartFile file) {
        Boolean b = this.service.localPushSell(params, file);
        return CommonResponse.success((String)"\u63a8\u9001\u62a5\u4ef7\u4fe1\u606f\u6210\u529f\uff01", null);
    }

    @ApiOperation(value="\u624b\u673a\u8be2\u4ef7\u540c\u6b65\u975e\u5e93\u4f9b\u5e94\u5546")
    @RequestMapping(value={"/synSupplier"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> synSupplier(@RequestParam Long documentId) {
        CommonResponse<Boolean> response = this.service.synSupplier(documentId);
        return response;
    }

    @ApiOperation(value="\u624b\u673a\u8be2\u4ef7\u540c\u6b65\u975e\u5e93\u5206\u5305\u8d1f\u8d23\u4eba")
    @RequestMapping(value={"/synLeader"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> synLeader(@RequestParam Long pickId, @RequestParam String phone, @RequestParam Long supplierId) {
        CommonResponse<Boolean> response = this.service.synLeader(pickId, phone, supplierId);
        return response;
    }

    @ApiOperation(value="\u624b\u673a\u8be2\u4ef7\u540c\u6b65\u975e\u5e93\u5206\u5305\u8d1f\u8d23\u4eba")
    @RequestMapping(value={"/getLeaderSupplier"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SubleadersVO>> getLeaderSupplier(@RequestParam Long pickId, @RequestParam String phone) {
        CommonResponse<List<SubleadersVO>> response = this.service.getLeaderSupplier(pickId, phone);
        return response;
    }

    @RequestMapping(value={"/getIsPush"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubDocumentSupplierVO> getIsPush(@RequestParam Long id, @RequestParam String phone) {
        SubDocumentVO stuffDocumentVO = this.service.queryDetail(id);
        List stuffDocumentSupplierList = stuffDocumentVO.getSubDocumentSupplierList();
        List stuffCheckEntities = this.checkService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).eq(StuffCheckEntity::getPhone, (Object)phone)).eq(StuffCheckEntity::getYxzt, (Object)2)).eq(StuffCheckEntity::getDocumentId, (Object)id));
        StuffCheckEntity stuffCheckEntity = (StuffCheckEntity)((Object)stuffCheckEntities.get(stuffCheckEntities.size() - 1));
        for (SubDocumentSupplierVO stuffDocumentSupplierVO : stuffDocumentSupplierList) {
            if (!phone.equals(stuffDocumentSupplierVO.getSupplierId() + "") && (stuffCheckEntity.getSupplierId() == null || !stuffCheckEntity.getSupplierId().equals(stuffDocumentSupplierVO.getSupplierId())) || !CollectionUtils.isNotEmpty((Collection)stuffCheckEntities)) continue;
            stuffDocumentSupplierVO.setTaxPayerIdentifier(stuffCheckEntity.getTaxPayerIdentifier());
            return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)stuffDocumentSupplierVO);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", null);
    }

    @ApiOperation(value="\u624b\u673a\u7aef\u68c0\u9a8c\u662f\u5426\u8fdb\u884c\u8fc7\u62a5\u4ef7")
    @RequestMapping(value={"/checkDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> checkDetail(@RequestParam Long supplierId, @RequestParam Long documentId, @RequestParam String phone) {
        Boolean b = this.service.checkDetail(supplierId, documentId, phone);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)b);
    }
}

