package com.ejianc.business.trade.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.trade.vo.ReceiveZiVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 收货单
 * 
 * @author generator
 * 
 */
public class ReceiveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String receiveAddress; // 收货地址
    private Long lxrId; // 联系人id
    private String lxrName; // 联系人
    private String lxfs; // 联系方式
    private Date shipmentsDate; // 发货日期
    private String carId; // 车牌号
    private String driverPhone; // 司机手机号
    private Long shipmentsId; // 发货单id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date receiveDate; // 签收日期
    private Integer receiveNum; // 收货总数
    private String xxpbm; // 销项票编码
    private Long dhdwId; // 订货单位
    private String dhdwName; // 订货单位名称
    private Long xmId; // 项目id
    private String xmName; // 项目名称


    public Long getDhdwId() {
        return dhdwId;
    }

    public void setDhdwId(Long dhdwId) {
        this.dhdwId = dhdwId;
    }

    public String getDhdwName() {
        return dhdwName;
    }

    public void setDhdwName(String dhdwName) {
        this.dhdwName = dhdwName;
    }

    public Long getXmId() {
        return xmId;
    }

    public void setXmId(Long xmId) {
        this.xmId = xmId;
    }

    public String getXmName() {
        return xmName;
    }

    public void setXmName(String xmName) {
        this.xmName = xmName;
    }
    
    private List<ReceiveZiVO> receiveZiList = new ArrayList<>(); // 收货单子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getReceiveAddress() {
        return receiveAddress;
    }

    public void setReceiveAddress(String receiveAddress) {
        this.receiveAddress = receiveAddress;
    }
    public Long getLxrId() {
        return lxrId;
    }

    public void setLxrId(Long lxrId) {
        this.lxrId = lxrId;
    }
    public String getLxrName() {
        return lxrName;
    }

    public void setLxrName(String lxrName) {
        this.lxrName = lxrName;
    }
    public String getLxfs() {
        return lxfs;
    }

    public void setLxfs(String lxfs) {
        this.lxfs = lxfs;
    }
    public Date getShipmentsDate() {
        return shipmentsDate;
    }

    public void setShipmentsDate(Date shipmentsDate) {
        this.shipmentsDate = shipmentsDate;
    }
    public String getCarId() {
        return carId;
    }

    public void setCarId(String carId) {
        this.carId = carId;
    }
    public String getDriverPhone() {
        return driverPhone;
    }

    public void setDriverPhone(String driverPhone) {
        this.driverPhone = driverPhone;
    }

    @ReferSerialTransfer(referCode = "trade_shipments")
    public Long getShipmentsId() {
        return shipmentsId;
    }
    @ReferDeserialTransfer
    public void setShipmentsId(Long shipmentsId) {
        this.shipmentsId = shipmentsId;
    }
    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }
    public Integer getReceiveNum() {
        return receiveNum;
    }

    public void setReceiveNum(Integer receiveNum) {
        this.receiveNum = receiveNum;
    }
    public String getXxpbm() {
        return xxpbm;
    }

    public void setXxpbm(String xxpbm) {
        this.xxpbm = xxpbm;
    }
    
     public List<ReceiveZiVO> getReceiveZiList() {
        return receiveZiList;
     }

     public void setReceiveZiList(List<ReceiveZiVO> receiveZiList) {
        this.receiveZiList = receiveZiList;
     }
}
