package com.ejianc.business.trade.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.trade.vo.ShipmentsZiVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 发货单
 * 
 * @author generator
 * 
 */
public class ShipmentsVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private String receiveAddress; // 收货地址
    private Long lxrId; // 联系人id
    private String lxrName; // 联系人
    private String lxfs; // 联系方式
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date shipmentsDate; // 发货日期
    private String carId; // 车牌号
    private String driverPhone; // 司机手机号
    private Long confirmationId; // 订货单
    private Integer shipmentsTime; // 发货时段(1:上午，2：下午）


    public Integer getShipmentsTime() {
        return shipmentsTime;
    }

    public void setShipmentsTime(Integer shipmentsTime) {
        this.shipmentsTime = shipmentsTime;
    }
    @ReferSerialTransfer(referCode = "trade_confirmation")
    public Long getConfirmationId() {
        return confirmationId;
    }
    @ReferDeserialTransfer
    public void setConfirmationId(Long confirmationId) {
        this.confirmationId = confirmationId;
    }
    private List<ShipmentsZiVO> shipmentsZiList = new ArrayList<>(); // 发货单子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getReceiveAddress() {
        return receiveAddress;
    }

    public void setReceiveAddress(String receiveAddress) {
        this.receiveAddress = receiveAddress;
    }
    public Long getLxrId() {
        return lxrId;
    }

    public void setLxrId(Long lxrId) {
        this.lxrId = lxrId;
    }
    public String getLxrName() {
        return lxrName;
    }

    public void setLxrName(String lxrName) {
        this.lxrName = lxrName;
    }
    public String getLxfs() {
        return lxfs;
    }

    public void setLxfs(String lxfs) {
        this.lxfs = lxfs;
    }
    public Date getShipmentsDate() {
        return shipmentsDate;
    }

    public void setShipmentsDate(Date shipmentsDate) {
        this.shipmentsDate = shipmentsDate;
    }
    public String getCarId() {
        return carId;
    }

    public void setCarId(String carId) {
        this.carId = carId;
    }
    public String getDriverPhone() {
        return driverPhone;
    }

    public void setDriverPhone(String driverPhone) {
        this.driverPhone = driverPhone;
    }
    
     public List<ShipmentsZiVO> getShipmentsZiList() {
        return shipmentsZiList;
     }

     public void setShipmentsZiList(List<ShipmentsZiVO> shipmentsZiList) {
        this.shipmentsZiList = shipmentsZiList;
     }
}
