package com.ejianc.business.tradematerial.check.vo;

import com.ejianc.business.tradematerial.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 消耗材-验收主表
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材-验收主表")
public class SupplierPushCheckVO  {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("订单主键")
    private Long orderId;
    @ApiModelProperty("发货主键")
    private Long deliveryId;
    @ApiModelProperty("验收状态（0-未验收，1--已验收）")
    private Integer checkState;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目code")
    private String projectCode;
    @ApiModelProperty("供应商主键")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("验收人名称")
    private String checkerName;
    @ApiModelProperty("经办部门")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate;
    @ApiModelProperty("车牌号")
    private String licensePlate;
    @ApiModelProperty("是否补录，0-否，1-是")
    private Integer recordFlag;
    @ApiModelProperty("补录原因")
    private String recordReson;

    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("验收类型，0-其他，1-采购验收,2-周转材租赁,3-MRO")
    private String checkType;
    @ApiModelProperty("入库方式，0-收料入库，1-直入直出")
    private Integer storeType;
    @ApiModelProperty("验收来源，0-自制验收,1-发货验收")
    private Integer sourceType;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("仓库主键")
    private Long storeId;
    @ApiModelProperty("仓库名称")
    private String storeName;
    @ApiModelProperty("入库日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date instoreDate;
    @ApiModelProperty("分包合同主键")
    private Long subContractId;
    @ApiModelProperty("分包合同名称")
    private String subContractName;
    @ApiModelProperty("分包合同code")
    private String subContractCode;
    @ApiModelProperty("分包合同供应商主键")
    private Long subSupplierId;
    @ApiModelProperty("分包合同供应商名称")
    private String subSupplierName;
    @ApiModelProperty("分包负责人名称")
    private String subEmployeeName;
    @ApiModelProperty("联系电话")
    private String subEmployeePhone;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("小票数量")
    private BigDecimal ticketNum;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    private String checkTypeName;
    private Long sourceId;
    private String systemId;
    @ApiModelProperty("消耗材-验收明细子表")
    private List<SupplierPushCheckDetailVO> checkDetailList = new ArrayList<>();
    @ApiModelProperty("混凝土-验收明细子表")
    private List<SupplierPushCheckDetailVO> concreteCheckDetailList = new ArrayList<>();

    public List<SupplierPushCheckDetailVO> getConcreteCheckDetailList() {
        return concreteCheckDetailList;
    }

    public void setConcreteCheckDetailList(List<SupplierPushCheckDetailVO> concreteCheckDetailList) {
        this.concreteCheckDetailList = concreteCheckDetailList;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    /**
     * 订单主键
     */
    public Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 发货主键
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货主键
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 验收状态（0-未验收，1--已验收）
     */
    public Integer getCheckState() {
        return checkState;
    }

    /**
     * 验收状态（0-未验收，1--已验收）
     */
    public void setCheckState(Integer checkState) {
        this.checkState = checkState;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同code
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同code
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目code
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目code
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 供应商主键
     */

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商主键
     */
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 验收人名称
     */
    public String getCheckerName() {
        return checkerName;
    }

    /**
     * 验收人名称
     */
    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }
    /**
     * 经办部门
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 验收日期
     */
    public Date getCheckDate() {
        return checkDate;
    }

    /**
     * 验收日期
     */
    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    /**
     * 车牌号
     */
    public String getLicensePlate() {
        return licensePlate;
    }

    /**
     * 车牌号
     */
    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    /**
     * 是否补录，0-否，1-是
     */
    public Integer getRecordFlag() {
        return recordFlag;
    }

    /**
     * 是否补录，0-否，1-是
     */
    public void setRecordFlag(Integer recordFlag) {
        this.recordFlag = recordFlag;
    }
    /**
     * 补录原因
     */
    public String getRecordReson() {
        return recordReson;
    }

    /**
     * 补录原因
     */
    public void setRecordReson(String recordReson) {
        this.recordReson = recordReson;
    }

    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getCheckType() {
        return checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 仓库名称
     */
    public String getStoreName() {
        return storeName;
    }

    /**
     * 仓库名称
     */
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    /**
     * 入库日期
     */
    public Date getInstoreDate() {
        return instoreDate;
    }

    /**
     * 入库日期
     */
    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }

    /**
     * 分包合同名称
     */
    public String getSubContractName() {
        return subContractName;
    }

    /**
     * 分包合同名称
     */
    public void setSubContractName(String subContractName) {
        this.subContractName = subContractName;
    }
    /**
     * 分包合同code
     */
    public String getSubContractCode() {
        return subContractCode;
    }

    /**
     * 分包合同code
     */
    public void setSubContractCode(String subContractCode) {
        this.subContractCode = subContractCode;
    }
    /**
     * 分包合同供应商主键
     */
    public Long getSubSupplierId() {
        return subSupplierId;
    }

    /**
     * 分包合同供应商主键
     */
    public void setSubSupplierId(Long subSupplierId) {
        this.subSupplierId = subSupplierId;
    }
    /**
     * 分包合同供应商名称
     */
    public String getSubSupplierName() {
        return subSupplierName;
    }

    /**
     * 分包合同供应商名称
     */
    public void setSubSupplierName(String subSupplierName) {
        this.subSupplierName = subSupplierName;
    }
    /**
     * 分包负责人名称
     */
    public String getSubEmployeeName() {
        return subEmployeeName;
    }

    /**
     * 分包负责人名称
     */
    public void setSubEmployeeName(String subEmployeeName) {
        this.subEmployeeName = subEmployeeName;
    }
    /**
     * 联系电话
     */
    public String getSubEmployeePhone() {
        return subEmployeePhone;
    }

    /**
     * 联系电话
     */
    public void setSubEmployeePhone(String subEmployeePhone) {
        this.subEmployeePhone = subEmployeePhone;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 小票数量
     */
    public BigDecimal getTicketNum() {
        return ticketNum;
    }

    /**
     * 小票数量
     */
    public void setTicketNum(BigDecimal ticketNum) {
        this.ticketNum = ticketNum;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<SupplierPushCheckDetailVO> getCheckDetailList() {
        return checkDetailList;
    }

    public void setCheckDetailList(List<SupplierPushCheckDetailVO> checkDetailList) {
        this.checkDetailList = checkDetailList;
    }

    @ReferSerialTransfer(referCode = "contractMaterial")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    @ReferSerialTransfer(referCode = "store-store")
    public Long getStoreId() {
        return storeId;
    }
    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    @ReferSerialTransfer(referCode = "proSubContract")
    public Long getSubContractId() {
        return subContractId;
    }
    @ReferDeserialTransfer
    public void setSubContractId(Long subContractId) {
        this.subContractId = subContractId;
    }
}
