package com.ejianc.business.tradematerial.contract.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.sql.Date;

/**
 * 主合同实体
 * 
 * @author generator
 * 
 */
@ApiModel("主合同实体")
public class ContractMaterialReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("合同Id")
    private Long contractId;
    @ApiModelProperty("合同编码")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("采购类型")
    private String contractPropertyName;
    @ApiModelProperty("供应商")
    private String supplierName;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织")
    private String orgName;
    @ApiModelProperty("签订日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;
    @ApiModelProperty("项目Id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("物料Id")
    private Long materialId;
    @ApiModelProperty("物资分类名称")
    private String materialTypeName;
    @ApiModelProperty("物资分类Id")
    private Long materialTypeId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("规则/型号")
    private String spec;
    @ApiModelProperty("计量单位主键")
    private Long unitId;
    @ApiModelProperty("计量单位")
    private String unitName;
    @ApiModelProperty("外加剂")
    private String detailAdmixtureName;
    @ApiModelProperty("合同单价(含税)")
    private BigDecimal ContractTaxPrice;
    @ApiModelProperty("合同税率")
    private BigDecimal ContractTaxRate;
    @ApiModelProperty("合同量")
    private BigDecimal contractNum;
    @ApiModelProperty("合同金额")
    private BigDecimal contractMny;
    @ApiModelProperty("合同金额含税")
    private BigDecimal contractTaxMny;
    @ApiModelProperty("订单量")
    private BigDecimal orderNum;
    @ApiModelProperty("验收量")
    private BigDecimal checkNum;
    @ApiModelProperty("验收金额")
    private BigDecimal checkMny;
    @ApiModelProperty("验收金额(含税)")
    private BigDecimal checkTaxMny;
    @ApiModelProperty("结算量")
    private BigDecimal settlementNum;
    @ApiModelProperty("结算单价")
    private BigDecimal settlementTaxPrice;
    @ApiModelProperty("结算税率")
    private BigDecimal settlementTaxRate;
    @ApiModelProperty("结算金额")
    private BigDecimal settlementMny;
    @ApiModelProperty("结算金额(含税)")
    private BigDecimal settlementTaxMny;
    @ApiModelProperty("是否补充协议(1:是，0：否)")
    private Integer supplementFlag;
    @ApiModelProperty("定标结果Id")
    private Long targetResultId;
    @ApiModelProperty("合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】")
    private String performanceStatus;
    @ApiModelProperty("备注")
    private String memo;
    @TableField(value="contract_type")
    private Integer contractType; // 合同类型（0-物资采购合同，1-混凝土合同）

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getDetailAdmixtureName() {
        return detailAdmixtureName;
    }

    public void setDetailAdmixtureName(String detailAdmixtureName) {
        this.detailAdmixtureName = detailAdmixtureName;
    }

    public BigDecimal getContractTaxPrice() {
        return ContractTaxPrice;
    }

    public void setContractTaxPrice(BigDecimal contractTaxPrice) {
        ContractTaxPrice = contractTaxPrice;
    }

    public BigDecimal getContractTaxRate() {
        return ContractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        ContractTaxRate = contractTaxRate;
    }

    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(BigDecimal orderNum) {
        this.orderNum = orderNum;
    }

    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }

    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }

    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }

    public BigDecimal getSettlementNum() {
        return settlementNum;
    }

    public void setSettlementNum(BigDecimal settlementNum) {
        this.settlementNum = settlementNum;
    }

    public BigDecimal getSettlementTaxPrice() {
        return settlementTaxPrice;
    }

    public void setSettlementTaxPrice(BigDecimal settlementTaxPrice) {
        this.settlementTaxPrice = settlementTaxPrice;
    }

    public BigDecimal getSettlementTaxRate() {
        return settlementTaxRate;
    }

    public void setSettlementTaxRate(BigDecimal settlementTaxRate) {
        this.settlementTaxRate = settlementTaxRate;
    }

    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }

    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
}
