package com.ejianc.business.tradematerial.finance.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum PaymentContractEnum {

    有合同(0, "有合同"),

    无合同(1, "无合同"),
    合同付款(2, "合同付款"),
    零星材料(3, "零星材料"),
    临时机械(4, "临时机械"),
    零星费用(5, "零星费用");

    private Integer code;
    private String name;
    private static Map<Integer,PaymentContractEnum> enumMap = new HashMap<>();

    PaymentContractEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        enumMap = EnumSet.allOf(PaymentContractEnum.class)
                .stream().collect(Collectors.toMap(PaymentContractEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static PaymentContractEnum getByCode(Integer code) {
        return enumMap.get(code);
    }
}
