package com.ejianc.business.tradematerial.plan.vo;

import com.ejianc.business.promaterial.plan.vo.MasterPlanDetailChangeHisVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 消耗材总计划变更记录
 * 
 * @author generator
 * 
 */
@ApiModel("消耗材总计划变更记录")
public class MasterPlanChangeHisVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("所属项目Id")
    private Long projectId;
    @ApiModelProperty("所属项目名称")
    private String projectName;
    @ApiModelProperty("所属项目编码")
    private String projectCode;
    @ApiModelProperty("计划编码")
    private String planCode;
    private String historyCode; // 计划编码
    @ApiModelProperty("现计划金额")
    private java.math.BigDecimal totalPlanAmt;
    @ApiModelProperty("备注")
    private String remark;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("变更人")
    private String changeUserName;
    @ApiModelProperty("变更原因")
    private String changeReason;
    @ApiModelProperty("原计划金额")
    private java.math.BigDecimal originalPlanAmt;
    @ApiModelProperty("源计划数据Id")
    private Long sourcePlanId;
    @ApiModelProperty("创建人名称")
    private String createUserName;
    @ApiModelProperty("修改人名称")
    private String modifyUserName;
    @ApiModelProperty("提交日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date commitDate;
    @ApiModelProperty("提交人名称")
    private String commitUserName;
    @ApiModelProperty("提交人账号")
    private String commitUserCode;
    @ApiModelProperty("生效日期")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;
    @ApiModelProperty("变更版本")
    private Integer changeVersion;
    @ApiModelProperty("变更金额")
    private java.math.BigDecimal changeAmount;
    @ApiModelProperty("本次变更比例")
    private Double changeRatio;
    @ApiModelProperty("变更计划Id")
    private Long changePlanId;
    @ApiModelProperty("计划类型")
    private Integer planType; // 计划类型（0-消耗材，1-混泥土）
    @ApiModelProperty("上级组织id")
    private Long parentOrgId; // 上级组织id
    @ApiModelProperty("上级组织名称")
    private String parentOrgName; // 上级组织名称
    @ApiModelProperty("上级组织编码")
    private String parentOrgCode; // 上级组织编码
    @ApiModelProperty("编制人id")
    private Long operatorId; // 编制人id
    @ApiModelProperty("编制人名称")
    private String operatorName; // 编制人名称
    @ApiModelProperty("消耗材总计划子表变更记录")
    private List<MasterPlanDetailChangeHisVO> masterPlanDetailList = new ArrayList<>();
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date planDate; // 计划日期
    private String orgCode; // 所属项目部编码

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }


    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    /**
     * 编制人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getOperatorId() {
        return operatorId;
    }
    @ReferDeserialTransfer
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    /**
     * 上级组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 上级组织id
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 上级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 上级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 计划类型
     */
    public Integer getPlanType() {
        return planType;
    }

    public void setPlanType(Integer planType) {
        this.planType = planType;
    }
    /**
     * 所属项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 计划编码
     */
    public String getPlanCode() {
        return planCode;
    }

    /**
     * 计划编码
     */
    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public String getHistoryCode() {
        return historyCode;
    }

    public void setHistoryCode(String historyCode) {
        this.historyCode = historyCode;
    }

    /**
     * 现计划金额
     */
    public java.math.BigDecimal getTotalPlanAmt() {
        return totalPlanAmt;
    }

    /**
     * 现计划金额
     */
    public void setTotalPlanAmt(java.math.BigDecimal totalPlanAmt) {
        this.totalPlanAmt = totalPlanAmt;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /**
     * 所属项目部Id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 变更人
     */
    public String getChangeUserName() {
        return changeUserName;
    }

    /**
     * 变更人
     */
    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }
    /**
     * 变更原因
     */
    public String getChangeReason() {
        return changeReason;
    }

    /**
     * 变更原因
     */
    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    /**
     * 原计划金额
     */
    public java.math.BigDecimal getOriginalPlanAmt() {
        return originalPlanAmt;
    }

    /**
     * 原计划金额
     */
    public void setOriginalPlanAmt(java.math.BigDecimal originalPlanAmt) {
        this.originalPlanAmt = originalPlanAmt;
    }
    /**
     * 源计划数据Id
     */
    public Long getSourcePlanId() {
        return sourcePlanId;
    }

    /**
     * 源计划数据Id
     */
    public void setSourcePlanId(Long sourcePlanId) {
        this.sourcePlanId = sourcePlanId;
    }
    /**
     * 创建人名称
     */
    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建人名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    /**
     * 修改人名称
     */
    public String getModifyUserName() {
        return modifyUserName;
    }

    /**
     * 修改人名称
     */
    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }
    /**
     * 提交日期
     */
    public Date getCommitDate() {
        return commitDate;
    }

    /**
     * 提交日期
     */
    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    /**
     * 提交人名称
     */
    public String getCommitUserName() {
        return commitUserName;
    }

    /**
     * 提交人名称
     */
    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    /**
     * 提交人账号
     */
    public String getCommitUserCode() {
        return commitUserCode;
    }

    /**
     * 提交人账号
     */
    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    /**
     * 生效日期
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效日期
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    /**
     * 变更版本
     */
    public Integer getChangeVersion() {
        return changeVersion;
    }

    /**
     * 变更版本
     */
    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    /**
     * 变更金额
     */
    public java.math.BigDecimal getChangeAmount() {
        return changeAmount;
    }

    /**
     * 变更金额
     */
    public void setChangeAmount(java.math.BigDecimal changeAmount) {
        this.changeAmount = changeAmount;
    }
    /**
     * 本次变更比例
     */
    public Double getChangeRatio() {
        return changeRatio;
    }

    /**
     * 本次变更比例
     */
    public void setChangeRatio(Double changeRatio) {
        this.changeRatio = changeRatio;
    }
    /**
     * 变更计划Id
     */
    public Long getChangePlanId() {
        return changePlanId;
    }

    /**
     * 变更计划Id
     */
    public void setChangePlanId(Long changePlanId) {
        this.changePlanId = changePlanId;
    }

    public List<MasterPlanDetailChangeHisVO> getMasterPlanDetailList() {
        return masterPlanDetailList;
    }

    public void setMasterPlanDetailList(List<MasterPlanDetailChangeHisVO> masterPlanDetailList) {
        this.masterPlanDetailList = masterPlanDetailList;
    }
}
