package com.ejianc.business.tradematerial.plan.vo;

import com.ejianc.business.promaterial.plan.vo.MonthPlanDetailVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资月计划
 * 
 * @author jiangyikai
 * 
 */
public class MonthPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("单据状态")
    private Integer billState; // 单据状态
    @ApiModelProperty("单据编码")
    private String billCode; // 单据编码
    @ApiModelProperty("所属项目部Id")
    private Long orgId; // 所属项目部Id
    @ApiModelProperty("所属项目部名称")
    private String orgName; // 所属项目部名称
    @ApiModelProperty("组织ID")
    private Long parentOrgId; // 组织ID
    @ApiModelProperty("组织编码")
    private String parentOrgCode; // 组织编码
    @ApiModelProperty("组织名称")
    private String parentOrgName; // 组织名称
    @ApiModelProperty("所属项目Id")
    private Long projectId; // 所属项目Id
    @ApiModelProperty("所属项目名称")
    private String projectName; // 所属项目名称
    @ApiModelProperty("所属项目编码")
    private String projectCode; // 所属项目编码
    @ApiModelProperty("计划月份")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planMonth; // 计划月份
    @ApiModelProperty("编制人id")
    private Long operatorId; // 编制人id
    @ApiModelProperty("编制人")
    private String operatorName; // 编制人

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date  billDate; // 编制日期
    @ApiModelProperty("备注")
    private String remark; // 备注
    private String billStateName;
    @ApiModelProperty("计划类型")
    private Integer planType; // 计划类型（0-消耗材，1-混泥土）
    @ApiModelProperty("参照树名称(月份+编码)")
    private String name;
    private List<MonthPlanDetailVO> monthPlanDetailEntities = new ArrayList<>(); // 物资月计划子表
    private String orgCode; // 所属项目部编码

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    /**
     * 参照树名称
     */
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /**
     * 计划类型
     */
    public Integer getPlanType() {
        return planType;
    }

    public void setPlanType(Integer planType) {
        this.planType = planType;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 所属项目部Id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织ID
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 组织ID
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 所属项目Id
     */
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 所属项目Id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 所属项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 所属项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 所属项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 计划月份
     */
    public Date getPlanMonth() {
        return planMonth;
    }

    /**
     * 计划月份
     */
    public void setPlanMonth(Date planMonth) {
        this.planMonth = planMonth;
    }
    /**
     * 编制人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getOperatorId() {
        return operatorId;
    }

    /**
     * 编制人id
     */
    @ReferDeserialTransfer
    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    /**
     * 编制人
     */
    public String getOperatorName() {
        return operatorName;
    }

    /**
     * 编制人
     */
    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }
    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 编制日期
     */
    public Date getBillDate() {
        return billDate;
    }
    /**
     * 编制日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
      * 物资月计划子表
      */
    public List<MonthPlanDetailVO> getMonthPlanDetailEntities() {
        return monthPlanDetailEntities;
    }

    /**
      * 物资月计划子表
      */
    public void setMonthPlanDetailEntities(List<MonthPlanDetailVO> monthPlanDetailEntities) {
        this.monthPlanDetailEntities = monthPlanDetailEntities;
    }
}
