package com.ejianc.business.tradematerial.settlement.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;


/**
 * 结算单其他费用表
 * 
 * @author generator
 * 
 */
@ApiModel("结算单其他费用表")
public class SettlementFeeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("结算主键")
    private Long settlementId;
    @ApiModelProperty("费用名称")
    private String feeName;
    @ApiModelProperty("数量")
    private BigDecimal feeNum;
    @ApiModelProperty("单价（无税）")
    private BigDecimal feePrice;
    @ApiModelProperty("金额（无税）")
    private BigDecimal feeMny;
    @ApiModelProperty("备注")
    private String feeMemo;
    @ApiModelProperty("税率")
    private BigDecimal feeTaxRate;
    @ApiModelProperty("税额")
    private BigDecimal feeTax;
    @ApiModelProperty("金额")
    private BigDecimal feeTaxMny;
    @ApiModelProperty("单价")
    private BigDecimal feeTaxPrice;
    @ApiModelProperty("来源主键ID")
    private Long sourceId;
    @ApiModelProperty("来源明细主键ID")
    private Long sourceDetailId;
    @ApiModelProperty("合同数量")
    private BigDecimal contractNum;
    private Long wbsIdFee; // 核算对象主键
    private String wbsCodeFee; // 核算对象编码
    private String wbsNameFee; // 核算对象名称
    private Long subjectIdFee; // 成本科目主键
    private String subjectCodeFee; // 成本科目编码
    private String subjectNameFee; // 成本科目名称

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getWbsIdFee() {
        return wbsIdFee;
    }
    @ReferDeserialTransfer
    public void setWbsIdFee(Long wbsIdFee) {
        this.wbsIdFee = wbsIdFee;
    }

    public String getWbsCodeFee() {
        return wbsCodeFee;
    }

    public void setWbsCodeFee(String wbsCodeFee) {
        this.wbsCodeFee = wbsCodeFee;
    }

    public String getWbsNameFee() {
        return wbsNameFee;
    }

    public void setWbsNameFee(String wbsNameFee) {
        this.wbsNameFee = wbsNameFee;
    }
    @ReferSerialTransfer(referCode = "subject-project-org-ref")
    public Long getSubjectIdFee() {
        return subjectIdFee;
    }
    @ReferDeserialTransfer
    public void setSubjectIdFee(Long subjectIdFee) {
        this.subjectIdFee = subjectIdFee;
    }

    public String getSubjectCodeFee() {
        return subjectCodeFee;
    }

    public void setSubjectCodeFee(String subjectCodeFee) {
        this.subjectCodeFee = subjectCodeFee;
    }

    public String getSubjectNameFee() {
        return subjectNameFee;
    }

    public void setSubjectNameFee(String subjectNameFee) {
        this.subjectNameFee = subjectNameFee;
    }

    /**
     * 合同数量
     */
    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }

    /**
     * 结算主键
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * 结算主键
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    /**
     * 费用名称
     */
    public String getFeeName() {
        return feeName;
    }

    /**
     * 费用名称
     */
    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    public BigDecimal getFeeNum() {
        return feeNum;
    }

    public void setFeeNum(BigDecimal feeNum) {
        this.feeNum = feeNum;
    }

    public BigDecimal getFeeMny() {
        return feeMny;
    }

    public void setFeeMny(BigDecimal feeMny) {
        this.feeMny = feeMny;
    }

    /**
     * 数量
     */


    public BigDecimal getFeePrice() {
        return feePrice;
    }

    public void setFeePrice(BigDecimal feePrice) {
        this.feePrice = feePrice;
    }


    public String getFeeMemo() {
        return feeMemo;
    }

    public void setFeeMemo(String feeMemo) {
        this.feeMemo = feeMemo;
    }

    public BigDecimal getFeeTaxRate() {
        return feeTaxRate;
    }

    public void setFeeTaxRate(BigDecimal feeTaxRate) {
        this.feeTaxRate = feeTaxRate;
    }

    public BigDecimal getFeeTax() {
        return feeTax;
    }

    public void setFeeTax(BigDecimal feeTax) {
        this.feeTax = feeTax;
    }

    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }

    public BigDecimal getFeeTaxPrice() {
        return feeTaxPrice;
    }

    public void setFeeTaxPrice(BigDecimal feeTaxPrice) {
        this.feeTaxPrice = feeTaxPrice;
    }

    /**
     * 来源主键ID
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源主键ID
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源明细主键ID
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源明细主键ID
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    
}
