/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.tradematerial.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tradematerial.contract.bean.ContractAdmixtureEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractChangeAdmixtureEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractChangeEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractClauseEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractDetailEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractFeeEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractRecordEntity;
import com.ejianc.business.tradematerial.contract.bean.ContractStageEntity;
import com.ejianc.business.tradematerial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.tradematerial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.tradematerial.contract.enums.DraftTypeEnum;
import com.ejianc.business.tradematerial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.tradematerial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.tradematerial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.tradematerial.contract.mapper.ContractChangeMapper;
import com.ejianc.business.tradematerial.contract.mapper.ContractMapper;
import com.ejianc.business.tradematerial.contract.service.IContractAdmixtureService;
import com.ejianc.business.tradematerial.contract.service.IContractChangeAsyncService;
import com.ejianc.business.tradematerial.contract.service.IContractChangeService;
import com.ejianc.business.tradematerial.contract.service.IContractClauseService;
import com.ejianc.business.tradematerial.contract.service.IContractDetailService;
import com.ejianc.business.tradematerial.contract.service.IContractFeeService;
import com.ejianc.business.tradematerial.contract.service.IContractRecordService;
import com.ejianc.business.tradematerial.contract.service.IContractService;
import com.ejianc.business.tradematerial.contract.service.IContractStageService;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeAdmixtureVO;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeClauseVO;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeCompareVO;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeDetailVO;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeFeeVO;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeStageVO;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeVO;
import com.ejianc.business.tradematerial.contract.vo.ContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="contractChangeService")
public class ContractChangeServiceImpl
extends BaseServiceImpl<ContractChangeMapper, ContractChangeEntity>
implements IContractChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CONTRACT_CHANGE = "CONTRACT_CHANGE";
    private static final String CONTRACT_CONCRETE_CHANGE = "CONTRACT_CONCRETE_CHANGE";
    private final String CONTRACT_FILE_SOURCE_TYPE = "mContractFile";
    private final String CONTRACT_ATTACH_SOURCE_TYPE = "proMaterialContractBill";
    private static final String CONTRACT_MATERIAL = "BT211227000000003";
    private static final String CONTRACT_MATERIAL_RECORD = "BT220105000000028";
    private static final String CONTRACT_CONCRETE = "BT220215000000001";
    private static final String CONTRACT_CONCRETE_RECORD = "BT220215000000003";
    private static final String CHECK_PARAM_CODE = "P-434f5499";
    private static final Integer CONTRACT_TYPE_0 = 0;
    private static final Integer CONTRACT_TYPE_1 = 1;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private ContractMapper ContractMapper;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IContractClauseService contractClauseService;
    @Autowired
    private IContractFeeService contractFeeService;
    @Autowired
    private IContractStageService contractStageService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractAdmixtureService contractAdmixtureService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IContractRecordService contractRecordService;
    @Autowired
    private IExecutionApi executionApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IContractChangeAsyncService contractChangeAsyncService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String M_PARAM_CODE = "P-bGD9cO62";
    private static final String C_PARAM_CODE = "P-715t0u63";
    private static final String M_PLAN_CODE = "P-CcZ6rO87";
    private static final String C_PLAN_CODE = "P-00g5A089";

    @Override
    public ContractChangeVO insertOrUpdate(ContractChangeVO contractChangeVO, Boolean isControl) {
        ContractChangeVO res;
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        ContractEntity contract = (ContractEntity)((Object)this.contractService.selectById(contractChangeVO.getContractId()));
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getAttachIds()) && null != contract.getContractFileId()) {
            contractChangeVO.getAttachIds().remove(contract.getContractFileId());
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractChangeEntity entity = null;
        List entitiesc = null;
        List entities = null;
        this.contractService.checkContract(contractChangeVO.getContractId(), contractChangeVO.getId());
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(ContractChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)contractChangeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        LambdaQueryWrapper lambdaQuery2 = Wrappers.lambdaQuery();
        lambdaQuery2.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery2.eq(ContractEntity::getMainContractId, (Object)contractChangeVO.getContractId());
        lambdaQuery2.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int nums = this.contractService.count((Wrapper)lambdaQuery2);
        if (nums > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        ContractEntity pcentity = (ContractEntity)((Object)this.contractService.selectById(contractChangeVO.getContractId()));
        if (!isControl.booleanValue() && (StringUtils.isBlank((CharSequence)contractChangeVO.getBillCode()) || contract.getBillCode().equals(contractChangeVO.getBillCode()))) {
            QueryParam billCodeParam = new QueryParam();
            billCodeParam.getParams().put("contract_id", new Parameter("eq", (Object)contractChangeVO.getContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            billCodeParam.getParams().put("bill_state", new Parameter("in", billStateList));
            List billCodeChangeEntityList = super.queryList(billCodeParam, false);
            String changeNum = "";
            changeNum = billCodeChangeEntityList.size() < 9 ? changeNum + "0" + (billCodeChangeEntityList.size() + 1) : changeNum + (billCodeChangeEntityList.size() + 1);
            String type = "-1-";
            contractChangeVO.setBillCode(contract.getBillCode() + type + changeNum);
        }
        if (contractChangeVO.getId() != null && contractChangeVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractChangeEntity::getBillCode, (Object)contractChangeVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(ContractChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getContractId()));
            entitiesc = this.contractService.queryList(queryParam, false);
            pcentity.setId(contractChangeVO.getContractId());
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractChangeEntity::getBillCode, (Object)contractChangeVO.getBillCode());
            lambda.ne(ContractChangeEntity::getContractId, (Object)contractChangeVO.getContractId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractChangeVO.getBillCode()));
            queryParam.getParams().put("id", new Parameter("ne", (Object)contractChangeVO.getContractId()));
            entitiesc = this.contractService.queryList(queryParam, false);
            pcentity.setId(contractChangeVO.getContractId());
            pcentity.setChangeVersion(contractChangeVO.getChangeVersion() + 1);
            contractChangeVO.setChangeVersion(Integer.valueOf(contractChangeVO.getChangeVersion() + 1));
            if (isControl.booleanValue()) {
                contractChangeVO.setId(Long.valueOf(IdWorker.getId()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractDetailList())) {
            contractChangeVO.getContractDetailList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractFeeList())) {
            contractChangeVO.getContractFeeList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractClauseList())) {
            contractChangeVO.getContractClauseList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractStageList())) {
            contractChangeVO.getContractStageList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)contractChangeVO.getContractAdmixtureList())) {
            contractChangeVO.getContractAdmixtureList().forEach(vo -> {
                if ("add".equals(vo.getRowState())) {
                    vo.setContractId(contractChangeVO.getContractId());
                }
                if (this.isInsertContractChange(contractChangeVO)) {
                    vo.setId(null);
                }
            });
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (ContractChangeEntity)((Object)BeanMapper.map((Object)contractChangeVO, ContractChangeEntity.class));
        if (entity.getFilingRef() == null) {
            entity.setFilingRef(0);
        }
        pcentity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        pcentity.setChangingMny(entity.getContractMny());
        pcentity.setChangingMnyWithTax(entity.getContractTaxMny());
        pcentity.setChangeDate(entity.getChangeDate());
        pcentity.setChangeCode(entity.getBillCode());
        pcentity.setChangeId(entity.getId());
        pcentity.setChangeContractSignatureStatus(Integer.valueOf(entity.getSignatureStatus()));
        pcentity.setChangeFileId(entity.getChangeFileId());
        pcentity.setChangeContractName(entity.getContractName());
        if (!isControl.booleanValue()) {
            this.contractService.update((Object)pcentity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)pcentity.getId()), false);
        }
        BigDecimal contractTaxMny = (res = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class)).getContractTaxMny() == null ? BigDecimal.ZERO : res.getContractTaxMny();
        BigDecimal beforeChangeTaxMny = pcentity.getBeforeChangeMnyWithTax() == null ? BigDecimal.ZERO : pcentity.getBeforeChangeMnyWithTax();
        BigDecimal bb = contractTaxMny.subtract(beforeChangeTaxMny);
        return res;
    }

    private boolean isInsertContractChange(ContractChangeVO contractChangeVO) {
        return contractChangeVO.getId() == null || contractChangeVO.getId() == 0L;
    }

    @Override
    public ContractChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ContractChangeVO changeVO = new ContractChangeVO();
        BigDecimal baseTaxMoney = contractEntity.getBaseMoneyWithTax() == null ? BigDecimal.ZERO : contractEntity.getBaseMoneyWithTax();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        changeVO.setId(id);
        changeVO.setContractId(id);
        changeVO.setBaseMoneyWithTax(baseTaxMoney);
        changeVO.setContractTaxMny(contractTaxMny);
        changeVO.setAllChangeAmt(contractTaxMny.subtract(baseTaxMoney));
        changeVO.setOrgId(contractEntity.getParentOrgId());
        if (changeVO.getAllChangeAmt().compareTo(BigDecimal.ZERO) != 0 && baseTaxMoney.compareTo(BigDecimal.ZERO) != 0) {
            changeVO.setChangeAmtRate(new BigDecimal(100).multiply(changeVO.getAllChangeAmt().divide(baseTaxMoney, 8, 5)));
        } else {
            changeVO.setChangeAmtRate(BigDecimal.ZERO);
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractChangeEntity::getContractId, (Object)id);
        lambda.eq(ContractChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        lambda.in(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = super.list((Wrapper)lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)entities)) {
            changeVO.setChangeList(BeanMapper.mapList((Iterable)entities, ContractChangeVO.class));
            changeVO.setChangeNum(Integer.valueOf(entities.size()));
        } else {
            changeVO.setChangeNum(Integer.valueOf(0));
        }
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    @Override
    public ContractChangeVO queryChangeRecord(Long contractId, Long changeId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)changeId));
        queryParam.getOrderMap().put("createTime", "desc");
        List recordList = this.contractRecordService.queryList(queryParam);
        ContractChangeVO changeVO = new ContractChangeVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            changeVO = (ContractChangeVO)BeanMapper.map(recordList.get(0), ContractChangeVO.class);
        }
        return changeVO;
    }

    @Override
    public ContractChangeVO addConvertByConId(Long contractId, Long changeId) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        ContractChangeVO purchaseChangeVo = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class);
        purchaseChangeVo.setContractId(purchaseChangeVo.getId());
        purchaseChangeVo.setId(null);
        purchaseChangeVo.setBillState(null);
        purchaseChangeVo.setCreateUserCode(null);
        purchaseChangeVo.setCreateTime(null);
        purchaseChangeVo.setUpdateUserCode(null);
        purchaseChangeVo.setUpdateTime(null);
        purchaseChangeVo.setChangeDate(new Date());
        purchaseChangeVo.setBeforeContractName(entity.getContractName());
        purchaseChangeVo.setBeforeChangeMny(entity.getContractMny());
        purchaseChangeVo.setBeforeChangeMnyWithTax(entity.getContractTaxMny());
        purchaseChangeVo.setBeforeContractName(purchaseChangeVo.getContractName());
        purchaseChangeVo.setBeforeChangeTax(entity.getContractTax());
        purchaseChangeVo.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().toString());
        purchaseChangeVo.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().toString());
        purchaseChangeVo.setChangeDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        purchaseChangeVo.setChangeFileId(null);
        purchaseChangeVo.setChangeFilePath(null);
        purchaseChangeVo.setWatermarkContractFileId(null);
        purchaseChangeVo.setContractType(entity.getContractType());
        purchaseChangeVo.setChangeFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, (Object)contractId);
        lambda.ne(ContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u4e2d\u6b62\u9879);
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            purchaseChangeVo.setContractDetailList(BeanMapper.mapList((Iterable)details, ContractChangeDetailVO.class));
            purchaseChangeVo.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setChangeType("0");
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        } else {
            purchaseChangeVo.setContractDetailList(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractFeeList())) {
            purchaseChangeVo.getContractFeeList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractClauseList())) {
            purchaseChangeVo.getContractClauseList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractStageList())) {
            purchaseChangeVo.getContractStageList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)purchaseChangeVo.getContractAdmixtureList())) {
            purchaseChangeVo.getContractAdmixtureList().forEach(vo -> {
                vo.setContractId(purchaseChangeVo.getContractId());
                vo.setRowState("add");
                vo.setSrcTblId(vo.getId());
            });
        }
        return purchaseChangeVo;
    }

    public Boolean editChangeFlag(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getPerformanceStatus())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())).or(c -> (LambdaQueryWrapper)c.notIn(ContractChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<String, String>();
        orderByParams.put("treeIndex", "asc");
        HashMap<String, LinkedHashMap<String, String>> orders = new HashMap<String, LinkedHashMap<String, String>>();
        orders.put("detailList", orderByParams);
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)super.selectById((Serializable)id, orders));
        ContractChangeCompareVO changeCompareVO = (ContractChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), ContractChangeCompareVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ContractChangeCompareVO beforeChangeVO = new ContractChangeCompareVO();
        Map<Object, Object> beforeDetailMap = new HashMap();
        Map<Object, Object> beforeFeeMap = new HashMap();
        Map<Object, Object> beforeClauseMap = new HashMap();
        Map<Object, Object> beforeStageMap = new HashMap();
        Map<Object, Object> beforAdminxtureMap = new HashMap();
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(changeEntity.getSignatureStatus())) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambda.eq(ContractRecordEntity::getChangeId, (Object)id)).eq(ContractRecordEntity::getContractId, (Object)changeEntity.getContractId())).orderByDesc(BaseEntity::getCreateTime);
            List recordList = this.contractRecordService.list((Wrapper)lambda);
            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null) {
                Long recordId = ((ContractRecordEntity)((Object)recordList.get(0))).getId();
                ContractRecordEntity recordEntity = (ContractRecordEntity)((Object)this.contractRecordService.selectById(recordId));
                beforeChangeVO = (ContractChangeCompareVO)BeanMapper.map((Object)((Object)recordEntity), ContractChangeCompareVO.class);
                beforeDetailMap = beforeChangeVO.getContractDetailList().stream().collect(Collectors.toMap(ContractChangeDetailVO::getSrcTblId, detail -> detail, (v1, v2) -> v2));
                beforeFeeMap = beforeChangeVO.getContractFeeList().stream().collect(Collectors.toMap(ContractChangeFeeVO::getSrcTblId, fee -> fee, (v1, v2) -> v2));
                beforeClauseMap = beforeChangeVO.getContractClauseList().stream().collect(Collectors.toMap(ContractChangeClauseVO::getSrcTblId, clause -> clause, (v1, v2) -> v2));
                beforeStageMap = beforeChangeVO.getContractStageList().stream().collect(Collectors.toMap(ContractChangeStageVO::getSrcTblId, item -> item, (v1, v2) -> v2));
                if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(((ContractRecordEntity)((Object)recordList.get(0))).getContractType()) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)beforeChangeVO.getContractAdmixtureList())) {
                    beforAdminxtureMap = beforeChangeVO.getContractAdmixtureList().stream().collect(Collectors.toMap(ContractChangeAdmixtureVO::getSrcTblId, item -> item, (v1, v2) -> v2));
                }
            }
        } else {
            beforeChangeVO = (ContractChangeCompareVO)BeanMapper.map((Object)((Object)contractEntity), ContractChangeCompareVO.class);
            beforeDetailMap = beforeChangeVO.getContractDetailList().stream().collect(Collectors.toMap(BaseVO::getId, detail -> detail, (v1, v2) -> v2));
            beforeFeeMap = beforeChangeVO.getContractFeeList().stream().collect(Collectors.toMap(BaseVO::getId, fee -> fee, (v1, v2) -> v2));
            beforeClauseMap = beforeChangeVO.getContractClauseList().stream().collect(Collectors.toMap(BaseVO::getId, clause -> clause, (v1, v2) -> v2));
            beforeStageMap = beforeChangeVO.getContractStageList().stream().collect(Collectors.toMap(BaseVO::getId, item -> item, (v1, v2) -> v2));
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            ArrayList newDetail = new ArrayList();
            Map<Object, Object> finalBeforeDetailMap = beforeDetailMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractDetailList())) {
                changeCompareVO.getContractDetailList().stream().forEach(detail -> {
                    if (!detail.getChangeType().equals(String.valueOf(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode()))) {
                        if (detail.getSrcTblId() == null) {
                            newDetail.add(detail);
                        }
                        if (finalBeforeDetailMap.containsKey(detail.getSrcTblId())) {
                            detail.setBeforeChangeRate(((ContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getDetailTaxRate());
                            detail.setBeforeChangePrice(((ContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getPrice());
                            detail.setBeforeChangeNum(((ContractChangeDetailVO)finalBeforeDetailMap.get(detail.getSrcTblId())).getNum());
                            newDetail.add(detail);
                            finalBeforeDetailMap.remove(detail.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setContractDetailList(newDetail);
            ArrayList newFee = new ArrayList();
            Map<Object, Object> finalBeforeFeeMap = beforeFeeMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractFeeList())) {
                changeCompareVO.getContractFeeList().stream().forEach(fee -> {
                    if (!String.valueOf(ChangeTypeEnum.\u672a\u53d8\u66f4.getCode()).equals(fee.getChangeType())) {
                        if (fee.getSrcTblId() == null) {
                            newFee.add(fee);
                        }
                        if (finalBeforeFeeMap.containsKey(fee.getSrcTblId())) {
                            fee.setBeforeChangeCostRate(((ContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreeTaxRate());
                            fee.setBeforeChangeCostPrice(((ContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreePrice());
                            fee.setBeforeChangeCostNum(((ContractChangeFeeVO)finalBeforeFeeMap.get(fee.getSrcTblId())).getFreeNum());
                            newFee.add(fee);
                            finalBeforeFeeMap.remove(fee.getSrcTblId());
                        }
                    }
                });
            }
            changeCompareVO.setContractFeeList(newFee);
            ArrayList newClauses = new ArrayList();
            Map<Object, Object> finalBeforeClauseMap = beforeClauseMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractClauseList())) {
                changeCompareVO.getContractClauseList().stream().forEach(clause -> {
                    if (clause.getSrcTblId() == null) {
                        clause.setChangeType("\u589e\u8865\u9879");
                        newClauses.add(clause);
                    } else if (finalBeforeClauseMap.containsKey(clause.getSrcTblId())) {
                        if (!((ContractChangeClauseVO)finalBeforeClauseMap.get(clause.getSrcTblId())).getClauseContent().equals(clause.getClauseContent())) {
                            clause.setBeforeChangeClauseContent(((ContractChangeClauseVO)finalBeforeClauseMap.get(clause.getSrcTblId())).getClauseContent());
                            clause.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                            newClauses.add(clause);
                        }
                        finalBeforeClauseMap.remove(clause.getSrcTblId());
                    }
                });
            }
            if (MapUtils.isNotEmpty(finalBeforeClauseMap)) {
                finalBeforeClauseMap.values().forEach(c -> {
                    c.setChangeType("\u5220\u9664\u9879");
                    newClauses.add(c);
                });
            }
            changeCompareVO.setContractClauseList(newClauses);
            ArrayList<ContractChangeStageVO> newStageList = new ArrayList<ContractChangeStageVO>();
            Map<Object, Object> finalBeforeStageMap = beforeStageMap;
            if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractStageList())) {
                ContractChangeStageVO beforeItem = null;
                for (ContractChangeStageVO curItem : changeCompareVO.getContractStageList()) {
                    if (curItem.getSrcTblId() == null) {
                        curItem.setChangeType("\u589e\u8865\u9879");
                        newStageList.add(curItem);
                        continue;
                    }
                    if (!finalBeforeStageMap.containsKey(curItem.getSrcTblId())) continue;
                    beforeItem = (ContractChangeStageVO)finalBeforeStageMap.get(curItem.getSrcTblId());
                    if (!beforeItem.getStageName().equals(curItem.getStageName()) || !beforeItem.getStageScale().equals(curItem.getStageScale())) {
                        curItem.setBeforePaymentName(beforeItem.getStageName());
                        curItem.setBeforePaymentScale(beforeItem.getStageScale());
                        curItem.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                        newStageList.add(curItem);
                    }
                    finalBeforeStageMap.remove(curItem.getSrcTblId());
                }
            }
            if (MapUtils.isNotEmpty(finalBeforeStageMap)) {
                finalBeforeStageMap.values().forEach(c -> {
                    c.setChangeType("\u5220\u9664\u9879");
                    newStageList.add((ContractChangeStageVO)c);
                });
            }
            changeCompareVO.setContractStageList(newStageList);
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(changeEntity.getContractType())) {
                ArrayList newAdminxtureList = new ArrayList();
                HashMap finalbeforAdminxtureMap = beforAdminxtureMap;
                if (CollectionUtils.isNotEmpty((Collection)changeCompareVO.getContractAdmixtureList())) {
                    changeCompareVO.getContractAdmixtureList().forEach(adminxture -> {
                        if (adminxture.getSrcTblId() == null) {
                            adminxture.setChangeType("\u589e\u8865\u9879");
                            newAdminxtureList.add(adminxture);
                        } else if (finalbeforAdminxtureMap.containsKey(adminxture.getSrcTblId())) {
                            ContractChangeAdmixtureVO beforeAdmixture = (ContractChangeAdmixtureVO)finalbeforAdminxtureMap.get(adminxture.getSrcTblId());
                            if (beforeAdmixture.getPrice().compareTo(adminxture.getPrice()) != 0) {
                                adminxture.setBeforPrice(beforeAdmixture.getPrice());
                                adminxture.setChangeType("\u5185\u5bb9\u53d8\u66f4");
                            }
                            finalbeforAdminxtureMap.remove(adminxture.getSrcTblId());
                        }
                    });
                }
                if (MapUtils.isNotEmpty(finalbeforAdminxtureMap)) {
                    finalbeforAdminxtureMap.values().forEach(c -> {
                        c.setChangeType("\u5220\u9664\u9879");
                        newAdminxtureList.add(c);
                    });
                }
                changeCompareVO.setContractAdmixtureList(newAdminxtureList);
            }
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)super.selectById((Serializable)billId));
        if (changeEntity != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                this.effectiveSaveWriteContract(billId, changeEntity.getBillCode(), false, true);
                return true;
            }
            changeEntity.setSignatureStatus(String.valueOf(status));
            super.saveOrUpdate((Object)changeEntity);
            this.logger.info("\u53d8\u66f4\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539---------------->");
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
            updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
            this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
            this.logger.info("\u7b7e\u7ae0\u72b6\u6001\u4e3a\u5df2\u7b7e\u7ae0\uff0c\u56de\u5199\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001---------------->");
            return true;
        }
        return false;
    }

    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long billId, String billTypeCode, Boolean commitState, Boolean filingFlag) {
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)super.selectById((Serializable)billId));
        CommonResponse resp = null;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ContractRecordEntity recordEntity = (ContractRecordEntity)((Object)BeanMapper.map((Object)((Object)contractEntity), ContractRecordEntity.class));
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--- changeEntity:" + (Object)((Object)changeEntity) + "  contractEntity:" + (Object)((Object)contractEntity));
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setId(null);
        if (CollectionUtils.isNotEmpty(recordEntity.getContractDetailList())) {
            recordEntity.getContractDetailList().forEach(vo -> {
                vo.setContractDetailId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractFeeList())) {
            recordEntity.getContractFeeList().forEach(vo -> {
                vo.setContractFeeId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractClauseList())) {
            recordEntity.getContractClauseList().forEach(vo -> {
                vo.setContractClauseId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractStageList())) {
            recordEntity.getContractStageList().forEach(vo -> {
                vo.setContractStageId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getContractAdmixtureList())) {
            recordEntity.getContractAdmixtureList().forEach(vo -> {
                vo.setChangeId(vo.getId());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        this.contractRecordService.saveOrUpdate((Object)recordEntity, false);
        String contractBillType = CONTRACT_MATERIAL;
        String contractRecordBillType = CONTRACT_MATERIAL_RECORD;
        if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractEntity.getContractType())) {
            contractBillType = CONTRACT_CONCRETE;
            contractRecordBillType = CONTRACT_CONCRETE_RECORD;
        }
        if ((resp = this.copyFile(contractEntity.getId().toString(), contractBillType, recordEntity.getId().toString(), contractRecordBillType, "proMaterialContractBill")) != null) {
            return resp;
        }
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setDetailTaxMny(changeEntity.getDetailTaxMny());
        contractEntity.setDetailMny(changeEntity.getDetailMny());
        contractEntity.setDetailTax(changeEntity.getDetailTax());
        contractEntity.setFreeTaxMny(changeEntity.getFreeTaxMny());
        contractEntity.setFreeMny(changeEntity.getFreeMny());
        contractEntity.setFreeTax(changeEntity.getFreeTax());
        contractEntity.setMemo(changeEntity.getMemo());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setCustomerId(changeEntity.getCustomerId());
        contractEntity.setCustomerName(changeEntity.getCustomerName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setPayScale(changeEntity.getPayScale());
        contractEntity.setEmployeeId(changeEntity.getEmployeeId());
        contractEntity.setEmployeeName(changeEntity.getEmployeeName());
        contractEntity.setPricingType(changeEntity.getPricingType());
        contractEntity.setSupplierEmployeeName(changeEntity.getSupplierEmployeeName());
        contractEntity.setSupplierEmployeeMobile(changeEntity.getSupplierEmployeeMobile());
        contractEntity.setProjectPlace(changeEntity.getProjectPlace());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setChangeStatus(ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(null);
        contractEntity.setChangingMnyWithTax(null);
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());
        contractEntity.setSettlementPayment(changeEntity.getSettlementPayment());
        contractEntity.setPriceFloatType(changeEntity.getPriceFloatType());
        this.logger.info("1212-\u8fdb\u5165\u53d8\u66f4\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03------>\u5408\u540c\u63d0\u4ea4\uff0c\u7ebf\u4e0b\u7b7e\u8ba2\u76f4\u63a5\u4fee\u6539\u7b7e\u7ae0\u72b6\u6001");
        changeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        changeEntity.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        changeEntity.setEffectiveDate(new Date());
        if (filingFlag.booleanValue()) {
            changeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            changeEntity.setFilingRef(0);
        }
        this.copyFile(billId.toString(), billTypeCode, contractEntity.getId().toString(), contractBillType, "materialChangeContractFile");
        if (resp != null) {
            return resp;
        }
        changeEntity.setChangeDate(new Date());
        this.contractChangeService.saveOrUpdate((Object)changeEntity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540c\u610f\u540e\u56de\u5199--2");
        this.contractClauseService.deleteByContractId(changeEntity.getContractId());
        this.contractFeeService.deleteByContractId(changeEntity.getContractId());
        this.contractStageService.deleteByContractId(changeEntity.getContractId());
        contractEntity.setContractClauseList(null);
        contractEntity.setContractFeeList(null);
        contractEntity.setContractStageList(null);
        if (CollectionUtils.isNotEmpty(changeEntity.getContractDetailList())) {
            this.logger.info("\u590d\u5236\u5b50\u8868\u5f00\u59cb--" + changeEntity.getContractDetailList());
            changeEntity.getContractDetailList().forEach(vo -> {
                this.logger.info("\u590d\u5236\u5b50\u8868--" + vo.getContractDetailId() + "---type" + vo.getChangeType());
                if (null != vo.getContractDetailId()) {
                    Map<Long, Integer> map = contractEntity.getContractDetailList().stream().collect(Collectors.toMap(BaseEntity::getId, BaseEntity::getVersion));
                    vo.setId(vo.getContractDetailId());
                    vo.setVersion(map.get(vo.getContractDetailId()));
                }
            });
            contractEntity.setContractDetailList(BeanMapper.mapList(changeEntity.getContractDetailList(), ContractDetailEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractFeeList())) {
            changeEntity.getContractFeeList().forEach(vo -> vo.setId(null));
            contractEntity.setContractFeeList(BeanMapper.mapList(changeEntity.getContractFeeList(), ContractFeeEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractClauseList())) {
            changeEntity.getContractClauseList().forEach(vo -> vo.setId(null));
            contractEntity.setContractClauseList(BeanMapper.mapList(changeEntity.getContractClauseList(), ContractClauseEntity.class));
        }
        if (CollectionUtils.isNotEmpty(changeEntity.getContractStageList())) {
            changeEntity.getContractStageList().forEach(vo -> vo.setId(null));
            contractEntity.setContractStageList(BeanMapper.mapList(changeEntity.getContractStageList(), ContractStageEntity.class));
        }
        if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractEntity.getContractType())) {
            this.contractAdmixtureService.deleteByContractId(changeEntity.getContractId());
            contractEntity.setContractAdmixtureList(null);
            if (CollectionUtils.isNotEmpty(changeEntity.getContractAdmixtureList())) {
                for (ContractChangeAdmixtureEntity vo2 : changeEntity.getContractAdmixtureList()) {
                    vo2.setId(null);
                }
                contractEntity.setContractAdmixtureList(BeanMapper.mapList(changeEntity.getContractAdmixtureList(), ContractAdmixtureEntity.class));
            }
        }
        boolean flag = this.contractService.saveOrUpdate((Object)contractEntity, false);
        boolean pushFlag = this.contractService.pushContract((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class));
        if (pushFlag) {
            this.updateTotalChangeDataByContractId(changeEntity, "approve");
        }
        this.logger.info("\u4e1a\u52a1\u903b\u8f91\u5b8c\u6210--\u8fd4\u56de" + flag);
        if (flag) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!");
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ContractChangeEntity entity = (ContractChangeEntity)((Object)super.selectById((Serializable)changeBillId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractEntity.getId());
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.ne((Object)"id", (Object)changeBillId);
        int count = super.count((Wrapper)query);
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode() : ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingMnyWithTax(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeById((Serializable)changeBillId, false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType) {
        CommonResponse copyContractAttachResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, srcAttachSourceType, targetBillId, targetBillTypeCode, "proMaterialContractBill");
        if (!copyContractAttachResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "proMaterialContractBill", targetBillId, targetBillTypeCode, "proMaterialContractBill", copyContractAttachResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u7ba1\u7406\u4e2d\u7684\u9644\u4ef6\u5931\u8d25--------------->\u5931\u8d25\u4fe1\u606f------------>\uff1a{}", (Object)copyContractAttachResp.getMsg());
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractAttachResp.getMsg()));
        }
        CommonResponse copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, "mContractFile", targetBillId, targetBillTypeCode, "mContractFile");
        if (!copyContractFileResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{srcBillId, srcBillTypeCode, "mContractFile", targetBillId, targetBillTypeCode, "mContractFile", copyContractFileResp.getMsg()});
            return CommonResponse.error((String)("\u5ba1\u6279\u5931\u8d25\uff0c\u540c\u6b65\u5408\u540c\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg()));
        }
        return null;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ContractChangeVO contractChangeVO) {
        return null;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        return null;
    }

    @Override
    public ContractChangeVO queryDetail(Long id) {
        ContractChangeEntity entity = (ContractChangeEntity)((Object)this.contractChangeService.selectById(id));
        ContractChangeVO vo = (ContractChangeVO)BeanMapper.map((Object)((Object)entity), ContractChangeVO.class);
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(ContractChangeVO vo, ParamsCheckVO paramsCheckVO2) {
        return null;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMny(ContractChangeVO vo) {
        return null;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(ContractChangeVO vo) {
        return null;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ContractChangeVO vo) {
        return null;
    }

    @Override
    public ParamsCheckVO priceCheckParams(ContractChangeVO vo) {
        return null;
    }

    @Override
    public void updateTotalChangeDataByContractId(ContractChangeEntity changeEntity, String type) {
    }

    @Override
    public void asyncWatermarkById(Long id) {
        ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)super.selectById((Serializable)id));
        this.logger.info("\u5f00\u59cb\u83b7\u53d6\u6c34\u5370\u53c2\u6570\u4fe1\u606f\uff0c\u53d8\u66f4\u5408\u540cid\uff1a{}--------", (Object)id);
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        this.logger.info("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            String billType = "BT211227000000004";
            String sourceType = "contractMaterial";
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(changeEntity.getContractType())) {
                billType = "BT220215000000002";
                sourceType = "contractConcrete";
            }
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(), changeEntity.getBillCode(), billType, sourceType);
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractChangeAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }
}

