package com.ejianc.business.tradematerial.contract.service;

import com.ejianc.business.tradematerial.contract.bean.ContractChangeEntity;
import com.ejianc.business.tradematerial.contract.vo.ContractChangeVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 变更-合同实体
 * 
 * @author generator
 * 
 */
public interface IContractChangeService extends IBaseService<ContractChangeEntity> {

    ContractChangeVO insertOrUpdate(ContractChangeVO saveorUpdateVO, Boolean isControl);

    ContractChangeVO queryDetailRecord(Long id);

    ContractChangeVO queryChangeRecord(Long contractId, Long changeId);

    ContractChangeVO addConvertByConId(Long contractId, Long changeId);

    Map<String, Object> queryChangeCompare(Long id);

    Boolean changeSignStatus(Long billId, int status, String refCode);

    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState, Boolean filingFlag);

    CommonResponse<String> deleteById(Long changeBillId);

    ParamsCheckVO targetCostCtrl(ContractChangeVO contractChangeVO);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    ContractChangeVO queryDetail(Long id);

    ParamsCheckVO checkParams(ContractChangeVO vo, ParamsCheckVO paramsCheckVO2);
    /**
     * 单据管控-累计变更金额大于合同金额
     *
     * @return
     */
    List<ParamsCheckVO> checkParamsMny(ContractChangeVO vo);
    /**
     * 单据管控-合同金额大于总计划金额
     *
     * @return
     */
    List<ParamsCheckVO> checkParamsMnyPlan(ContractChangeVO vo);

    /*施工合同 控 补充协议,主合同
     *        @param 最新合同vo  或 协议vo

     * */
    List<ParamsCheckVO>  checkParamsConstruction(ContractChangeVO vo);

    /*历史价 控 明细价
     *        @param 最新合同vo  或 协议vo

     * */
    ParamsCheckVO priceCheckParams(ContractChangeVO vo);

    /**
     * 合同变更修改合同池变更金额
     *
     * @param changeEntity 变更信息
     * @param type         变更类型
     */
    void updateTotalChangeDataByContractId(ContractChangeEntity changeEntity, String type);

    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    void asyncWatermarkById(Long id);
}
