package com.ejianc.business.tradematerial.contract.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型编码常量
 */
public enum BillTypeEnum {

    消耗材总计划("消耗材总计划", "BT211224000000003"),
    消耗材总计划变更("消耗材总计划变更", "BT211224000000004"),
    混凝土总计划("混凝土总计划", "BT220211000000002"),
    混凝土总计划变更("混凝土总计划变更", "BT220211000000003"),
    消耗材合同("消耗材合同", "BT211227000000003"),
    消耗材合同变更("消耗材合同变更", "BT211227000000004"),
    混凝土合同("混凝土合同", "BT220215000000001"),
    混凝土变更合同("混凝土变更合同", "BT220215000000002"),
    物资采购合同解除("消耗材合同解除", "BT220218000000003"),
    混凝土合同解除("混凝土合同解除", "BT220219000000001"),
    结算单("结算单", "BT220309000000003"),
    混凝土结算单("混凝土结算单", "BT220316000000005"),
    ;

    private final String name;
    private final String code;
    private static Map<String, BillTypeEnum> enumMap = new HashMap();

    private BillTypeEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public static BillTypeEnum getEnumByName(String billTypeName) {
        return (BillTypeEnum)enumMap.get(billTypeName);
    }

    static {
        enumMap = (Map)EnumSet.allOf(BillTypeEnum.class).stream().collect(Collectors.toMap(BillTypeEnum::getName, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }

}
