package com.ejianc.business.tradematerial.settlement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.tradematerial.settlement.bean.SettlementEntity;
import com.ejianc.business.tradematerial.settlement.service.ISettlementService;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;

@Controller
@RequestMapping("statistic")
public class StatisticController implements Serializable {

    @Autowired
    private ISettlementService service;

    /**
     * 门户接口-零星材料内容
     * @param projectDepartmentId
     * @param settlementDate
     * @return
     */
    @RequestMapping(value = "/getSettlementInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getSettlementInfo(Long projectDepartmentId , String settlementDate){
        JSONObject jo = new JSONObject();
        ArrayList<Integer> list = new ArrayList<>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        if(projectDepartmentId != null ){
            QueryWrapper<SettlementEntity> wrapper = new QueryWrapper<>();
            wrapper.select("count(id) AS businessCount, IFNULL( sum(settlement_tax_mny),0) AS settlementTaxMny");
            wrapper.in("bill_state",list);
            wrapper.eq("org_id",projectDepartmentId);
            if(StringUtils.isNotBlank(settlementDate)){
                String[] split = settlementDate.split(",");
                wrapper.ge("settlement_date",split[0]);
                wrapper.le("settlement_date",split[1]);
            }
            wrapper.apply("contract_id is null AND contract_name is null");
            SettlementEntity one = service.getOne(wrapper);
            jo.put("businessCount",one.getBusinessCount());
            jo.put("settlementTaxMny",one.getSettlementTaxMny());
            return CommonResponse.success("查询数据成功！", jo);
        }
        return CommonResponse.error("查询数据失败，缺少项目部id！", jo);
    }
    /**
     * 门户接口-零星材料内容
     * @param projectDepartmentId
     * @param settlementDate
     * @return
     */
    @RequestMapping(value = "/getCheckInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getCheckInfo(Long projectDepartmentId , String settlementDate){
        JSONObject jo = new JSONObject();
        ArrayList<Integer> list = new ArrayList<>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        if(projectDepartmentId != null ){
            QueryWrapper<SettlementEntity> wrapper = new QueryWrapper<>();
            wrapper.select("count(id) AS businessCount, IFNULL( sum(check_all_tax_mny),0) AS settlementTaxMny");
            wrapper.in("bill_state",list);
            wrapper.eq("org_id",projectDepartmentId);
            if(StringUtils.isNotBlank(settlementDate)){
                String[] split = settlementDate.split(",");
                wrapper.ge("instore_date",split[0]);
                wrapper.le("instore_date",split[1]);
            }
            wrapper.apply("contract_id is null AND contract_name is null");
            SettlementEntity one = service.getOne(wrapper);
            jo.put("businessCount",one.getBusinessCount());
            jo.put("settlementTaxMny",one.getSettlementTaxMny());
            return CommonResponse.success("查询数据成功！", jo);
        }
        return CommonResponse.error("查询数据失败，缺少项目部id！", jo);
    }
}
