package com.ejianc.business.trade.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.trade.bean.PriceLibraryTransferEntity;
import com.ejianc.business.trade.vo.CghtlyqkVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.trade.bean.PriceLibraryEntity;
import com.ejianc.business.trade.service.IPriceLibraryService;
import com.ejianc.business.trade.vo.PriceLibraryVO;

/**
 * 价格库管理
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceLibrary")
public class PriceLibraryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "trade_price_library";//此处需要根据实际修改

    @Autowired
    private IPriceLibraryService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceLibraryVO> saveOrUpdate(@RequestBody PriceLibraryVO saveOrUpdateVO) {
    	PriceLibraryEntity entity = BeanMapper.map(saveOrUpdateVO, PriceLibraryEntity.class);
        UserContext userContextCache =sessionManager.getUserContext();
        if(entity.getId() == null || entity.getId() == 0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	PriceLibraryVO vo = BeanMapper.map(entity, PriceLibraryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceLibraryVO> queryDetail(Long id) {
    	PriceLibraryEntity entity = service.selectById(id);
    	PriceLibraryVO vo = BeanMapper.map(entity, PriceLibraryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceLibraryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PriceLibraryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PriceLibraryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceLibraryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PriceLibraryEntity> page = service.queryPage(param,false);
        IPage<PriceLibraryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceLibraryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PriceLibraryEntity> list = service.queryList(param);

        List<PriceLibraryTransferEntity> priceLibraryTransferEntities = BeanMapper.mapList(list, PriceLibraryTransferEntity.class);
        //todo:字段翻译等等
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (PriceLibraryTransferEntity entity:priceLibraryTransferEntities ){
            entity.setInsertDate1(simpleDateFormat.format(entity.getInsertDate()));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", priceLibraryTransferEntities);
        ExcelExport.getInstance().export("PriceLibrary-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refPriceLibraryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PriceLibraryVO>> refPriceLibraryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PriceLibraryEntity> page = service.queryPage(param,false);
        IPage<PriceLibraryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceLibraryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }



    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDateList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceLibraryVO>> queryDateList(@RequestBody QueryParam param) {
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        orderMap.clear();
        /** 模糊搜索配置字段示例 */
       // List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("htName");
//        List<Integer> billStates = new ArrayList<>();
//        billStates.add(1);
//        billStates.add(3);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        //param.getParams().put("zhu.billState", new Parameter(QueryParam.IN, billStates));
        //自定义查询，拼接查询语句
        Page<PriceLibraryVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);



        //自定义查询，写xml
        List<PriceLibraryVO> list = service.queryData (page, wrapper);

        IPage<PriceLibraryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }




    /**
     * @Description queryList 查询价格
     * @param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BigDecimal> queryPrice(@RequestBody PriceLibraryVO saveOrUpdateVO ) {
        QueryParam param = new QueryParam();
        param.getOrderMap().put("id",QueryParam.DESC);
        if (saveOrUpdateVO.getCzId()!=null){
            param.getParams().put("czId",new Parameter(QueryParam.EQ, saveOrUpdateVO.getCzId()));
        }
        if (saveOrUpdateVO.getInsertDate() != null){
            param.getParams().put("insertDate",new Parameter(QueryParam.EQ, saveOrUpdateVO.getInsertDate()));
        }
        param.getParams().put("gfId",new Parameter(QueryParam.EQ, saveOrUpdateVO.getGfId()));
        param.getParams().put("pmId",new Parameter(QueryParam.EQ, saveOrUpdateVO.getPmId()));
        param.getParams().put("ggId",new Parameter(QueryParam.EQ, saveOrUpdateVO.getGgId()));

        List<PriceLibraryEntity> priceLibraryEntities = service.queryList(param);
        if (priceLibraryEntities.size()>0) {
            return CommonResponse.success("查询列表数据成功！", priceLibraryEntities.get(0).getPrice());
        }
        return CommonResponse.error("未查询到物资数据！");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/uploadTemplate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> uploadTemplate(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImportInfo(request,response);
    }
}
