package com.ejianc.business.trade.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.trade.controller.PriceLibraryController;
import com.ejianc.business.trade.utils.DetailIndexExcelReader;
import com.ejianc.business.trade.utils.ImportVo;
import com.ejianc.business.trade.vo.ClwjxjglZiVO;
import com.ejianc.business.trade.vo.PriceLibraryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.trade.mapper.PriceLibraryMapper;
import com.ejianc.business.trade.bean.PriceLibraryEntity;
import com.ejianc.business.trade.service.IPriceLibraryService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 价格库管理
 * 
 * @author generator
 * 
 */
@Service("priceLibraryService")
public class PriceLibraryServiceImpl extends BaseServiceImpl<PriceLibraryMapper, PriceLibraryEntity> implements IPriceLibraryService{
@Autowired
private PriceLibraryController controller;
    @Override
    public List<PriceLibraryVO> queryData(Page<PriceLibraryVO> page, QueryWrapper wrapper) {
        return baseMapper.queryData(page,wrapper);
    }

    @Override
    public CommonResponse<JSONObject> excelImportInfo(HttpServletRequest request, HttpServletResponse response) {



        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();

        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        }else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size == null || size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }
            List<List<List<String>>> resList = DetailIndexExcelReader.readExcel(mf);
            List<List<String>> result0 = resList.get(0);
            if(result0.size()>0&&result0.get(0).size()<13){
                return CommonResponse.error("数据不完整，请下载最新模板！");
            }
            ImportVo importVo0 = excelImportSub(result0);

            JSONObject json = new JSONObject();
            json.put("successList", importVo0.getSubList());
            json.put("errorList", importVo0.getErrorList());
            return CommonResponse.success(json);
        }


    }

    private ImportVo excelImportSub(List<List<String>> result){
        ImportVo res = new ImportVo();

        if (result != null && result.size() > 0) {
            List<PriceLibraryVO> detailVoList = new ArrayList<>();

            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                PriceLibraryVO vo = new PriceLibraryVO();
                vo.setFlag(true);

                String materialCode = datas.get(0);//单据编号
                String gfName = datas.get(1);//gfName
                vo.setGfName(gfName);
                String cplbName = datas.get(2);//cplbName
                vo.setCplbName(cplbName);
                String pmName = datas.get(3);//pmName
                vo.setPmName(pmName);
                String ggName = datas.get(4);//ggName
                vo.setGgName(ggName);
                String czName = datas.get(5);//czName
                vo.setCzName(czName);
                String insertDate = datas.get(6);//insertDate
                String price = datas.get(7);//price
                String insertTime = datas.get(8);//insertTime
                try{
                    Integer aLong = Integer.valueOf(insertTime);
                    vo.setInsertTime(aLong);
                } catch (Exception e) {
                    vo.setFlag(false);
                }
                String orgId = datas.get(9);//orgId
                try{
                    Long aLong = Long.valueOf(orgId);
                    vo.setOrgId(aLong);
                } catch (Exception e) {
                    vo.setFlag(false);
                }
                String orgName = datas.get(10);//orgName
                vo.setOrgName(orgName);
                String gfId = datas.get(11);//gfId
                try{
                    Long aLong = Long.valueOf(gfId);
                    vo.setGfId(aLong);
                } catch (Exception e) {
                    vo.setFlag(false);
                }
                String cplbId = datas.get(12);//cplbId
                try{
                    Long aLong = Long.valueOf(cplbId);
                    vo.setCplbId(aLong);
                } catch (Exception e) {
                    vo.setFlag(false);
                }
                String pmId = datas.get(13);//pmId
                try{
                    Long aLong = Long.valueOf(pmId);
                    vo.setPmId(aLong);
                } catch (Exception e) {
                    vo.setFlag(false);
                }
                String ggId = datas.get(14);//ggId
                try{
                    Long aLong = Long.valueOf(ggId);
                    vo.setGgId(aLong);
                } catch (Exception e) {
                    vo.setFlag(false);
                }
                String czId = datas.get(15);//czId
                try{
                    Long aLong = Long.valueOf(czId);
                    vo.setCzId(aLong);
                } catch (Exception e) {
                    vo.setFlag(false);
                }



                try {
                    vo.setPrice(new BigDecimal(price));
                } catch (Exception e) {
                    vo.setFlag(false);
                }




                SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                try {
                    date = ft.parse(insertDate);
                    vo.setInsertDate(date);
                } catch (ParseException e) {
                    vo.setFlag(false);
                }

                detailVoList.add(vo);

            }
            List<PriceLibraryVO> successList = new ArrayList<>();
            List<PriceLibraryVO> errorList = new ArrayList<>();

            for(PriceLibraryVO vo :detailVoList){
                if(vo.getFlag()){
                    successList.add(vo);
                    //save(BeanMapper.map(vo,PriceLibraryEntity.class));
                    controller.saveOrUpdate(vo);
                }else{
                    errorList.add(vo);
                }
            }

            res.setErrorList(errorList);
            res.setSubList(successList);

        }
        return res;
    }
}
