package com.ejianc.business.tradematerial.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 付款管理 详情表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_payment_register_detail")
public class RegisterDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="register_id")
    private Long registerId; // 父id
    @TableField(value="source_id")
    private Long sourceId; // 来源结算单号id
    @TableField(value="source_code")
    private String sourceCode; // 来源结算单号编码
    @TableField(value="source_parent_id")
    private Long sourceParentId; // 来源结算单父id
    @TableField(value="source_parent_code")
    private String sourceParentCode; // 来源结算单父编码
    @TableField(value="settle_date")
    private Date settleDate; // 结算日期
    @TableField(value="plan_date")
    private Date planDate;//计划日期
    @TableField(value="happen_date")
    private Date happenDate;//发生日期
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 结算金额
    @TableField(value="plan_mny")
    private BigDecimal planMny; // 本次计划付款
    @TableField(value="last_mny")
    private BigDecimal lastMny; // 已支付金额(不含本次)
    @TableField(value="payable_mny")
    private BigDecimal payableMny; // 本次可支付金额
    @TableField(value="actual_mny")
    private BigDecimal actualMny; // 本次实付金额
    @TableField(value="total_actual_mny")
    private BigDecimal totalActualMny; // 累计实付金额(含本次)
    @TableField(value="detail_memo")
    private String detailMemo; // 备注

    @TableField(value="source_bill_code")
    private String sourceBillCode; // 来源单据编号
    @TableField(value = "detail_link_url")
    private String detailLinkUrl;//穿透地址

    @TableField(value = "detail_link_name")
    private String detailLinkName;//穿透名字

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public Date getHappenDate() {
        return happenDate;
    }

    public void setHappenDate(Date happenDate) {
        this.happenDate = happenDate;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public String getDetailLinkUrl() {
        return detailLinkUrl;
    }

    public void setDetailLinkUrl(String detailLinkUrl) {
        this.detailLinkUrl = detailLinkUrl;
    }

    public String getDetailLinkName() {
        return detailLinkName;
    }

    public void setDetailLinkName(String detailLinkName) {
        this.detailLinkName = detailLinkName;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getRegisterId() {
        return registerId;
    }

    public void setRegisterId(Long registerId) {
        this.registerId = registerId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }
    public Long getSourceParentId() {
        return sourceParentId;
    }

    public void setSourceParentId(Long sourceParentId) {
        this.sourceParentId = sourceParentId;
    }
    public String getSourceParentCode() {
        return sourceParentCode;
    }

    public void setSourceParentCode(String sourceParentCode) {
        this.sourceParentCode = sourceParentCode;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getPlanMny() {
        return planMny;
    }

    public void setPlanMny(BigDecimal planMny) {
        this.planMny = planMny;
    }
    public BigDecimal getLastMny() {
        return lastMny;
    }

    public void setLastMny(BigDecimal lastMny) {
        this.lastMny = lastMny;
    }
    public BigDecimal getPayableMny() {
        return payableMny;
    }

    public void setPayableMny(BigDecimal payableMny) {
        this.payableMny = payableMny;
    }
    public BigDecimal getActualMny() {
        return actualMny;
    }

    public void setActualMny(BigDecimal actualMny) {
        this.actualMny = actualMny;
    }
    public BigDecimal getTotalActualMny() {
        return totalActualMny;
    }

    public void setTotalActualMny(BigDecimal totalActualMny) {
        this.totalActualMny = totalActualMny;
    }
    public String getDetailMemo() {
        return detailMemo;
    }

    public void setDetailMemo(String detailMemo) {
        this.detailMemo = detailMemo;
    }
    
}
