package com.ejianc.business.tradematerial.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tradematerial.contract.bean.ContractDetailEntity;
import com.ejianc.business.tradematerial.contract.service.IContractDetailService;
import com.ejianc.business.tradematerial.contract.vo.ContractDetailVO;
import com.ejianc.business.tender.expert.vo.ProgressSheetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;

import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 主合同明细实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contractDetail")
@Api(value = "主合同明细实体", tags = {"主合同明细实体"})
public class ContractDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IContractDetailService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi materialApi;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractDetailVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody ContractDetailVO saveorUpdateVO) {
    	ContractDetailEntity entity = BeanMapper.map(saveorUpdateVO, ContractDetailEntity.class);
    	service.saveOrUpdate(entity, false);
    	ContractDetailVO vo = BeanMapper.map(entity, ContractDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractDetailVO> queryDetail(@RequestParam Long id) {
    	ContractDetailEntity entity = service.selectById(id);
    	ContractDetailVO vo = BeanMapper.map(entity, ContractDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ContractDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ContractDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ContractDetailEntity> page = service.queryPage(param,false);
        IPage<ContractDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContractDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ContractDetail-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refContractDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractDetailVO>> refContractDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                         String condition,
                                                                         String searchObject,
                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("spec");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, Long.valueOf(String.valueOf(_con.get("contractId")))));
                param.getParams().put("materialId", new Parameter(QueryParam.NE, null));
            }
        }
        IPage<ContractDetailEntity> page = service.queryPage(param,false);
        IPage<ContractDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    @ApiOperation("分类下物资参照")
    @RequestMapping(value = "/refContractDetailTypeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractDetailVO>> refContractDetailTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText) {
        QueryParam param = new QueryParam();
        Integer size = 0;
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, Long.valueOf(String.valueOf(_con.get("contractId")))));
                param.getParams().put("materialId", new Parameter(QueryParam.EQ, null));
            }
        }
        Page<ProgressSheetVO> page = new Page<>(pageNumber,pageSize);
        IPage<ContractDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ContractDetailEntity> contractDetailType= service.queryList(param,false);
        if(CollectionUtils.isEmpty(contractDetailType)) {
            return CommonResponse.success("查询参照数据成功！",pageData);
        }
        List<Long> collect = contractDetailType.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId() != null).map(t -> t.getMaterialTypeId()).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(collect)) {
            return CommonResponse.success("查询参照数据成功！",pageData);
        }
        Map<Long, ContractDetailEntity> contractMapType = contractDetailType.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        CommonResponse<List<MaterialVO>> response = materialApi.queryMaterialByCategoryId(collect);
        if(!response.isSuccess()){
            return CommonResponse.error("查询参照数据失败！错误信息："+response.getMsg());
        }
        List<MaterialVO> list = pageList(response.getData(), pageSize, pageNumber, searchText);
        size=response.getData().size();
        List<ContractDetailVO> detailList = new ArrayList<>();
        for (MaterialVO materialVO : list) {
            if(contractMapType.containsKey(materialVO.getCategoryId())){
                ContractDetailEntity contractDetailEntity = contractMapType.get(materialVO.getCategoryId());
                contractDetailEntity.setId(materialVO.getId());
                contractDetailEntity.setMaterialCode(materialVO.getCode());
                contractDetailEntity.setMaterialId(materialVO.getId());
                contractDetailEntity.setMaterialName(materialVO.getName());
                contractDetailEntity.setSpec(materialVO.getSpec());
                //contractDetailEntity.setUnitId(materialVO.getUnitId());
                contractDetailEntity.setUnitName(materialVO.getUnitName());
                ContractDetailVO map = BeanMapper.map(contractDetailEntity, ContractDetailVO.class);
                detailList.add(map);
            }
        }
        pageData.setRecords(detailList);
        pageData.setTotal(size);

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    //分页/模糊查询
    public List<MaterialVO> pageList(List<MaterialVO> dataList, int pageSize, int pageNo, String searchText) {
        List<MaterialVO> currentPageList = new ArrayList<>();
        if (StringUtils.isNotEmpty(searchText)) {
            dataList = dataList.stream().filter(item ->
                            (StringUtils.isNotEmpty(item.getName()) ? item.getName().contains(searchText) : false) ||
                                    (StringUtils.isNotEmpty(item.getCode()) ? item.getCode().contains(searchText) : false) ||
                                    (StringUtils.isNotEmpty(item.getSpec()) ? item.getSpec().contains(searchText) : false) ||
                                    (StringUtils.isNotEmpty(item.getCategoryName()) ? item.getCategoryName().contains(searchText) : false)
                    )
                    .collect(Collectors.toList());
        }

        if (dataList != null && dataList.size() > 0) {
            int currIdx = (pageNo > 1 ? (pageNo - 1) * pageSize : 0);
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; i++) {
                MaterialVO data = dataList.get(currIdx + i);
                currentPageList.add(data);
            }
        }
        return currentPageList;
    }


    @ApiOperation("查询明细列表")
    @RequestMapping(value = "/getContractDetailByTree", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getContractDetailByTree(@RequestParam Long contractId){
        return CommonResponse.success("查询成功",service.getContractDetailByTree(contractId));
    }

    @ApiOperation("查询明细列表")
    @RequestMapping(value = "/getContractDetailByTable", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getContractDetailByTable(@RequestParam Long contractId){
        return CommonResponse.success("查询成功",service.getContractDetailByTable(contractId));
    }

    @ApiOperation("查询明细列表详情")
    @RequestMapping(value = "/getContractDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ContractDetailVO>> getContractDetail(@RequestParam Long contractId){
        return CommonResponse.success("查询成功",service.getContractDetail(contractId));
    }
}
