package com.ejianc.business.tradematerial.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * PM支付主实体
 *
 * @author generator
 */
@TableName("ejc_profinance_pm_pay")
public class PMPayEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "create_user_name")
    private String createUserName; // 创建者名称
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者名称
    @TableField(value = "push_time")
    private Date pushTime; // 推送时间
    @TableField(value = "project_id")
    private Long projectId; // 项目ID
    @TableField(value = "supply_id")
    private Long supplyId; // 供应商ID
    @TableField(value = "contract_id")
    private Long contractId; // 合同ID（无合同为-1）
    @TableField(value = "payee_id")
    private Long payeeId; // 收款单位ID
    @TableField(value = "pay_mny_actual")
    private BigDecimal payMnyActual; // 实际支付金额
    @TableField(value = "source_id")
    private String sourceId; // 来源ID
    @TableField(value = "ext1")
    private String ext1; // 扩展字段
    @TableField(value = "ext2")
    private String ext2; // 扩展字段
    @TableField(value = "ext3")
    private String ext3; // 扩展字段
    @TableField(value = "ext4")
    private String ext4; // 扩展字段
    @TableField(value = "ext5")
    private String ext5; // 扩展字段
    @TableField(value = "ext6")
    private String ext6; // 扩展字段
    @TableField(value = "ext7")
    private String ext7; // 扩展字段
    @TableField(value = "ext8")
    private String ext8; // 扩展字段

    /**
     * 付款结果信息 付款成功、付款失败
     */
    @TableField(value = "pay_result_message")
    private String payResultMessage;

    /**
     * 核销标识：0-未核销，1-已核销,2-手动失败，3-手动成功
     */
    @TableField(value = "paid_flag")
    private Integer paidFlag;

    /**
     * 实际付款时间
     */
    @TableField(value = "actual_pay_time")
    private Date actualPayTime;

    /**
     * 数据来源：财务通知、付款补录
     */
    @TableField(value = "source_type")
    private String sourceType;

    /**
     * 数据来源编码：0-财务通知，1-付款补录
     */
    @TableField(value = "source_type_code")
    private String sourceTypeCode;

    public String getPayResultMessage() {
        return payResultMessage;
    }

    public void setPayResultMessage(String payResultMessage) {
        this.payResultMessage = payResultMessage;
    }

    public Integer getPaidFlag() {
        return paidFlag;
    }

    public void setPaidFlag(Integer paidFlag) {
        this.paidFlag = paidFlag;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getPayeeId() {
        return payeeId;
    }

    public void setPayeeId(Long payeeId) {
        this.payeeId = payeeId;
    }

    public BigDecimal getPayMnyActual() {
        return payMnyActual;
    }

    public void setPayMnyActual(BigDecimal payMnyActual) {
        this.payMnyActual = payMnyActual;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public Date getActualPayTime() {
        return actualPayTime;
    }

    public void setActualPayTime(Date actualPayTime) {
        this.actualPayTime = actualPayTime;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceTypeCode() {
        return sourceTypeCode;
    }

    public void setSourceTypeCode(String sourceTypeCode) {
        this.sourceTypeCode = sourceTypeCode;
    }
}
