package com.ejianc.business.tradematerial.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 专户付款申请子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_payment_apply_zh_detail")
public class PaymentApplyZhDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_id")
    private Long createUserId; // 创建者账号
    @TableField(value="pay_id")
    private Long payId; // 付款申请id主id
    @TableField(value="source_id")
    private Long sourceId; // 申请单id 来源
    @TableField(value="source_bill_code")
    private String sourceBillCode; // 申请单据号
    @TableField(value="source_type")
    private String sourceType; // 
    @TableField(value="current_apply_mny")
    private BigDecimal currentApplyMny; // 本期申请金额
    @TableField(value="actual_payment_mny")
    private BigDecimal actualPaymentMny; // 实际付款金额
    @TableField(value="memo")
    private String memo; // 备注 非必填，0-500字
    @TableField(value="current_zh_apply_mny")
    private BigDecimal currentZhApplyMny; // 专户申请金额
    @TableField(value="contract_name")
    private String contractName; // 合同名称

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public BigDecimal getCurrentZhApplyMny() {
        return currentZhApplyMny;
    }

    public void setCurrentZhApplyMny(BigDecimal currentZhApplyMny) {
        this.currentZhApplyMny = currentZhApplyMny;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    public Long getPayId() {
        return payId;
    }

    public void setPayId(Long payId) {
        this.payId = payId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public BigDecimal getCurrentApplyMny() {
        return currentApplyMny;
    }

    public void setCurrentApplyMny(BigDecimal currentApplyMny) {
        this.currentApplyMny = currentApplyMny;
    }
    public BigDecimal getActualPaymentMny() {
        return actualPaymentMny;
    }

    public void setActualPaymentMny(BigDecimal actualPaymentMny) {
        this.actualPaymentMny = actualPaymentMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
