package com.ejianc.business.tradematerial.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tradematerial.finance.bean.RegulateEntity;
import com.ejianc.business.tradematerial.finance.enums.PaymentContractEnum;
import com.ejianc.business.tradematerial.finance.service.IPaymentRegisterService;
import com.ejianc.business.tradematerial.finance.service.IRegulateService;
import com.ejianc.business.tradematerial.finance.vo.RegulateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RList;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 付款管理 中间表
 *
 * @author generator
 */
@Controller
@RequestMapping("regulate")
public class RegulateController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private RedissonClient redissonClient;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IRegulateService service;

    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private IPaymentRegisterService registerService;



    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RegulateVO> saveOrUpdate(@RequestBody RegulateVO saveOrUpdateVO) {
        RegulateEntity entity = BeanMapper.map(saveOrUpdateVO, RegulateEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
////            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
////            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
////            if(billCode.isSuccess()) {
////                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
////                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
////            }else{
////                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
////            }
//        }
        service.saveOrUpdate(entity, false);
        RegulateVO vo = BeanMapper.map(entity, RegulateVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RegulateVO> queryDetail(Long id) {
        RegulateEntity entity = service.selectById(id);
        RegulateVO vo = BeanMapper.map(entity, RegulateVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

//    @Transactional(rollbackFor = Exception.class)
//    @RequestMapping(value = "/closeByState", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<String> closeByState(@RequestBody List<RegulateVO> entity) {
//        UpdateWrapper<RegulateEntity> updateWrapper = new UpdateWrapper<>();
//        List<Long> collect = entity.stream().map(item -> item.getId()).collect(Collectors.toList());
//
//        List<Long> contractIds = entity.stream().filter(item -> item.getPaymentContractFlag() == 2).map(item -> item.getSourceId()).collect(Collectors.toList());
//        List<Long> materialIds = entity.stream().filter(item -> item.getPaymentContractFlag() == 3).map(item -> item.getSourceId()).collect(Collectors.toList());
//        List<Long> temporaryIds = entity.stream().filter(item -> item.getPaymentContractFlag() == 4).map(item -> item.getSourceId()).collect(Collectors.toList());
//        List<Long> planFeeIds = entity.stream().filter(item -> item.getPaymentContractFlag() == 5).map(item -> item.getSourceId()).collect(Collectors.toList());
//
//        updateWrapper.in("id", collect);
//        if ("未关闭".equals(entity.get(0).getCloseState())) {
//            //说明当前 设置为 已关闭
//            updateWrapper.set("close_date_time", new Date());
//            updateWrapper.set("close_user_id", sessionManager.getUserContext().getUserId());
//            updateWrapper.set("close_user_name", sessionManager.getUserContext().getUserName());
//            updateWrapper.set("close_user_code", sessionManager.getUserContext().getUserCode());
//            updateWrapper.set("close_state", "已关闭");
//        } else {
//            //说明当前 设置为 未关闭
//            updateWrapper.set("close_date_time", null);
//            updateWrapper.set("close_user_id", null);
//            updateWrapper.set("close_user_name", null);
//            updateWrapper.set("close_user_code", null);
//            updateWrapper.set("close_state", "已关闭");
//        }
//        if (CollectionUtils.isNotEmpty(contractIds)){
//            UpdateWrapper<PlanContractEntity> updateContract = new UpdateWrapper<>();
//            updateContract.in("id", contractIds);
//            updateContract.set("close_state", "已关闭");
//            planContractService.update(updateContract);
//        }
//        if (CollectionUtils.isNotEmpty(materialIds)){
//            UpdateWrapper<PlanMaterialEntity> updateMate = new UpdateWrapper<>();
//            updateMate.in("id", materialIds);
//            updateMate.set("close_state", "已关闭");
//            planMaterialService.update(updateMate);
//        }
//        if (CollectionUtils.isNotEmpty(temporaryIds)){
//            UpdateWrapper<PlanTemporaryEntity> updateTem = new UpdateWrapper<>();
//            updateTem.in("id", temporaryIds);
//            updateTem.set("close_state", "已关闭");
//            planTemporaryService.update(updateTem);
//        }
//        if (CollectionUtils.isNotEmpty(planFeeIds)){
//            UpdateWrapper<PlanFeeEntity> updateFee = new UpdateWrapper<>();
//            updateFee.in("id", planFeeIds);
//            updateFee.set("close_state", "已关闭");
//            planFeeService.update(updateFee);
//        }
//        //TODO 回写逻辑
//        service.update(updateWrapper);
//        return CommonResponse.success("修改成功！");
//    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RegulateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RegulateVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(RegulateVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return RegulateVO
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject resp = new JSONObject();

        /** 模糊搜索配置字段示例 计划单号/项目名称/合同名称/收款单位*/
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        Map<String, BigDecimal> map = service.fetchTotalMny(param);
        param.getOrderMap().put("create_time", QueryParam.ASC);
        IPage<RegulateEntity> page = service.queryPage(param, false);
        List<RegulateVO> vos = BeanMapper.mapList(page.getRecords(), RegulateVO.class);

        resp.put("current", page.getCurrent());
        resp.put("size", page.getSize());
        resp.put("pages", page.getPages());
        resp.put("total", page.getTotal());
        resp.put("records", vos);
        resp.put("totalPlanPayMny", map.get("totalPlanPayMny"));
        resp.put("totalPaidMny", map.get("totalPaidMny"));
        return CommonResponse.success("查询列表数据成功！", resp);


//        IPage<RegulateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RegulateVO.class));
//
//        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {


        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = queryList(param);
        List<RegulateVO> paymentRegisterVOList = new ArrayList<>();

        if (null != commonResponse.getData()) {
            paymentRegisterVOList = (List<RegulateVO>) commonResponse.getData().get("records");
            //流程状态
            if (CollectionUtils.isNotEmpty(paymentRegisterVOList)) {
                for (RegulateVO paymentRegisterVO : paymentRegisterVOList) {
                    paymentRegisterVO.setPaymentContractFlagName(PaymentContractEnum.getByCode(paymentRegisterVO.getPaymentContractFlag()).getName());
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", paymentRegisterVOList);
        ExcelExport.getInstance().export("Regulate-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refRegulateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RegulateVO>> refRegulateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setSearchObject(searchObject);
        //模糊查询字段
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("sourceBillCode");

        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("unpaidMny", new Parameter(QueryParam.GT, 0));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if (_con.containsKey("supplierId")) {
                String supplierId = _con.getString("supplierId");
                param.getParams().put("", new Parameter(QueryParam.SQL, " (supplier_user_id= '" + supplierId + "'or supplier_org_id ='" + supplierId + "')"));
            }
            if (_con.containsKey("paymentContractFlag")) {
                param.getParams().put("paymentContractFlag", new Parameter(QueryParam.EQ, _con.get("paymentContractFlag")));
                String paymentContractFlag = _con.getString("paymentContractFlag");
                if ("5".equals(paymentContractFlag)){
                    if (_con.containsKey("feeTypeId")&&_con.get("feeTypeId")!=null) {
                        param.getParams().put("feeTypeId", new Parameter(QueryParam.EQ, _con.get("feeTypeId")));
                    }
                }
            }
            String excludeIdStr = _con.getString("excludeIds");
            if (StringUtils.isNotBlank(excludeIdStr)) {
                param.getParams().put("sourceId", new Parameter(QueryParam.NOT_IN, Lists.newArrayList(excludeIdStr.split(","))));
            }
        }

        IPage<RegulateEntity> page = service.queryPage(param, false);
        IPage<RegulateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RegulateVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @PostMapping(value = "/regulateData")
    @ResponseBody
    public CommonResponse<Map<String, List<RegulateVO>>> regulateData(@RequestBody JSONObject jsonObject) {
        Map<String, List<RegulateVO>> data = new HashMap<>();
        if (!jsonObject.containsKey("key")) {
            throw new BusinessException("请求参数不能为空！");
        }
        String key = jsonObject.getString("key");
        RList<RegulateVO> regulateList = redissonClient.getList(key);
        if (CollectionUtils.isEmpty(regulateList) && jsonObject.containsKey("ids")) {
            List<Long> ids = jsonObject.getJSONArray("ids").toJavaList(Long.class);
            Collection<RegulateEntity> pls = service.listByIds(ids);
            checkRefStatus(pls);
            regulateList.addAll(BeanMapper.mapList(pls, RegulateVO.class));
            regulateList.expire(Long.parseLong("5"), TimeUnit.MINUTES);
        } else {
            checkRefStatus(BeanMapper.mapList(regulateList, RegulateEntity.class));
        }
        data.put(key, BeanMapper.mapList(redissonClient.getList(key), RegulateVO.class));
        return CommonResponse.success("查询成功！", data);
    }

    private void checkRefStatus(Collection<RegulateEntity> entities) {
        for (RegulateEntity entity : entities) {
            if (entity.getRefStatus() != null && "引用".equals(entity.getRefStatus())) {
                throw new BusinessException("操作失败！该数据存在未生效的【付款登记】，不允许再次确认支付");
            }
        }
    }
}
