package com.ejianc.business.tradematerial.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.tradematerial.finance.bean.RegulateEntity;
import com.ejianc.business.tradematerial.finance.mapper.RegulateMapper;
import com.ejianc.business.tradematerial.finance.service.IRegulateService;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 付款管理 中间表
 * 
 * @author generator
 * 
 */
@Service("regulateService")
public class RegulateServiceImpl extends BaseServiceImpl<RegulateMapper, RegulateEntity> implements IRegulateService {

    @Override
    public Map<String, BigDecimal> fetchTotalMny(QueryParam param) {
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("ifnull(sum(plan_pay_mny), 0) as totalPlanPayMny, ifnull(sum(paid_mny), 0) as totalPaidMny");
        return super.getMap(wrapper);
    }


    @Override
    public void updateColumnValue(List<Long> ids, String column, String value) {
        UpdateWrapper<RegulateEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("source_id", ids);
        updateWrapper.set(column, value);
        super.update(updateWrapper);
    }

}
