package com.ejianc.business.tradematerial.settlement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.tradematerial.enums.BillPushStatusEnum;
import com.ejianc.business.tradematerial.settlement.bean.SettlementEntity;
import com.ejianc.business.tradematerial.settlement.service.ISettlementService;
import com.ejianc.business.tradematerial.settlement.vo.*;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 结算单主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("settlement")
@Api(value = "结算单主表", tags = {"结算单主表"})
public class SettlementController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "JS_CODE";//此处需要根据实际修改

    @Autowired
    private ISettlementService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;


    private static final String MBILL_TYPE = "BT220309000000003";//消耗
    private static final String CBILL_TYPE = "BT220316000000005";//混凝
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/settlement/card";//消耗
    private final String cmobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/concreteSettlement/card";//混凝

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SettlementVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }
    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SettlementVO> pushCost(@RequestBody SettlementVO settlementVO) {
        return  service.pushCost(settlementVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementVO> queryDetail(@RequestParam Long id) {
    	SettlementEntity entity = service.selectById(id);
    	SettlementVO vo = BeanMapper.map(entity, SettlementVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("获取最近一次结算日期和结算金额，结算次数")
    @RequestMapping(value = "/getDateMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map> getDateMny(@RequestParam Long contractId) {
        return service.getDateMny(contractId);
    }

    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        SettlementEntity entity = service.selectById(id);
        String billTypeCode;
        String url;
        if(entity.getSettlementType()==1){//（0-物资采购结算单，1-混凝土结算单）
            billTypeCode=CBILL_TYPE;
            url=cmobileBillShareFrontUrl;
        }else {
            billTypeCode=MBILL_TYPE;
            url=mobileBillShareFrontUrl;
        }
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("单据获取供方信息失败，生成分享连接失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同分享。");
        }
        if(BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", billTypeCode, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            } else {
                //未曾成功推送单据，则先向供方推送单据
                boolean pushResult = service.pushBillToSupCenter(entity,billTypeCode);
                logger.info("获取推送供方结果--"+pushResult);
                if(!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                } else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }


        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), url,null);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SettlementVO> vos) {
        return service.delete(vos);
    }

    @ApiOperation("同步结算池接口")
    @RequestMapping(value = "/syncSettle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushSettle(@RequestParam Long id) {
        SettlementEntity settlementEntity = service.selectById(id);
        boolean pool = service.pushSettleToPool(BeanMapper.map(settlementEntity, SettlementVO.class));
        if(!pool){
            throw new BusinessException("推送结算池失败");
        }
        return CommonResponse.success("同步成功");
    }

    /**
     * 目标成本推送
     * @param id
     * @return
     */
    @RequestMapping(value = "/pushTargetCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return service.pushTargetCost(id);
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    /**
     * 单据管控-累计结算金额大于合同金额
     * @return
     */
    @RequestMapping(value = "/checkParams", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody SettlementVO vo) {
        ParamsCheckVO paramsCheckVO = service.checkParams(vo);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }
    /**
     * @param id 合同id
     */
    @ApiOperation("根据合同id查询结算记录")
    @RequestMapping(value = "/querySettleRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettlementRecordVO> querySettleRecord(@RequestParam Long id) {
        SettlementRecordVO vo = service.querySettleRecord(id);
        return CommonResponse.success("查询结算单成功",vo);
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        Map<String, Parameter> params = param.getParams();
        if(params.containsKey("isNotContract")){
            Parameter isNotContract = params.get("isNotContract");
            String s = isNotContract.getValue().toString();
            if(-1!=s.indexOf("0") && -1!=s.indexOf("1")){//两个都满足不添加条件

            }else if(-1!=s.indexOf("0")){//0 无合同同  1  有合同
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, null));
            }else if(-1!=s.indexOf("1")){
                param.getParams().put("contractId", new Parameter(QueryParam.NE, null));
            }
            params.remove("isNotContract");
        }
        //结算类型过滤  （0-消耗材，1-混凝土）
        param.getParams().put("settlementType", new Parameter(QueryParam.EQ, 0));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<SettlementEntity> page = service.queryPage(param,false);
        IPage<SettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @ApiOperation("混凝土查询列表")
    @RequestMapping(value = "/ConcreteQueryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> ConcreteQueryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        Map<String, Parameter> params = param.getParams();
        if(params.containsKey("isNotContract")){
            Parameter isNotContract = params.get("isNotContract");
            String s = isNotContract.getValue().toString();
            if(-1!=s.indexOf("0") && -1!=s.indexOf("1")){//两个都满足不添加条件

            }else if(-1!=s.indexOf("0")){//0 无合同同  1  有合同
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, null));
            }else if(-1!=s.indexOf("1")){
                param.getParams().put("contractId", new Parameter(QueryParam.NE, null));
            }
            params.remove("isNotContract");
        }
        //结算类型过滤  （0-消耗材，1-混凝土）
        param.getParams().put("settlementType", new Parameter(QueryParam.EQ, 1));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<SettlementEntity> page = service.queryPage(param,false);
        IPage<SettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void ConcreteExcelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        //结算类型过滤  （0-消耗材，1-混凝土）
        param.getParams().put("settlementType", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettlementEntity> list = service.queryList(param);
        //todo:字段翻译等等
        ArrayList<ExportSettlementVO> settlementVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            for (SettlementEntity entity : list) {
                ExportSettlementVO map = BeanMapper.map(entity, ExportSettlementVO.class);
                if(entity.getSettlementDate()!=null){
                    map.setSettlementDate(DateFormatUtil.formatDate("yyyy-MM-dd", entity.getSettlementDate()));
                }
                switch (entity.getSignStatus()){
                    case 0: map.setSignStatus("未签字");break;
                    case 1: map.setSignStatus("已签字");break;
                }
                //TODO  待补充 --签章
                switch (entity.getSignatureStatus()){
                    case 0: map.setSignatureStatus("未签章");break;
                }
                switch (entity.getBillState()){
                    case 0: map.setBillState("自由态");break;
                    case 1: map.setBillState("已提交");break;
                    case 2: map.setBillState("审批中");break;
                    case 3: map.setBillState("审批通过");break;
                    case 4: map.setBillState("审批驳回");break;
                    case 5: map.setBillState("审批中");break;
                }
                settlementVOS.add(map);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", settlementVOS);
        ExcelExport.getInstance().export("Settlement-export.xlsx", beans, response);
    }
    @ApiOperation("混凝土导出")
    @RequestMapping(value = "/ConcreteExcelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        //结算类型过滤  （0-消耗材，1-混凝土）
        param.getParams().put("settlementType", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SettlementEntity> list = service.queryList(param);
        //todo:字段翻译等等
        ArrayList<ExportSettlementVO> settlementVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            for (SettlementEntity entity : list) {
                ExportSettlementVO map = BeanMapper.map(entity, ExportSettlementVO.class);
                if(entity.getSettlementDate()!=null){
                    map.setSettlementDate(DateFormatUtil.formatDate("yyyy-MM-dd", entity.getSettlementDate()));
                }
                switch (entity.getSignStatus()){
                    case 0: map.setSignStatus("未签字");break;
                    case 1: map.setSignStatus("已签字");break;
                }
                //TODO  待补充 --签章
                switch (entity.getSignatureStatus()){
                    case 0: map.setSignatureStatus("未签章");break;
                }
                switch (entity.getBillState()){
                    case 0: map.setBillState("自由态");break;
                    case 1: map.setBillState("已提交");break;
                    case 2: map.setBillState("审批中");break;
                    case 3: map.setBillState("审批通过");break;
                    case 4: map.setBillState("审批驳回");break;
                    case 5: map.setBillState("审批中");break;
                }
                settlementVOS.add(map);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", settlementVOS);
        ExcelExport.getInstance().export("ConcreteSettlement-export.xlsx", beans, response);
    }

    @ApiOperation("参照")
    @RequestMapping(value = "/refSettlementData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SettlementVO>> refSettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SettlementEntity> page = service.queryPage(param,false);
        IPage<SettlementVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SettlementVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 查询合同结算记录
     *
     * @return
     */
    @GetMapping(value = "/queryDetailRecord")
    @ResponseBody
    public CommonResponse<ContractSettlementRecordVO> queryDetailRecord(Long id) {
        ContractSettlementRecordVO vo = service.queryDetailRecord(id);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 查询合同结算记录
     *
     * @return
     */
    @PostMapping(value = "/querySettlementByContractId")
    @ResponseBody
    public CommonResponse<List<SettlementVO>> querySettlementByContractId(@RequestBody SettlementVO settlementVO) {
        List<SettlementVO> list = service.querySettlementByContractId(settlementVO);
        return CommonResponse.success("查询详情数据成功！", list);
    }

    /**
     * 查询打印结算单材料明细
     *
     * @return
     */
    @PostMapping(value = "/queryPrintSettlementDetail")
    @ResponseBody
    public CommonResponse<List<PrintSettlementDetailVO>> queryPrintSettlementDetail(@RequestBody SettlementVO settlementVO) {
        List<PrintSettlementDetailVO> list = service.queryPrintSettlementDetail(settlementVO);
        return CommonResponse.success("查询详情数据成功！", list);
    }

    /**
     * 查询打印结算单其他费用
     *
     * @return
     */
    @PostMapping(value = "/queryPrintSettlementFee")
    @ResponseBody
    public CommonResponse<List<PrintSettlementFeeVO>> queryPrintSettlementFee(@RequestBody SettlementVO settlementVO) {
        List<PrintSettlementFeeVO> list = service.queryPrintSettlementFee(settlementVO);
        return CommonResponse.success("查询详情数据成功！", list);
    }

    /**
     * 打印详情处理
     *
     * @param detailJsonStr 打印json
     * @return 处理结果
     */
    @PostMapping("/handlePrintDetail")
    @ResponseBody
    public CommonResponse<JSONObject> handlePrintDetail(@RequestBody String detailJsonStr) {
        logger.info("进入结算打印详情处理，参数detailJsonStr：{}", detailJsonStr);
        String settlementKey = "Settlement";
        if (StringUtils.isBlank(detailJsonStr)) {
            return CommonResponse.success(null);
        }
        JSONObject data = JSONObject.parseObject(detailJsonStr);
        if (null == data) {
            return CommonResponse.success(null);
        }
        JSONObject detailJson = data.getJSONObject("detailJson");
        if (null == detailJson) {
            return CommonResponse.success(null);
        }
        JSONObject settlementJson = detailJson.getJSONObject(settlementKey);
        if (null == settlementJson) {
            return CommonResponse.success(detailJson);
        }
        SettlementVO settlementVO = JSONObject.toJavaObject(settlementJson, SettlementVO.class);
        if (settlementVO == null || settlementVO.getContractId() == null) {
            return CommonResponse.success(detailJson);
        }
        List<SettlementVO> settlementUnionList = service.querySettlementByContractId(settlementVO);
        settlementJson.put("SettlementUnion", settlementUnionList);
        List<PrintSettlementDetailVO> printSettlementDetailList = service.queryPrintSettlementDetail(settlementVO);
        settlementJson.put("PrintSettlementDetail", printSettlementDetailList);
        List<PrintSettlementFeeVO> printSettlementFeeList = service.queryPrintSettlementFee(settlementVO);
        settlementJson.put("PrintSettlementFee", printSettlementFeeList);
        detailJson.put(settlementKey, settlementJson);
        logger.info("结算打印详情处理成功，处理结果：{}", detailJson);
        return CommonResponse.success(detailJson);
    }
}
