package com.ejianc.business.weigh.weighbill.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.weigh.wagon.service.IWagonMaterialService;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.service.IWeighbillService;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/weighbill/")
public class WeighbillApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWeighbillService weighbillService;

    @Autowired
    private IWagonMaterialService wagonMaterialService;

    /**
     * 根据物资明细id 获取发货单详情
     *
     * @param
     * @return
     */
    @ApiOperation("根据磅单主键返回详情接口")
    @RequestMapping(value = "/queryWeighbills", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<WeighbillVO>> queryWeighbills(@RequestParam("projectId") Long projectId,@RequestParam("weighIds") List<Long> weighIds) {
        logger.info("根据磅单主键返回详情接口参数：{}", JSONObject.toJSONString(weighIds));
        List<WeighbillVO> resList = new ArrayList<>();
        List<Long> materialIds = new ArrayList<>();
        List<WeighbillEntity> weighbillEntityList =  weighbillService.list(new QueryWrapper<WeighbillEntity>().in("id",weighIds));
        if(CollectionUtils.isNotEmpty(weighbillEntityList)){
           materialIds = weighbillEntityList.stream().map(WeighbillEntity::getMaterialId).collect(Collectors.toList());
           logger.info("-----参数：{}", JSONObject.toJSONString(materialIds));
           resList = BeanMapper.mapList(weighbillEntityList,WeighbillVO.class);
            List<WagonMaterialVO> wagonMaterialVOList = wagonMaterialService.queryMaterialAutomaticWeighBatch(projectId,materialIds);
            logger.info("查询磅单转换系数返回数据：{}", JSONObject.toJSONString(wagonMaterialVOList));
            Map<Long,BigDecimal> map = new HashMap<>();
            if(CollectionUtils.isNotEmpty(wagonMaterialVOList)){
//                map = wagonMaterialVOList.stream().collect(Collectors.toMap(WagonMaterialVO::getMaterialId,WagonMaterialVO::getScaleFactor));
                for(int k=0;k<wagonMaterialVOList.size();k++){
                     if(!map.containsKey(wagonMaterialVOList.get(k).getMaterialId())){
                           map.put(wagonMaterialVOList.get(k).getMaterialId(),wagonMaterialVOList.get(k).getScaleFactor());
                     }
                }
                for(int i=0;i<resList.size();i++){
                    WeighbillVO vo = resList.get(i);
                    if(map.containsKey(vo.getMaterialId())){
                        resList.get(i).setCoefficient(map.get(vo.getMaterialId()));
                    }else{
                        resList.get(i).setCoefficient(BigDecimal.ZERO);
                    }
                }
            }else{
                resList.forEach(e->{
                    e.setCoefficient(BigDecimal.ZERO);
                });
            }
        }
        logger.info("根据磅单主键返回详情接口返回数据：{}", JSONObject.toJSONString(resList));
        return CommonResponse.success(resList);
    }



    /**
     * 根据发货单id 获取磅单数量
     *
     * @param
     * @return
     */
    @ApiOperation("根据发货单主键返回详情接口")
    @RequestMapping(value = "/queryWeighBydeliveryId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<WeighbillVO>> queryWeighBydeliveryId(@RequestParam("deliveryIds") List<Long> deliveryIds) {
        logger.info("根据磅单主键返回详情接口参数：{}", JSONObject.toJSONString(deliveryIds));
        List<WeighbillVO> resList = new ArrayList<>();
        List<WeighbillEntity> weighbillEntityList =  weighbillService.list(new QueryWrapper<WeighbillEntity>().in("delivery_id",deliveryIds));
        Map<Long,Integer> weighMap = new HashMap<>();
        Map<Long,Integer> checkMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(weighbillEntityList)){
            for(int i=0;i<weighbillEntityList.size();i++){
                WeighbillEntity weighbillEntity = weighbillEntityList.get(i);
                if(weighMap.containsKey(weighbillEntity.getDeliveryId())){
                    weighMap.put(weighbillEntity.getDeliveryId(),weighMap.get(weighbillEntity.getDeliveryId())+1);
                }else{
                    weighMap.put(weighbillEntity.getDeliveryId(),1);
                }
                if(checkMap.containsKey(weighbillEntity.getDeliveryId())){
                    if(1==weighbillEntity.getCheckStatus()){
                        //已验收
                        checkMap.put(weighbillEntity.getDeliveryId(),checkMap.get(weighbillEntity.getDeliveryId())+1);
                    }
                }else{
                    if(1==weighbillEntity.getCheckStatus()){
                        //已验收
                        checkMap.put(weighbillEntity.getDeliveryId(),1);
                    }
                }
            }
        }
        deliveryIds.forEach(e->{
            WeighbillVO weighbillVO = new WeighbillVO();
            weighbillVO.setDeliveryId(e);
            weighbillVO.setWeightNum(weighMap.get(e)==null?0:weighMap.get(e));
            weighbillVO.setWeightCheckNum(checkMap.get(e)==null?0:checkMap.get(e));
            resList.add(weighbillVO);
        });
        logger.info("根据磅单主键返回详情接口返回数据：{}", JSONObject.toJSONString(resList));
        return CommonResponse.success(resList);
    }


    /**
     * 根据物资明细id 获取发货单详情
     *
     * @param
     * @return
     */
    @ApiOperation("更新磅单验收状态")
    @RequestMapping(value = "/updateWeighbills", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateWeighbills(@RequestBody List<WeighbillVO> weighbillVOList){
        logger.info("更新磅单验收状态接口参数：{}", JSONObject.toJSONString(weighbillVOList));
        if(CollectionUtils.isNotEmpty(weighbillVOList)){
            List<WeighbillEntity> list = new ArrayList<>();
            weighbillVOList.forEach(e->{
                WeighbillEntity weighbillEntity = weighbillService.selectById(e.getId());
                weighbillEntity.setCheckStatus(e.getCheckStatus());
                weighbillEntity.setCheckId(e.getCheckId());
                weighbillEntity.setCheckDetailId(e.getCheckDetailId());
                list.add(weighbillEntity);
            });
            weighbillService.updateBatchById(list);
            logger.info("更新磅单验收状态返回数据：{}", JSONObject.toJSONString(list));
        }
        return CommonResponse.success("执行成功");
    }
}
