/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.wagon.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.weigh.wagon.bean.WagonMaterialEntity;
import com.ejianc.business.weigh.wagon.service.IWagonMaterialService;
import com.ejianc.business.weigh.wagon.vo.WagonMaterialVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"wagonMaterial"})
@Api(value="\u79f0\u91cd\u6750\u6599\u8bbe\u7f6e", tags={"\u79f0\u91cd\u6750\u6599\u8bbe\u7f6e"})
public class WagonMaterialController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IWagonMaterialService service;
    @Autowired
    private SessionManager sessionManager;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WagonMaterialVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody WagonMaterialVO saveOrUpdateVO) {
        WagonMaterialEntity entity = (WagonMaterialEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, WagonMaterialEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        WagonMaterialVO vo = (WagonMaterialVO)BeanMapper.map((Object)((Object)entity), WagonMaterialVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WagonMaterialVO> queryDetail(@RequestParam Long id) {
        WagonMaterialEntity entity = (WagonMaterialEntity)((Object)this.service.selectById(id));
        WagonMaterialVO vo = (WagonMaterialVO)BeanMapper.map((Object)((Object)entity), WagonMaterialVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WagonMaterialVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WagonMaterialVO wagonMaterialVO : vos) {
            }
        }
        List idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", idList));
        List entityList = this.service.queryList(queryParam);
        Long orgId = InvocationInfoProxy.getOrgId();
        this.logger.info("InvocationInfoProxy.getOrgId()={}", (Object)orgId);
        for (WagonMaterialEntity entity : entityList) {
            this.logger.info("entity.getOrgId()={}", (Object)entity.getOrgId());
            if (orgId.equals(entity.getOrgId())) continue;
            throw new BusinessException("\u53ea\u80fd\u64cd\u4f5c\u672c\u7ec4\u7ec7\u4e0b\u7684\u6570\u636e\uff01");
        }
        this.service.removeByIds(idList, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WagonMaterialVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unitName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (param.getParams().containsKey("isMyOrg") && "true".equals(((Parameter)param.getParams().get("isMyOrg")).getValue().toString())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse parentOrgResp = this.iOrgApi.findParentsByOrgId(orgId);
            if (!parentOrgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List parentOrgIds = ((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            param.getParams().put("orgId", new Parameter("in", parentOrgIds));
        }
        param.getParams().remove("isMyOrg");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WagonMaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WagonMaterial-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refWagonMaterialData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WagonMaterialVO>> refWagonMaterialData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WagonMaterialVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u6279\u91cf\u63d2\u5165\u6570\u636e")
    @RequestMapping(value={"/insertBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, Object>> insertBatch(@RequestBody List<WagonMaterialVO> vos) {
        return CommonResponse.success((String)"\u6279\u91cf\u5904\u7406\u6210\u529f\uff01", this.service.insertBatch(vos));
    }

    @ApiOperation(value="\u4fee\u6539\u72b6\u6001")
    @RequestMapping(value={"/updateAutomaticWeigh"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateAutomaticWeigh(@RequestBody WagonMaterialVO saveOrUpdateVO) {
        this.service.updateAutomaticWeigh(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fee\u6539\u72b6\u6001\u6210\u529f");
    }

    @ApiOperation(value="\u6279\u91cf\u8bbe\u7f6e\u5f00\u542f\u72b6\u6001\u53ca\u6362\u7b97\u7cfb\u6570")
    @RequestMapping(value={"/updateAutomaticWeighBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, Object>> updateAutomaticWeighBatch(@RequestBody List<WagonMaterialVO> vos) {
        return CommonResponse.success((String)"\u6279\u91cf\u5904\u7406\u6210\u529f\uff01", this.service.updateAutomaticWeighBatch(vos));
    }
}

